/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Util;

public class ChaseController
extends A3Controller
implements Runnable {
    Quat4d q;
    Vector3d v;
    double s;

    public ChaseController() {
        this.q = new Quat4d(0.0, 1.0, 0.0, 0.0);
        this.v = new Vector3d(0.0, 0.0, -5.0);
        this.s = 1.0;
    }

    public ChaseController(Matrix4d mc) {
        Matrix3d m = new Matrix3d();
        m.m00 = mc.m00;
        m.m01 = mc.m01;
        m.m02 = mc.m02;
        m.m10 = mc.m10;
        m.m11 = mc.m11;
        m.m12 = mc.m12;
        m.m20 = mc.m20;
        m.m21 = mc.m21;
        m.m22 = mc.m22;
        this.q = Util.matrix2quat(m);
        this.v = new Vector3d();
        mc.get(this.v);
        this.s = mc.getScale();
    }

    public ChaseController(Quat4d q, Vector3d v, double s) {
        this.q = new Quat4d(q);
        this.v = new Vector3d(v);
        this.s = s;
    }

    public ChaseController(Vector3d lookAt, Vector3d camera, Vector3d up, double s) {
        Quat4d quat;
        Vector3d front = new Vector3d();
        front.sub((Tuple3d)lookAt, (Tuple3d)camera);
        this.q = quat = Util.frontFacingQuat_CAMERA(front, up);
        this.v = new Vector3d(camera);
        this.s = s;
    }

    public ChaseController(Object ... params) {
        Quat4d quat;
        if (params.length != 4) {
            this.q = new Quat4d(0.0, 1.0, 0.0, 0.0);
            this.v = new Vector3d(0.0, 0.0, -5.0);
            this.s = 1.0;
            return;
        }
        Vector3d lookAt = (Vector3d)params[0];
        Vector3d camera = (Vector3d)params[1];
        Vector3d up = (Vector3d)params[2];
        double s = (Double)params[3];
        Vector3d front = new Vector3d();
        front.sub((Tuple3d)lookAt, (Tuple3d)camera);
        this.q = quat = Util.frontFacingQuat_CAMERA(front, up);
        this.v = new Vector3d(camera);
        this.s = s;
    }

    @Override
    public void init() {
        this.a3canvas.insertTaskIntoTimerLoop(this);
    }

    @Override
    public void stop() {
        this.a3canvas.removeTaskFromTimerLoop(this);
    }

    @Override
    public void run() {
        A3Object avatar = this.a3canvas.getAvatar();
        if (avatar == null) {
            return;
        }
        Quat4d aq = avatar.getQuat();
        Vector3d av = avatar.getLoc();
        double as = avatar.getScale();
        Quat4d cq = new Quat4d();
        cq.mul(aq, this.q);
        Vector3d cv = Util.trans(aq, this.v);
        cv.add((Tuple3d)av);
        double cs = this.s * as;
        this.a3canvas.setCameraLoc(cv);
        this.a3canvas.setCameraQuat(cq);
        this.a3canvas.setCameraScale(cs);
    }
}

