/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import javax.media.j3d.Transform3D;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.Motion;

public class MotionCameraController
extends A3Controller
implements Runnable {
    Thread t;
    volatile boolean stopRequest = false;
    Motion motion;
    long motionLength;
    String bone;
    long offsetTime;
    boolean pause = true;
    boolean loop = false;

    public MotionCameraController(Motion m, String b) {
        this.motion = m;
        this.bone = b;
        this.motionLength = (long)(this.motion.getMotionLength() * 1000.0);
    }

    @Override
    public void init() {
        this.stopRequest = false;
        this.pause = true;
        this.t = new Thread(this);
        this.t.start();
    }

    @Override
    public void stop() {
        this.stopRequest = true;
    }

    public void cue() {
        this.offsetTime = System.currentTimeMillis();
        this.pause = false;
    }

    public void changeMotion(Motion m) {
        this.pause = true;
        this.offsetTime = System.currentTimeMillis();
        this.motion = m;
        this.motionLength = (long)(this.motion.getMotionLength() * 1000.0);
    }

    public void reset() {
        this.pause = true;
        this.offsetTime = System.currentTimeMillis();
    }

    public void setLoop(boolean l) {
        this.loop = l;
    }

    @Override
    public void run() {
        while (!this.stopRequest) {
            if (this.pause) continue;
            long time = System.currentTimeMillis() - this.offsetTime;
            if (!this.loop && time > this.motionLength) continue;
            double t = (double)(time %= this.motionLength) / 1000.0;
            Transform3D trans = new Transform3D();
            this.calTrans(trans, this.bone, t);
            Vector3d cameraV = new Vector3d();
            Quat4d cameraQ = new Quat4d();
            double cameraS = trans.get(cameraQ, cameraV);
            this.a3canvas.setCameraLocImmediately(cameraV);
            this.a3canvas.setCameraQuatImmediately(cameraQ);
            this.a3canvas.setCameraScaleImmediately(cameraS);
            long elapsedTime = this.a3canvas.getUpdateInterval();
            try {
                Thread.sleep(elapsedTime);
            }
            catch (Exception exception) {}
        }
    }

    void calTrans(Transform3D trans, String bone, double time) {
        Transform3D t = this.motion.getTransform3D(bone, time);
        trans.mul(t, trans);
        String nextBone = this.motion.getParentBone(bone);
        if (nextBone == null) {
            return;
        }
        this.calTrans(trans, nextBone, time);
    }
}

