//---------------------------------------------------------------------------
//		C++ for CGI PreProcessor
//		(C)Copyright 2003 Y.Endou All rights reserved
//---------------------------------------------------------------------------
//		ver.1.0		2003/06		first version
//---------------------------------------------------------------------------
#ifndef __ACPP_LIB_CFG_H__
#define __ACPP_LIB_CFG_H__
//---------------------------------------------------------------------------
#include <string>
#include <list>
#include <fstream>
using namespace std;
//---------------------------------------------------------------------------
#define		kBuffSize		2000
//---------------------------------------------------------------------------
//unit104.cpp
//simple cfg file classs : "key=value" type cfg file
struct	Data {
		list <string> :: iterator mIt;					//line pointer
		string	mValue;									//value
};
class	ConfFile {
	public:												//Is setting all data to public good?
		list <string> mLine;							//cfg file line data
		map <string,struct Data> mData;					//key - value data
		string		 mPath;								//cfg file name
		bool		 mChange;							//change flag
		ConfFile(void);									//constructor
		ConfFile(const char *);							//constructor
		~ConfFile(void);								//destructor
		void	Clear(void);							//clear data
		bool	ReadFile(const char *);					//read key & value from file
		bool	SaveFile(void);							//save key & value from file
		bool	GetValue(const char *,bool);			//get bool data
		int		GetValue(const char *,int);				//get int data
		double	GetValue(const char *,double);			//get double data
		string	GetValue(const char *,const char *);	//get string data
		void	SetValue(const char *,bool);			//set bool data
		void	SetValue(const char *,int);				//set int data
		void	SetValue(const char *,double);			//set double data
		void	SetValue(const char *,const char *);	//set string data
		bool	KeyExist(const char *);					//dose key exist ?
		void	DelKey(const char *);					//delete key
		void	ToBeSaved(bool);						//mChange change
		int		GetData(map <string,string> *);			//get key value data
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------
