//---------------------------------------------------------------------------
//		ver.1.0		2004/03		author : Endou
//---------------------------------------------------------------------------
#ifdef		HAVE_CONFIG_H
#include	"config.h"
#endif
#include	"acpplib.h"
//---------------------------------------------------------------------------
string	time_str(time_t *);			//make time string. format is "Wdy, DD-Mon-YYYY HH:MM:SS GMT". ex. Sat, 24-Aug-2002 12:43:13 GMT
//---------------------------------------------------------------------------
void	setcookie(const char *pName,const char *pVal,time_t pExpire,const char *pPath,const char *pDomain)
//send cookie data
//parameters	*pName : cookie name
//				*pVal  : cookie data
//				pExpire : expire date. expire value is UNIX standard time which was returned from time() or mktime() function
//				pPath : cgi program path. No sets this parameter , the present environment will be set automatically.
//				pDomain : domain name which program exist
//return		none
{
	string	str;

	if(strlen(pName) == 0) return;
	str = string("Set-Cookie: ") + urlencode(pName);

	if(pVal != NULL)    str += "="               + urlencode(pVal)    + "; ";
	if(pExpire != 0)    str += "expires="        + time_str(&pExpire) + "; ";
	if(pDomain != NULL) str += string("domain=") + pDomain            + "; ";
	if(pPath != NULL)   str += string("path=")   + pPath              + "; ";

	set_header(str.c_str());
}
//---------------------------------------------------------------------------
string	time_str(time_t *pT)
//make time string. format is "Wdy, DD-Mon-YYYY HH:MM:SS GMT". ex. Sat, 24-Aug-2002 12:43:13 GMT
//parameter		*pT : UNIX standard time
//return		time string
{
	char	*wday[] = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
	char	*mon[]  = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
	char	s[40];
	struct tm *gmt;

	gmt = gmtime(pT);
	sprintf(s,"%s, %02d-%s-%4d %02d:%02d:%02d GMT",wday[gmt->tm_wday],gmt->tm_mday,mon[gmt->tm_mon]
												  ,gmt->tm_year+1900,gmt->tm_hour,gmt->tm_min,gmt->tm_sec);

	return(string(s));
}
//---------------------------------------------------------------------------
