//---------------------------------------------------------------------------
//		ver.1.0		2004/03		author : Endou
//---------------------------------------------------------------------------
#ifdef		HAVE_CONFIG_H
#include	"config.h"
#endif
#include	"acpplib.h"
#include	"conffile.h"
//---------------------------------------------------------------------------
ConfFile::ConfFile()
//constructor
{
	Clear();
	mChange = false;
}
//---------------------------------------------------------------------------
ConfFile::ConfFile(const char *pFileName)
//constructor
//parameter		*pFileName : Cfg file name
//return		none
{
	Clear();
	ReadFile(pFileName);
}
//---------------------------------------------------------------------------
ConfFile::~ConfFile()
//destructor
{
	if(mChange) SaveFile();
	Clear();
}
//---------------------------------------------------------------------------
void	ConfFile::Clear()
//clear data
{
	mLine.clear();
	mData.clear();
	mChange = true;
}
//---------------------------------------------------------------------------
bool	ConfFile::ReadFile(const char *pFileName)
//read key & value from file
//parameter		*pFileName : Cfg file name
//return		true : success , false : false
{
	struct Data	aData;
	int			n;
	char		buff[kBuffSize+1];
	ifstream	fin;
	list <string> :: iterator it;
	vector <string> v;

	mChange = false;
	mPath   = pFileName;			//restore file name
	fin.open(pFileName);
	if(!fin) return(false);

	while(fin.getline(buff,kBuffSize)) {
		//comment
		if((strlen(buff) == 0) ||
		   (buff[0] == '#')    ||
		   (buff[0] == ';')    ||
		   (buff[0] == '/' && buff[1] == '/') ||
		   (buff[0] == '[')) {
			mLine.push_back(buff);	//add line data
			continue;
		}
		//key - value data
		n = explode(buff,&v,'=',2);
		if(n == 1) v.push_back("");
		mLine.push_back(buff);		//add line data
		it = mLine.end();
		it--;
		aData.mIt    = it;
		aData.mValue = v[1];
		mData[v[0]]  = aData;		//add key - value data
	}

	fin.close();
	return(true);
}
//---------------------------------------------------------------------------
bool	ConfFile::SaveFile()
//save key & value from file
//parameter		none
//return		true : success , false : false
{
	list <string> :: iterator it;
	ofstream	fout;

	fout.open(mPath.c_str());
	if(!fout) return(false);

	for(it=mLine.begin();it!=mLine.end();it++) {
		fout << *it << endl;
	}

	fout.close();
	mChange = false;
	return(true);
}
//---------------------------------------------------------------------------
bool	ConfFile::GetValue(const char *pKey,bool pDefault)
//get bool data
//parameters	*pKey : key name
//				pDefault : default value. when key dose not exist
//return		value data
{
	string	value;

	if(KeyExist(pKey)) {
		value = mData[pKey].mValue;
		if(value == "1") return(true);
		if(value == "0") return(false);
		if(value == "true")  return(true);
		if(value == "false") return(false);
		return(false);
	}
	return(pDefault);
}
//---------------------------------------------------------------------------
int		ConfFile::GetValue(const char *pKey,int pDefault)
//get int data
//parameters	*pKey : key name
//				pDefault : default value. when key dose not exist
//return		value data
{
	string	value;

	if(KeyExist(pKey)) {
		value = mData[pKey].mValue;
		return(atoi(value.c_str()));
	}
	return(pDefault);
}
//---------------------------------------------------------------------------
double	ConfFile::GetValue(const char *pKey,double pDefault)
//get double data
//parameters	*pKey : key name
//				pDefault : default value. when key dose not exist
//return		value data
{
	string	value;

	if(KeyExist(pKey)) {
		value = mData[pKey].mValue;
		return(atof(value.c_str()));
	}
	return(pDefault);
}
//---------------------------------------------------------------------------
string	ConfFile::GetValue(const char *pKey,const char *pDefault)
//get string data
//parameters	*pKey : key name
//				pDefault : default value. when key dose not exist
//return		value data
{
	string	value;

	if(KeyExist(pKey)) {
		value = mData[pKey].mValue;
		return(value);
	}
	return(pDefault);
}
//---------------------------------------------------------------------------
void	ConfFile::SetValue(const char *pKey,bool pVal)
//set bool data
//parameters	*pKey : key name
//				pVal : value
//return		none
{
	if(pVal) SetValue(pKey,"1");
	  else   SetValue(pKey,"0");
}
//---------------------------------------------------------------------------
void	ConfFile::SetValue(const char *pKey,int pVal)
//set int data
//parameters	*pKey : key name
//				pVal : value
//return		none
{
	char	val[50];

	sprintf(val,"%d",pVal);
	SetValue(pKey,val);
}
//---------------------------------------------------------------------------
void	ConfFile::SetValue(const char *pKey,double pVal)
//set double data
//parameters	*pKey : key name
//				pVal : value
//return		none
{
	char	val[50];

	sprintf(val,"%f",pVal);
	SetValue(pKey,val);
}
//---------------------------------------------------------------------------
void	ConfFile::SetValue(const char *pKey,const char *pVal)
//set string data
//parameters	*pKey : key name
//				pVal : value
//return		none
{
	string			str;
	struct	Data	aData;
	list <string> :: iterator it;

	mChange = true;
	str     = string(pKey) + "=" + pVal;

	//already key exist
	if(KeyExist(pKey)) {
		mData[pKey].mValue = pVal;		//change value data
		it  = mData[pKey].mIt;
		*it = str;						//change line data
		return;
	}

	//new key
	mLine.push_back(str);				//add line data
	it = mLine.end();
	it--;
	aData.mIt    = it;
	aData.mValue = pVal;
	mData[pKey]  = aData;				//add key - value data
}
//---------------------------------------------------------------------------
bool	ConfFile::KeyExist(const char *pKey)
//dose key exist ?
//parameters	*pKey : key name
//return		true : found  , false : not found
{
	if(mData.end() != mData.find(pKey)) return(true);
	return(false);
}
//---------------------------------------------------------------------------
void	ConfFile::DelKey(const char *pKey)
//delete key
//parameters	*pKey : key name
//return		none
{
	list <string> :: iterator it;

	if(! KeyExist(pKey)) return;

	it = mData[pKey].mIt;
	*it= string("#") + *it;
	mData.erase(pKey);
	mChange = true;
}
//---------------------------------------------------------------------------
void	ConfFile::ToBeSaved(bool pFlag)
//mChange change
//parameter		pFlag : true : to be saved , false not to be saved
//return		none
{
	mChange = pFlag;
}
//---------------------------------------------------------------------------
int		ConfFile::GetData(map <string,string> *pData)
//get key value data
//parameter		*pData : set key & value data
//return		data number
{
	map <string,struct Data> :: iterator it;
	pair <string,string> p;

	pData->clear();
	for(it=mData.begin();it!=mData.end();it++) {
		p.first  = it->first;
		p.second = (it->second).mValue;
		pData->insert(p);
	}

	return(pData->size());
}
//---------------------------------------------------------------------------
