//---------------------------------------------------------------------------
#include "unit001.h"
//---------------------------------------------------------------------------
int		main(int argc,char *argv[])
{
	int		i,n;
	set		<string> :: iterator it;
	string	str;

	try {
		ClearGlobals();											//clear global valiables

		n = AnalizeCmdLine(argc,argv);							//analize command line

		if(! gCleanFlag && n > 0) {
			if(gVisibleFlag) cout << "  load project  : " << gProject << endl;
			AnalizeProject();									//read projectfile and analize
		}

		for(i=0;i<n;i++) {
			if(gVisibleFlag) cout << "  pre process   : " << gSrcFiles[i] << " --> " << gSrcFiles[i] << kTmpSfx << endl;
			PreProcess(gSrcFiles[i],gSrcFiles[i] + kTmpSfx);	//preprocessing source file
		}

		for(it=gIncFile.begin();it!=gIncFile.end();it++) {
			str = *it;
			if(gVisibleFlag) cout << "  pre process   : " << str << " --> " << str << kIncSfx << endl;
			PreProcess(str,str + kIncSfx);						//preprocessing include file
		}

		if(n > 0) {
			if(gVisibleFlag) cout << "  save project  : " << gProject << endl;
			WriteProject();										//rewrite project file with new parameters which collect source files
		}

		if(!gOnlyPreFlag) {
			if(gVisibleFlag) cout << "  exec cmd line : " << gCmdLine << endl;
			ExecCmdLine();										//execute command line. ie. compile & link
		}

		if(!gRemainFlag) {										//delete temp source files
			DeleteTmp();
		}

		gErrorNo = 0;
	} catch(string e) {
		if(gErrorNo == 0) gErrorNo = 1;
		cout << e << endl;
	} catch(...) {
		if(gErrorNo == 0) gErrorNo = 2;
		cout << "unknown error occued." << endl;
	}

	return(gErrorNo);
}
//---------------------------------------------------------------------------
