//---------------------------------------------------------------------------
#ifndef __Unit001H__
#define __Unit001H__
//---------------------------------------------------------------------------
//			C++ for CGI PreProcessor
//		(C)Copyright 2002 Y.Endou All rights reserved
//		This software helps to make CGI programs
//---------------------------------------------------------------------------
//	  ver.1.0	 2003/06	first version
//---------------------------------------------------------------------------
#ifdef		HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<sys/wait.h>

#include	<string>
#include	<map>
#include	<set>
#include	<vector>
#include	<iostream>
#include	<fstream>
using namespace std;
//---------------------------------------------------------------------------
#define		kVersion		"C++ for CGI acpp ver.1.0 "
#define		kCopyRight		"(C)Copyright 2003 Y.Endou All rights reserved"
#define		kCleanFlag		"-clean"			//ignore old project file. ie. clean given & pragma parameters
#define		kRemainFlag		"-remain"			//remain temp source file
#define		kVisibleFlag	"-visible"			//print processing process
#define		kOnlyPreFlag	"-pre"				//preprocess only
#define		kVersionFlag	"-version"			//show acpp version
#define		kProjectFlag	"-project"			//project file name
#define		kGCC			"g++"				//default compiler
#define		kCC				"XCC"				//altanate compiler
#define		kProject		"acpp.project.cpp"	//default project file name
#define		kTmpSfx			"_acpp.cpp"			//temp file suffix
#define		kIncSfx			"_acpp.h"			//temp include file suffix
#define		kAcppLibs		"-lacpp"			//link with acpp libs switch
//---------------------------------------------------------------------------
//unit002.cpp
extern	vector	<string> gSrcFiles;			//source file names
extern	set		<string> gIncFile;			//include file name
extern	string	gCmdLine;					//command line strings
extern	bool	gCleanFlag;					//ignore project file flag
extern	bool	gRemainFlag;				//remain temp source file flag
extern	bool	gVisibleFlag;				//print processing process
extern	bool	gOnlyPreFlag;				//preprocess only
extern	string	gProject;					//project file name
extern	string	gCC;						//compiler name
//------------------------------------
//unit003.lex
extern	string		gType;							//given parameters type
extern	map <string,map <string,string> > gGiven;	//given type name;        --> gGiven[filename][name] = type
extern	map <string,set <string> > gHeader;			//#pragma HEADER strings  --> gHeader[filename].insert(parameters)
extern	map <string,set <string> > gHead;			//#pragma HEAD   strings  --> gHead[filename].insert(parameters)
extern	map <string,set <string> > gPragma;			//#pragma COUT_HEADER     --> gPragma[filename].insert(COUT_HEADER)
													//#pragma COUT_HEAD       --> gPragma[filename].insert(COUT_HEAD)
													//#pragma END_HTML        --> gPragma[filename].insert(END_HTML)
extern	map <string,set <string> > gConfFile;		//#configure "file.conf"  --> gConfFile[filename].insert(file.conf)
extern	string		gStr;							//temp buffer
//------------------------------------
//unit004.cpp
extern	int			gErrorNo;				//error code
//------------------------------------
//unit005.lex
extern	string		gSrcFileName;			//source file name
extern	ofstream	gOut;					//temp file stream
//---------------------------------------------------------------------------
//unit002.cpp
void	ClearGlobals(void);					//clear global valiables
int		AnalizeCmdLine(int,char **);		//analize command line
void	Usage(void);						//print usage
//------------------------------------
//unit003.lex
void	AnalizeProject(void);				//analize project file
//------------------------------------
//unit004.cpp
void	PreProcess(string,string);			//preprocessor execute
int		ExecCmdLine(void);					//execute command line. ie. compile & link
string	Suffix(string);						//split suffix from string
int		explode(const char *,vector <string> *,char pDelim=',',int pLimit=0);//separate string by delimiter character
string	implode(vector <string> *,string pGlue=",");//combine each token
string	trim(string *);						//delete white space top and end of string
void	DeleteTmp(void);					//delete temp source file and temp include file
string	escape_encode(const char *);		//escape strings. ie (CR)->\n (LF)->\r (\)->\\ (")->\"
//------------------------------------
//unit005.lex
void	LexicalAnalize(FILE *fin);			//analize source file
//------------------------------------
//unit006.cpp
void	WriteProject(void);					//rewrite project file with new parameters which collect source files
void	WriteProjectHead(ofstream *);		//write project file header
void	WriteGivenParameters(ofstream *);	//write given parameters to project file
void	WritePragmaParameters(ofstream *);	//write pragma parameters to project file
void	WriteConfFilesParameters(ofstream *);//write configure files to project file
void	WriteMainRoutine(ofstream *);		//write main routine to project file
void	WritetStoreGivenfunc(ofstream *);	//substitute gRequest[given] for given value
void	WriteExecPragmafunc(ofstream *);	//write ExecPragma function
void	WriteReadConffunc(ofstream *);		//write ReadConf function
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------
