//---------------------------------------------------------------------------
#include "unit001.h"
int					gPragmaFlag;	//number of #pragma parameters
map <string,string>	gUniqueGiven;	//given parameters gUniqueGiven[name] = gType
set <string>		gUniqueHeader;	//HEADER parameters
set <string>		gUniqueHead;	//HEAD   parameters
set <string>		gUniquePragma;	//other  parameters
set <string>		gUniqueConfFile;//configure files
//---------------------------------------------------------------------------
void	WriteProject()
//write project file
//parameter		none
//return		none
{
	ofstream	fout;
	string		error;

	fout.open(gProject.c_str());
	if(! fout) {
		gErrorNo = 1;
		error = "acpp error (WriteProject): can not write " + gProject + " file";
		throw(error);
	}

	WriteProjectHead(&fout);			//write project file header
	WriteGivenParameters(&fout);		//write given parameters to project file
	WritePragmaParameters(&fout);		//write pragma parameters to project file
	WriteConfFilesParameters(&fout);	//write configure files to project file
	WriteMainRoutine(&fout);			//write main routine to project file
	if(gUniqueGiven.size() != 0)	WritetStoreGivenfunc(&fout);	//substitute gRequest[given] for given value
	if(gPragmaFlag != 0)			WriteExecPragmafunc(&fout);		//write ExecPragma function
	if(gUniqueConfFile.size() != 0)	WriteReadConffunc(&fout);		//write ReadConf function

	fout.close();
}
//---------------------------------------------------------------------------
void	WriteProjectHead(ofstream *pFout)
//write project file header
//parameter		fout : output file stream;
//return		none
{
	*pFout << "//Do not edit this project file. This file will be rewritten by acpp." << endl;
	*pFout << "//" kVersion kCopyRight "\n" << endl;
	*pFout << "#include\t<acpplib.h>" << endl;
	*pFout << "#include\t<conffile.h>\n" << endl;
}
//---------------------------------------------------------------------------
void	WriteGivenParameters(ofstream *pFout)
//write given parameters to project file
//parameter		fout : output file stream;
//return		none
{
	map <string,map <string,string> > :: iterator file;
	map <string,string> :: iterator it;
	string		str,fname;

	gUniqueGiven.clear();
	if(gGiven.size() == 0) return;

	//write file information
	*pFout << "/*--------------------" << endl;
	for(file=gGiven.begin();file!=gGiven.end();file++) {
		fname = file->first;
		if(gGiven[fname].size() == 0) continue;
		*pFout << "<FILE:" << fname << ">" << endl;
		for(it=gGiven[fname].begin();it!=gGiven[fname].end();it++) {
			if((it->first).find("[]") != string::npos) {
				str = it->first;
				str.resize(str.length() - 2);
				*pFout << "map <int," << it->second << "> " << str << ";" << endl;
			} else {
				*pFout << it->second << "\t" << it->first << ";" << endl;
			}
			gUniqueGiven[it->first] = it->second;
		}
		*pFout << "</FILE>" << endl;
	}
	*pFout << "--------------------*/\n" << endl;

	//write given real parameter
	for(it=gUniqueGiven.begin();it!=gUniqueGiven.end();it++) {
		if((it->first).find("[]") != string::npos) {
			str = it->first;
			str.resize(str.length() - 2);
			*pFout << "map <int," << it->second << "> " << str << ";" << endl;
		} else {
			*pFout << it->second << "\t" << it->first << ";" << endl;
		}
	}

	*pFout  << endl;
}
//---------------------------------------------------------------------------
void	WritePragmaParameters(ofstream *pFout)
//write configure files to project file
//parameter		fout : output file stream;
//return		none
{
	map <string,set <string> > :: iterator it;
	set <string> :: iterator item;
	vector <string> v;
	string		fname;

	gUniqueHeader.clear();
	gUniqueHead.clear();
	gUniquePragma.clear();
	if(gHeader.size() + gHead.size() + gPragma.size() == 0) return;

	//write file information
	*pFout << "/*--------------------" << endl;
	for(it=gHeader.begin();it!=gHeader.end();it++) {
		fname = it->first;
		if(gHeader[fname].size() == 0) continue;
		*pFout << "<FILE:" << fname << ">" << endl;
		for(item=gHeader[fname].begin();item!=gHeader[fname].end();item++) {
			*pFout << "#pragma\tHEADER\t" << *item << endl;
			gUniqueHeader.insert(*item);
		}
		*pFout << "</FILE>" << endl;
	}
	if(gUniqueHeader.size() != 0)	*pFout << endl;

	for(it=gHead.begin();it!=gHead.end();it++) {
		fname = it->first;
		if(gHead[fname].size() == 0) continue;
		*pFout << "<FILE:" << fname << ">" << endl;
		for(item=gHead[fname].begin();item!=gHead[fname].end();item++) {
			*pFout << "#pragma\tHEAD\t" << *item << endl;
			gUniqueHead.insert(*item);
		}
		*pFout << "</FILE>" << endl;
	}
	if(gUniqueHead.size() != 0)	*pFout << endl;

	for(it=gPragma.begin();it!=gPragma.end();it++) {
		fname = it->first;
		if(gPragma[fname].size() == 0) continue;
		*pFout << "<FILE:" << fname << ">" << endl;
		for(item=gPragma[fname].begin();item!=gPragma[fname].end();item++) {
			*pFout << "#pragma\t" << *item << endl;
			gUniquePragma.insert(*item);
		}
		*pFout << "</FILE>" << endl;
	}

	*pFout << "--------------------*/\n" << endl;
	gPragmaFlag = gUniqueHeader.size() + gUniqueHead.size() + gUniquePragma.size();
}
//---------------------------------------------------------------------------
void	WriteConfFilesParameters(ofstream *pFout)
//write pragma parameters to project file
//parameter		fout : output file stream;
//return		none
{
	map <string,set <string> > :: iterator it;
	set <string> :: iterator item;
	string		fname;

	gUniqueConfFile.clear();
	if(gConfFile.size() == 0) return;

	//write configure file information
	*pFout << "/*--------------------" << endl;
	for(it=gConfFile.begin();it!=gConfFile.end();it++) {
		fname = it->first;
		if(gConfFile[fname].size() == 0) continue;
		*pFout << "<FILE:" << fname << ">" << endl;
		for(item=gConfFile[fname].begin();item!=gConfFile[fname].end();item++) {
			*pFout << "#configure\t\"" << *item << "\"" << endl;
			gUniqueConfFile.insert(*item);
		}
		*pFout << "</FILE>" << endl;
	}
	*pFout << "--------------------*/\n" << endl;
}
//---------------------------------------------------------------------------
void	WriteMainRoutine(ofstream *pFout)
//write main routine to project file
//parameter		fout : output file stream;
//return		none
{
	*pFout << "int\tmain(int argc,char *argv[],char *env[])\n{" << endl;
	if(gUniquePragma.find("NO_CGI") != gUniquePragma.end()) {
		*pFout << "\ttry {\n\t\tGetParams(argc,argv,env,false);" << endl;
	} else {
		*pFout << "\ttry {\n\t\tGetParams(argc,argv,env,true);" << endl;
	}
	if(gUniqueConfFile.size() != 0)	*pFout << "\t\tReadConf();" << endl;
	if(gUniqueGiven.size() != 0)	*pFout << "\t\tStoreGiven();" << endl;
	if(gPragmaFlag != 0)			*pFout << "\t\tExecPragma();" << endl;
	*pFout << "\t\tstart();\t\t\t//CGI main routine" << endl;
	*pFout << "\t} catch(string err) {\n";
	*pFout << "\t\tExceptionMsg(err.c_str());\n\t} catch(...) {\n";
	*pFout << "\t\tExceptionMsg(\"unknown error occured\");\n\t}\n}\n" << endl;
}
//---------------------------------------------------------------------------
void	WritetStoreGivenfunc(ofstream *pFout)
//substitute gRequest[given] for given value
//parameter		fout : output file stream;
//return		none
{
	map <string,string> ::iterator it;
	string	str;

	*pFout << "void\tStoreGiven()\n//substitute gRequest[given] for given value\n{" << endl;

	for(it=gUniqueGiven.begin();it!=gUniqueGiven.end();it++) {
		if((it->first).find("[]") != string::npos) {
			str = it->first;
			str.resize(str.length() - 2);
			*pFout << "\tif(isset(\"" << it->first << "\")) StoreGivenArray(&" << str << ",\"" << it->first << "\");" << endl;
			*pFout << "\t  else " << str << ".clear();" << endl;
		} else {
			if(it->second == "string") {
				*pFout << "\tif(isset(\"" << it->first << "\")) " << it->first << " = gRequest[\"" << it->first << "\"];" << endl;
				*pFout << "\t  else " << it->first << " = \"\";" << endl;
			}
			if(it->second == "int") {
				*pFout << "\tif(isset(\"" << it->first << "\")) " << it->first << " = atoi(gRequest[\"" << it->first << "\"].c_str());" << endl;
				*pFout << "\t  else " << it->first << " = 0;" << endl;
			}
			if(it->second == "float") {
				*pFout << "\tif(isset(\"" << it->first << "\")) " << it->first << " = atof(gRequest[\"" << it->first << "\"].c_str());" << endl;
				*pFout << "\t  else " << it->first << " = 0.0;" << endl;
			}
			if(it->second == "double") {
				*pFout << "\tif(isset(\"" << it->first << "\")) " << it->first << " = atof(gRequest[\"" << it->first << "\"].c_str());" << endl;
				*pFout << "\t  else " << it->first << " = 0.0;" << endl;
			}
			if(it->second == "long") {
				*pFout << "\tif(isset(\"" << it->first << "\")) " << it->first << " = atol(gRequest[\"" << it->first << "\"].c_str());" << endl;
				*pFout << "\t  else " << it->first << " = 0L;" << endl;
			}
			if(it->second == "short") {
				*pFout << "\tif(isset(\"" << it->first << "\")) " << it->first << " = atoi(gRequest[\"" << it->first << "\"].c_str());" << endl;
				*pFout << "\t  else " << it->first << " = 0;" << endl;
			}
			if(it->second == "bool")  {
				*pFout << "\tif(isset(\"" << it->first << "\")) {" << endl;
				*pFout << "\t\tif(gRequest[\"" << it->first << "\"] == \"on\") " << it->first << " = true;" << endl;
				*pFout << "\t\t  else " << it->first << " = false;" << endl;
				*pFout << "\t} else {" << endl;
				*pFout << "\t\t" << it->first << " = false;" << endl;
				*pFout << "\t}" << endl;
			}
		}
	}

	*pFout << "}\n" << endl;
}
//---------------------------------------------------------------------------
void	WriteExecPragmafunc(ofstream *pFout)
//write ExecPragma function
//parameter		fout : output file stream;
//return		none
{
	vector <string> v;
	set <string> :: iterator it;
	int				n;

	*pFout << "void\tExecPragma()\n{" << endl;

	//HEADER parameters
	for(it=gUniqueHeader.begin();it!=gUniqueHeader.end();it++) {
		*pFout << "\tset_header(\"" << escape_encode(it->c_str()) << "\");" << endl;
	}
	if(gUniqueHeader.size() != 0) *pFout << endl;

	//HEAD   parameters
	for(it=gUniqueHead.begin();it!=gUniqueHead.end();it++) {
		*pFout << "\tset_head(\"" << escape_encode(it->c_str()) << "\");" << endl;
	}
	if(gUniqueHead.size() != 0) *pFout << endl;

	//other  parameters
	if(gUniquePragma.find("COUT_HEADER") != gUniquePragma.end()) {
		*pFout << "\tcout_header();" << endl;
	}

	if(gUniquePragma.find("COUT_HEAD") != gUniquePragma.end()) {
		*pFout << "\tcout_head();" << endl;
	}

	if(gUniquePragma.find("END_HTML") != gUniquePragma.end()) {
		*pFout << "\tatexit(end_html);" << endl;
	}

	*pFout << "}\n" << endl;
}
//---------------------------------------------------------------------------
void	WriteReadConffunc(ofstream *pFout)
//write ReadConf function
//parameter		fout : output file stream;
//return		none
{
	set <string> :: iterator it;

	*pFout << "void\tReadConf()\n{" << endl;
	*pFout << "\tmap <string,struct Data> :: iterator it;" << endl;
	*pFout << "\tstring\t\tkey,value;" << endl;
	*pFout << "\tConfFile\t*aConfFile;\n" << endl;

	*pFout << "\tgConf.clear();" << endl;
	*pFout << "\taConfFile = new ConfFile();" << endl;
	for(it=gUniqueConfFile.begin();it!=gUniqueConfFile.end();it++) {
		*pFout << "\taConfFile->ReadFile(\"" << *it << "\");" << endl;
	}
	*pFout << "\tfor(it=(aConfFile->mData).begin();it!=(aConfFile->mData).end();it++) {" << endl;
	*pFout << "\t\tkey   = it->first;" << endl;
	*pFout << "\t\tvalue = (it->second).mValue;" << endl;
	*pFout << "\t\tgConf[key]    = value;" << endl;
	*pFout << "\t\tgRequest[key] = value;" << endl;
	*pFout << "\t\tgIsSet.insert(key);" << endl;
	*pFout << "\t}" << endl;
	*pFout << "\tdelete aConfFile;" << endl;
	*pFout << "}" << endl;
}
//---------------------------------------------------------------------------
