//---------------------------------------------------------------------------
//		C++ for CGI PreProcessor
//		(C)Copyright 2003 Y.Endou All rights reserved
//		This software helps to make CGI programs
//---------------------------------------------------------------------------
//		ver.1.0		2003/06		first version
//---------------------------------------------------------------------------
#ifndef __ACPP_LIB_H__
#define __ACPP_LIB_H__
//---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/file.h> 
#include <string>
#include <map>
#include <vector>
#include <set>
#include <iostream>
#include <fstream>
using namespace std;
//---------------------------------------------------------------------------
#define		kVersion	"acpp library ver.1.0 "
#define		kCopyRight	"(C)Copyright 2003 Y.Endou All rights reserved"
//---------------------------------------------------------------------------
//unit100.cpp
extern	set <string> gHeader;				//HTTP header queue
extern	set <string> gHead;					//HTML header queue
extern	string gBody;						//BODY tag strings
//------------------------------------
//unit101.cpp
extern	map	<string,string>	gEnv;			//enviroment parameters
extern	map	<string,string>	gCookie;		//cookie parameters
extern	map	<string,string>	gCGI;			//CGI(POST or GET) parameters
extern	map	<string,string>	gConf;			//configure file parameters
extern	map	<string,string>	gRequest;		//All(CGI,env,cookie) parameters
extern	set	<string>		gIsSet;			//for isset()
//-----------------
extern	string	gCONTENT_LENGTH;			//CGI data (byte)
extern	string	gCONTENT_TYPE;				//CGI content type
extern	string	gHTTP_CLIENT_IP;			//client IP address(via Proxy)
extern	string	gHTTP_COOKIE;				//cookie data
extern	string	gHTTP_FROM;					//client IP address
extern	string	gHTTP_HOST;					//server name
extern	string	gHTTP_REFERER;				//link address
extern	string	gHTTP_USER_AGENT;			//client OS,Name,version,etc...
extern	string	gQUERY_STRING;				//GET data
extern	string	gREMOTE_ADDR;				//client IP address
extern	string	gREMOTE_HOST;				//client name
extern	string	gREQUEST_METHOD;			//method (POST/GET)
extern	string	gSCRIPT_NAME;				//script name
extern	string	gSERVER_ADDR;				//server IP address
extern	string	gSERVER_NAME;				//server name
extern	string	gTZ;						//server time zone string
//-----------------
extern	string	gAPP_PATH;					//program full path
extern	string	gAppName;					//program name
extern	string	gCGI_STRING;				//POST/GET raw data
//---------------------------------------------------------------------------
//acpp.project.cpp
void	StoreGiven(void);					//substitute gCGI[given] for given value
void	ExecPragma(void);					//execute pragma command
void	ReadConf(void);						//read configure files
void	start(void);						//CGI main routine
//------------------------------------
//unit100.cpp
void	set_header(const char *);					//add HTTP response header string to gHeader
void	set_head(const char *);						//add HTML header string to gHead
void	clear_header(void);							//clear gHeader
void	clear_head(void);							//clear gHead
void	cout_header(void);							//send gHeader data
void	cout_head(void);							//send gHead data
#define	begin_html	cout_head						//begin_html() is alias
void	end_html(void);								//print </BODY>\n</HTML>\n
//------------------------------------
//unit101.cpp
void	GetParams(int,char**,char **,bool);			//get all(CGI environ cookie) parameters
int		StoreGivenArray(map <int,string> *,char *);	//store array data from form  ex. f[]
int		StoreGivenArray(map <int,int>    *,char *);	//store array data from form  ex. f[]
int		StoreGivenArray(map <int,float>  *,char *);	//store array data from form  ex. f[]
int		StoreGivenArray(map <int,double> *,char *);	//store array data from form  ex. f[]
int		StoreGivenArray(map <int,long>   *,char *);	//store array data from form  ex. f[]
int		StoreGivenArray(map <int,short>  *,char *);	//store array data from form  ex. f[]
int		StoreGivenArray(map <int,bool>   *,char *);	//store array data from form  ex. f[]
void	ExceptionMsg(const char *);					//display exception message
bool	isset(string);								//is set value ?
bool	isset_CGI(string);							//is set value in CGI ?
bool	isset_Env(string);							//is set value in Enviroment ?
bool	isset_Cookie(string);						//is set value in Cookie ?
bool	isset_Conf(string);							//is set value in Configure files ?
//------------------------------------
//unit102.cpp
void	setcookie(const char *,const char *pVal=NULL,time_t pExpire=0,const char *pPath=NULL,const char *pDomain=NULL);//send cookie data
//------------------------------------
//unit103.cpp
void	print_v(map <int,string> *,const char *pName=NULL);		//print all data for debug
void	print_v(map <string,string> *,const char *pName=NULL);	//print all data for debug
void	print_v(vector <string> *,const char *pName=NULL);		//print all data for debug
int		explode(const char *,vector <string> *,char pDelim=',',int pLimit=0);//separate string by special character
string	implode(vector <string> *,string pGlue=",");			//combine each token
string	trim(string *);											//delete white space top and end of string
string	urlencode(const char *);								//url encode
string	urldecode(const char *);								//url decode
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------
