//---------------------------------------------------------------------------
//		ver.1.0		2004/03		author : Endou
//---------------------------------------------------------------------------
#ifdef		HAVE_CONFIG_H
#include	"config.h"
#endif
#include	"acpplib.h"
//---------------------------------------------------------------------------
map	<string,string>	gEnv;			//enviroment parameters
map	<string,string>	gCookie;		//cookie parameters
map	<string,string>	gCGI;			//CGI(POST or GET) parameters
map	<string,string>	gConf;			//configure file parameters
multimap <string,string> gCGI2;		//CGI(POST or GET) parameters allow overlapping
map	<string,string>	gRequest;		//All(CGI,env,cookie) parameters
set	<string>		gIsSet;			//for isset()
vector	<string>	gDelFiles;		//must be deleted file name array
//-----------------
string	gCONTENT_LENGTH;			//CGI data (byte)
string	gCONTENT_TYPE;				//CGI content type
string	gHTTP_CLIENT_IP;			//client IP address(via Proxy)
string	gHTTP_COOKIE;				//cookie data
string	gHTTP_FROM;					//client IP address
string	gHTTP_HOST;					//server name
string	gHTTP_REFERER;				//link address
string	gHTTP_USER_AGENT;			//client OS,Name,version,etc...
string	gQUERY_STRING;				//GET data
string	gREMOTE_ADDR;				//client IP address
string	gREMOTE_HOST;				//client name
string	gREQUEST_METHOD;			//method (POST/GET)
string	gSCRIPT_NAME;				//script name
string	gSERVER_ADDR;				//server IP address
string	gSERVER_NAME;				//server name
string	gTZ;						//server time zone string
//-----------------
string	gAPP_PATH;					//program full path
string	gAppName;					//program name
string	gCGI_STRING;				//POST/GET raw data
//---------------------------------------------------------------------------
void	GetEnvData(char **);		//get enviroment parameters
void	GetCGIData(void);			//get CGI parameters im method of POST or GET
void	GetCookieData(void);		//get cookie parameters
void	GetUploadFiles(void);		//get uploaded files from stdin
char	*mgets(char *,int,char *,char *,int *);	//get 1 line from memory data
string	extract_string(string *);	//extract string between " "
void	DeleteTmpFile(void);		//delete temp files from INPUT TYPE=FILE
void	SetCGIData(string,string);	//store key & val to gCGI,gRequest,gIsSet,gCGI2
//---------------------------------------------------------------------------
void	GetParams(int pArgc,char *pArgv[],char *pEnv[],bool pFlag)
//get all(CGI environ cookie) parameters
//parameter		*pEnv[] : enviroment argument
//				pFlag : exec GetCGIData() flag , true : exec  false : not exec
//return			none
{
	vector <string> v;
	int		n;

	//clear globals
	gEnv.clear();
	gCookie.clear();
	gCGI.clear();
	gCGI2.clear();
	gRequest.clear();
	gIsSet.clear();
	gDelFiles.clear();

	GetEnvData(pEnv);				//enviroment parameters
	GetCookieData();				//prepare cookie data
	if(pFlag) {						//prepare CGI(Form) data
		if(gCONTENT_TYPE.find("multipart") == string::npos) {
			GetCGIData();
		} else {
			GetUploadFiles();
			atexit(DeleteTmpFile);
		}
	}

	//some globals
	gAPP_PATH = pArgv[0];
	n = explode(gAPP_PATH.c_str(),&v,'/');	//assumed UNIX : / is sepalator
	gAppName = v[n-1];
}
//---------------------------------------------------------------------------
void	GetEnvData(char *pEnv[])
//get enviroment parameters
//parameter		*pEnv[] : enviroment argument
//return		gEnv[],gCGI[] : enviroment argument
{
	vector <string> v;
	int		i,n;

	for(i=0;pEnv[i] != NULL;i++) {
		n = explode(pEnv[i],&v,'=',2);
		if(n == 1) v.push_back("");
		gEnv[v[0]]     = v[1];
		gRequest[v[0]] = v[1];		//also store gRequest[]
		gIsSet.insert(v[0]);		//also set gIsSet

		if(v[0] == "CONTENT_LENGTH")  gCONTENT_LENGTH  = v[1];
		if(v[0] == "HTTP_CLIENT_IP")  gHTTP_CLIENT_IP  = v[1];
		if(v[0] == "HTTP_COOKIE")     gHTTP_COOKIE     = v[1];
		if(v[0] == "HTTP_FROM")       gHTTP_FROM       = v[1];
		if(v[0] == "HTTP_HOST")       gHTTP_HOST       = v[1];
		if(v[0] == "HTTP_REFERER")    gHTTP_REFERER    = v[1];
		if(v[0] == "HTTP_USER_AGENT") gHTTP_USER_AGENT = v[1];
		if(v[0] == "QUERY_STRING")    gQUERY_STRING    = v[1];
		if(v[0] == "REMOTE_ADDR")     gREMOTE_ADDR     = v[1];
		if(v[0] == "REMOTE_HOST")     gREMOTE_HOST     = v[1];
		if(v[0] == "REQUEST_METHOD")  gREQUEST_METHOD  = v[1];
		if(v[0] == "SCRIPT_NAME")     gSCRIPT_NAME     = v[1];
		if(v[0] == "SERVER_ADDR")     gSERVER_ADDR     = v[1];
		if(v[0] == "SERVER_NAME")     gSERVER_NAME     = v[1];
		if(v[0] == "TZ")              gTZ              = v[1];
	}
}
//---------------------------------------------------------------------------
void	GetCGIData()
//get CGI parameters im method of POST or GET
//parameter		none
//return		gCGI[]
{
	char	*aBuffer;
	long	aLength;
	vector <string> v,s;
	string	key,val;
	string	error;
	int		i,n,m;
	unsigned int	pos;

	//get CGI string to aBuffer
	if(gREQUEST_METHOD == "POST") {		//POST method
		aLength = atol(gCONTENT_LENGTH.c_str());
		if(aLength == 0) return;
		aBuffer = (char *)malloc(sizeof(char) * (aLength + 2));
		if(aBuffer == NULL) {
			error = "error (GetCGIData) :can not get buffer,not enough memory.";
			throw(error);
		}
		cin.read(aBuffer,aLength);
		aBuffer[aLength] = '\0';
		gCGI_STRING = aBuffer;
		n = explode(aBuffer,&s,'&');	//separate term
		free(aBuffer);
	} else {							//GET method
		gCGI_STRING = gQUERY_STRING;
		n = explode(gQUERY_STRING.c_str(),&s,'&');	//separate term
	}

	for(i=0;i<n;i++) {
		m = explode(s[i].c_str(),&v,'=',2);	//separate key & value
		if(m == 1) v.push_back("");
		key = urldecode(v[0].c_str());		//url decode
		pos = key.rfind(".");
		if(pos != string::npos) key.replace(pos,1,"_");	// change '.' to '_'
		val = urldecode(v[1].c_str());		//url decode
		SetCGIData(key,val);				//store key & val
	}
}
//---------------------------------------------------------------------------
void	GetCookieData()
//get cookie parameters
{
	vector	<string> v,w;
	int		i,n,m;
	string	key,val;

	if(gHTTP_COOKIE.empty()) return;
	n = explode(gHTTP_COOKIE.c_str(),&v,';');
	for(i=0;i<n;i++) {
		v[i] = trim(&v[i]);
		m = explode(v[i].c_str(),&w,'=');
		if(m == 1) w.push_back("");
		key = urldecode(w[0].c_str());
		val = urldecode(w[1].c_str());
		gCookie[key]  = val;
		gRequest[key] = val;		//also store gRequest[]
		gIsSet.insert(key);			//also set gIsSet
	}
}
//---------------------------------------------------------------------------
int		StoreGivenArray(map <int,string> *pV,char *pName)
//store array data from form  ex. f[]
//parameter		*pV : given value
//				*pName : paramater name
//return		number of array
{
	multimap <string,string> ::iterator it;
	pair <int,string> p;
	int		i;

	pV->clear();
	for(i=0,it=gCGI2.begin();it!=gCGI2.end();it++) {
		if(it->first == pName) {
			p.first = i;
			p.second = it->second;
			pV->insert(p);
			i++;
		}
	}
	return(pV->size());
}
//---------------------------------------------------------------------------
int		StoreGivenArray(map <int,int> *pV,char *pName)
//store array data from form  ex. f[]
//parameter		*pV : given value
//				*pName : paramater name
//return		number of array
{
	multimap <string,string> ::iterator it;
	pair <int,int> p;
	int		i;

	pV->clear();
	for(i=0,it=gCGI2.begin();it!=gCGI2.end();it++) {
		if(it->first == pName) {
			p.first  = i;
			p.second = atoi((it->second).c_str());
			pV->insert(p);
			i++;
		}
	}
	return(pV->size());
}
//---------------------------------------------------------------------------
int		StoreGivenArray(map <int,float> *pV,char *pName)
//store array data from form  ex. f[]
//parameter		*pV : given value
//				*pName : paramater name
//return		number of array
{
	multimap <string,string> ::iterator it;
	pair <int,float> p;
	int		i;

	pV->clear();
	for(i=0,it=gCGI2.begin();it!=gCGI2.end();it++) {
		if(it->first == pName) {
			p.first  = i;
			p.second = atof((it->second).c_str());
			pV->insert(p);
			i++;
		}
	}
	return(pV->size());
}
//---------------------------------------------------------------------------
int		StoreGivenArray(map <int,double> *pV,char *pName)
//store array data from form  ex. f[]
//parameter		*pV : given value
//				*pName : paramater name
//return		number of array
{
	multimap <string,string> ::iterator it;
	pair <int,double> p;
	int		i;

	pV->clear();
	for(i=0,it=gCGI2.begin();it!=gCGI2.end();it++) {
		if(it->first == pName) {
			p.first  = i;
			p.second = atof((it->second).c_str());
			pV->insert(p);
			i++;
		}
	}
	return(pV->size());
}
//---------------------------------------------------------------------------
int		StoreGivenArray(map <int,long> *pV,char *pName)
//store array data from form  ex. f[]
//parameter		*pV : given value
//				*pName : paramater name
//return		number of array
{
	multimap <string,string> ::iterator it;
	pair <int,long> p;
	int		i;

	pV->clear();
	for(i=0,it=gCGI2.begin();it!=gCGI2.end();it++) {
		if(it->first == pName) {
			p.first  = i;
			p.second = atol((it->second).c_str());
			pV->insert(p);
			i++;
		}
	}
	return(pV->size());
}
//---------------------------------------------------------------------------
int		StoreGivenArray(map <int,short> *pV,char *pName)
//store array data from form  ex. f[]
//parameter		*pV : given value
//				*pName : paramater name
//return		number of array
{
	multimap <string,string> ::iterator it;
	pair <int,short> p;
	int		i;

	pV->clear();
	for(i=0,it=gCGI2.begin();it!=gCGI2.end();it++) {
		if(it->first == pName) {
			p.first  = i;
			p.second = atoi((it->second).c_str());
			pV->insert(p);
			i++;
		}
	}
	return(pV->size());
}
//---------------------------------------------------------------------------
int		StoreGivenArray(map <int,bool> *pV,char *pName)
//store array data from form  ex. f[]
//parameter		*pV : given value
//				*pName : paramater name
//return		number of array
{
	multimap <string,string> ::iterator it;
	pair <int,bool> p;
	int		i;

	pV->clear();
	for(i=0,it=gCGI2.begin();it!=gCGI2.end();it++) {
		if(it->first == pName) {
			p.first  = i;
			if(it->second == "on") p.second = true;
			  else				   p.second = false;
			pV->insert(p);
			i++;
		}
	}
	return(pV->size());
}
//---------------------------------------------------------------------------
void	GetUploadFiles()
//get uploaded files from stdin
//parameter		none
//return		none
{
	int		fd,n;
	long	len;
	size_t	flen;
	char	*sp,*data,*spe,*begin;
	char	*tmp_path="acpp_XXXXXX";
	char	path[100],buff[2001],boundary[1000],end_boundary[1000];
	bool	flag;
	vector <string> v;
	string	key,val,file,file_name,file_mime,error;

	len = atol(gCONTENT_LENGTH.c_str());
	if(len == 0) return;
	data = (char *)malloc(sizeof(char) * (len + 2));
	if(data == NULL) {
		error = "error (GetUploadFiles) : can not get buffer,not enough memory.";
		throw(error);
	}
	cin.read(data,len);							//get POST data from stdin
	sp  = data;
	spe = sp + len;

	//analize POST data
	sp = mgets(boundary,2000,sp,spe,&n);		//boundary <- boundary + "\r\n"
	boundary[strlen(boundary) - 2] = '\0';
	strcpy(end_boundary,boundary);strcat(end_boundary,"--");	//boundary + "--"

	flag = true;
	do {
		sp = mgets(buff,2000,sp,spe,&n);		//Content-Disposition
		n = explode(buff,&v,';');
		if(n == 0 || n == 1) flag = false;
		if(n == 2) {							//INPUT TYPE=TEXT etc... except FILE
			key = extract_string(&v[1]);
			sp  = mgets(buff,2000,sp,spe,&n);	//skip CRLF
			val = "";
			for(;;) {
				sp = mgets(buff,2000,sp,spe,&n);
				if(strstr(buff,end_boundary) != NULL) {flag = false;break;}
				if(strstr(buff,boundary) != NULL)	  break;
				val += buff;
			}
			val.erase(val.size()-2,2);
			SetCGIData(key,val);				//store key & val
		}
		if(n == 3) {							//INPUT TYPE=FILE
			file      = extract_string(&v[1]);	//name="xxxx";
			file_name = extract_string(&v[2]);	//filename="yyyy"

			strcpy(path,tmp_path);
			fd = mkstemp(path);					//make temp file
			if(fd == -1) {
				free(data);
				error = "error (GetUploadFiles) : can not open tmp file ";
				throw(error);
			}

			sp = mgets(buff,2000,sp,spe,&n);
			if(strstr(buff,"Content-Type") != NULL) {	//Content-Type
				explode(buff,&v,':');
				file_mime = trim(&v[1]);
				sp = mgets(buff,2000,sp,spe,&n);		//skip CRLF
			} else {									//CRLF
				file_mime = "";
			}

			begin = sp;									//binary(text) part
			for(;;) {
				sp = mgets(buff,2000,sp,spe,&n);
				if(strstr(buff,end_boundary) != NULL) {flag = false;break;}
				if(strstr(buff,boundary) != NULL)	  break;
			}
			flen = (size_t)(sp - begin) - (size_t)strlen(buff) - 2;	//-2 = strlen("\r\n");
			write(fd,begin,flen);
			close(fd);
			//name
			key = file;
			SetCGIData(key,file_name);			//store key & val
			//path
			key = file + "_path";
			SetCGIData(key,path);				//store key & val
			//MIME type
			key = file + "_mime";
			SetCGIData(key,file_mime);			//store key & val
			//size
			key = file + "_size";
			sprintf(buff,"%d",flen);
			SetCGIData(key,buff);				//store key & val

			gDelFiles.push_back(path);			//temp file will be deleted when CGI program end
		}
	} while(flag);

	free(data);
}
//---------------------------------------------------------------------------
char	*mgets(char *pBuff,int pLen,char *pStart,char *pEnd,int *pNum)
//get 1 line from memory data
//parameters	*pBuff  : memory data
//				pLen    : max length
//				*pStart : start point of memory
//				*pEnd   : end point of memory
//				*pNum   : number of read characters
//return		current pointer
{
	int		i;
	char	*p;

	for(i=0,p=pBuff;i<pLen-1;i++,p++,pStart++) {
		if(pStart > pEnd)  break;
		if(*pStart == '\n') {*p = *pStart;i++;break;}
		*p = *pStart;
	}
	p++;
	*p     = '\0';	//terminate
	*pNum  = i;
	pStart ++;
	return(pStart);
}
//---------------------------------------------------------------------------
string	extract_string(string *pStr)
//extract string between " "
//parameter		*pStr : source string
//return		string;
{
	string			str;
	unsigned int	pos;

	str = *pStr;
	pos = str.rfind("\"");
	if(pos == string::npos) return(str);
	str.erase(pos,str.size()-pos);
	pos = str.find("\"");
	if(pos == string::npos) return(str);
	str.erase(0,pos+1);
	return(str);
}
//---------------------------------------------------------------------------
void	DeleteTmpFile()
//delete temp files from INPUT TYPE=FILE
//parameter		none
//return		none
{
	int		i,n;

	n = gDelFiles.size();
	for(i=0;i<n;i++) {
		remove(gDelFiles[i].c_str());
	}
}
//---------------------------------------------------------------------------
void	SetCGIData(string pKey,string pVal)
//store key & val to gCGI,gRequest,gIsSet,gCGI2
//parameter		pKey : key index string
//				pVal : value
//return		none
{
	pair <string,string> pair_data;

	gCGI[pKey]       = pVal;			//store CGI data
	gRequest[pKey]   = pVal;			//also store gRequest[]
	gIsSet.insert(pKey);				//also set gIsSet
	pair_data.first  = pKey;
	pair_data.second = pVal;
	gCGI2.insert(pair_data);			//store for StoreGivenArray()  ie. for "given string f" etc...
}
//---------------------------------------------------------------------------
void	ExceptionMsg(const char *pStr)
//display exception message
//parameter		*pStr : message
{
	cout_header();
	set_head("<TITLE>EXCEPTION ERROR -- ABORTED!</TITLE>");
	cout_head();
	cout << "<H1>CGI Program : Exception Error</H1>" << endl;
	cout << "<BIG><B>" << pStr << "</B></BIG>" << endl;
	cout << "<HR>\nProgram : " << gAppName << "<BR>\n" kCopyRight << endl;
	end_html();
}
//---------------------------------------------------------------------------
bool	isset(string pKey)
//is set value?
//parameter		pKey : find key word
//return		true : found , false not found
{
	if(gIsSet.end() == gIsSet.find(pKey)) return(false);
	return(true);
}
//---------------------------------------------------------------------------
bool	isset_CGI(string pKey)
//is set value in CGI ?
//parameter		pKey : find key word
//return		true : found , false not found
{
	if(gCGI.end() == gCGI.find(pKey)) return(false);
	return(true);
}
//---------------------------------------------------------------------------
bool	isset_Env(string pKey)
//is set value in Enviroment ?
//parameter		pKey : find key word
//return		true : found , false not found
{
	if(gEnv.end() == gEnv.find(pKey)) return(false);
	return(true);
}
//---------------------------------------------------------------------------
bool	isset_Cookie(string pKey)
//is set value in Cookie ?
//parameter		pKey : find key word
//return		true : found , false not found
{
	if(gCookie.end() == gCookie.find(pKey)) return(false);
	return(true);
}
//---------------------------------------------------------------------------
bool	isset_Conf(string pKey)
//is set value in Configure files ?
//parameter		pKey : find key word
//return		true : found , false not found
{
	if(gConf.end() == gConf.find(pKey)) return(false);
	return(true);
}
//---------------------------------------------------------------------------
