//---------------------------------------------------------------------------
#include "unit001.h"
//---------------------------------------------------------------------------
vector	<string> gSrcFiles;			//source file names
set		<string> gIncFile;			//include file name
string	gCmdLine;					//command line strings
bool	gCleanFlag;					//ignore project file flag     (default = false)
bool	gRemainFlag;				//remain temp source file flag (default = false)
bool	gVisibleFlag;				//print processing process     (default = false)
bool	gOnlyPreFlag;				//preprocess only              (default = false)
string	gProject;					//project file name
string	gCC;						//compiler name                (default g++)
//---------------------------------------------------------------------------
void	ClearGlobals()
//clear global valiables
//parameter		none
//return		none
{
//unit002.cpp
	gSrcFiles.clear();
	gIncFile.clear();
	gCmdLine     = "";
	gCleanFlag   = false;
	gRemainFlag  = false;
	gVisibleFlag = false;
	gOnlyPreFlag = false;
	gProject     = kProject;
	gCC          = kGCC;

//unit003.lex
	gGiven.clear();
	gHeader.clear();
	gHead.clear();
	gPragma.clear();
	gConfFile.clear();

//unit004.cpp
	gErrorNo = 0;
}
//---------------------------------------------------------------------------
int		AnalizeCmdLine(int argc,char *argv[])
//analize command line
//parameters	argc : number of command line parameter
//				argv[] : command line parameter
//return		number of source file
{
	int		i;
	unsigned int	pos,n;
	bool	aOFlag;				//-o flag (set output file name)
	bool	aSFlag;				//-S flag (compile only.         ie. make assenble file and not link)
	bool	aEFlag;				//-E flag (preprocess only.      ie. make pre-processed file and not link)
	bool	aCFlag;				//-c flag (compile and assenble. ie. make object file and not link)
	string	aObjName,error;
	vector	<string> av;		//argv[] buffer

	if(argc < 2) {Usage();exit(0);}

	aOFlag = aSFlag = aEFlag = aCFlag = false;
	av.clear();

	for(i=1;i<argc;i++) {		//check command line
		//acpp options
		if(0 == strcmp(argv[i],kCleanFlag))		{gCleanFlag   = true;continue;}
		if(0 == strcmp(argv[i],kRemainFlag))	{gRemainFlag  = true;continue;}
		if(0 == strcmp(argv[i],kVisibleFlag))	{gVisibleFlag = true;continue;}
		if(0 == strcmp(argv[i],kOnlyPreFlag))	{gOnlyPreFlag = true;gRemainFlag=true;continue;}
		if(0 == strcmp(argv[i],kVersionFlag))	{error = kVersion;throw(error);continue;}
		if(0 == strcmp(argv[i],kProjectFlag))	{i++;gProject = argv[i];continue;}
		if(0 == strcmp(argv[i],kCC))			{i++;gCC      = argv[i];continue;}
		//C++ source file
		if(Suffix(argv[i]) == ".c")				{gSrcFiles.push_back(argv[i]);av.push_back(string(argv[i]) + kTmpSfx);continue;}
		if(Suffix(argv[i]) == ".cc")			{gSrcFiles.push_back(argv[i]);av.push_back(string(argv[i]) + kTmpSfx);continue;}
		if(Suffix(argv[i]) == ".cpp")			{gSrcFiles.push_back(argv[i]);av.push_back(string(argv[i]) + kTmpSfx);continue;}
		//g++ options
		if(0 == strcmp(argv[i],"-o"))			{aOFlag       = true;av.push_back(argv[i]);continue;}
		if(0 == strcmp(argv[i],"-S"))			{aSFlag       = true;av.push_back(argv[i]);continue;}
		if(0 == strcmp(argv[i],"-E"))			{aEFlag       = true;av.push_back(argv[i]);continue;}
		if(0 == strcmp(argv[i],"-c"))			{aCFlag       = true;av.push_back(argv[i]);continue;}
		av.push_back(argv[i]);
	}

	if(!(aSFlag || aEFlag || aCFlag)) av.push_back(gProject);		//link with project file
	if(!(aSFlag || aEFlag || aCFlag)) av.push_back(kAcppLibs);		//link with acpp libs

	gCmdLine = implode(&av," ");				//restructure command line

	if(gSrcFiles.size() == 0) {					//if no source files
		gCmdLine = gCC + " " + gCmdLine;
		return(0);
	}

	if(aOFlag) {								//if object file name was defined
		gCmdLine = gCC + " " + gCmdLine;
		return(gSrcFiles.size());
	}

	if(gSrcFiles.size() > 0) {
		aObjName = gSrcFiles[0];
		pos      = aObjName.rfind(".");
		n        = aObjName.length();
		aObjName.erase(pos,n-pos);
	}

	if(aSFlag) {								//if -S option was defined and object file was not defined. because source file name was changed.
		gCmdLine = gCC + " -o " + aObjName + ".s " + gCmdLine;
		return(gSrcFiles.size());
	}

	if(aCFlag) {								//if -c option was defined and object file was not defined. because source file name was changed.
		gCmdLine = gCC + " -o " + aObjName + ".o " + gCmdLine;
		return(gSrcFiles.size());
	}

	gCmdLine = gCC + " " + gCmdLine;
	return(gSrcFiles.size());
}
//---------------------------------------------------------------------------
void	Usage()
//print usage
{
	cout << kVersion << endl;
	cout << kCopyRight << endl;
	cout << "Usage: acpp [acpp options] [compiler options] files..." << endl;
	cout << "acpp options :" << endl;
	cout << "    -clear         not refrerence project file" << endl;
	cout << "    -remain        remain tmp source file" << endl;
	cout << "    -visible       show process" << endl;
	cout << "    -pre           only preprocess. (remain preprocessed file)" << endl;
	cout << "    -version       show acpp version" << endl;
	cout << "    -project name  specify a project file name" << endl;
	cout << "compiler options : to hand compiler options" << endl;
}
//---------------------------------------------------------------------------
