/*---------------------------------------------------------------------------*/
/* Lexical scanner for project file */
/*---------------------------------------------------------------------------*/
%option stack
%option yylineno
%option prefix="zz"
%option outfile="unit003.cpp"
%{
#include	"unit001.h"
/*---------------------------------------------------------------------------*/
#define	YY_SKIP_YYWRAP
int		yywrap() {return 1;}
/*---------------------------------------------------------------------------*/
/* global value */
string		gType;							//given parameters type
map <string,map <string,string> > gGiven;	//given type name;        --> gGiven[filename][name] = type
map <string,set <string> > gHeader;			//#pragma HEADER strings  --> gHeader[filename].insert(parameters)
map <string,set <string> > gHead;			//#pragma HEAD   strings  --> gHead[filename].insert(parameters)
map <string,set <string> > gPragma;			//#pragma COUT_HEADER     --> gPragma[filename].insert(COUT_HEADER)
											//#pragma COUT_HEAD       --> gPragma[filename].insert(COUT_HEAD)
											//#pragma END_HTML        --> gPragma[filename].insert(END_HTML)
map <string,set <string> > gConfFile;		//#configure "file.conf"  --> gConfFile[filename].insert(file.conf)
string		gStr;							//temp buffer
/*----------------------------------*/
/* local value only used in unit003.lex */
string		gFileName;						//file name buffer
bool		gVectorFlag;					//vector <T> flag
/*----------------------------------*/
/* local value only used in unit003.lex */
string		zzReadLine(char pTerm='\n');	//read line until terminater
/*---------------------------------------------------------------------------*/
%}
%x PROJECT GIVEN
%%
^"<FILE:"		{
					gFileName = zzReadLine('>');
					yyinput();			//read "\n"
					yy_push_state(PROJECT);
}
<PROJECT>{
^"#configure"[[:blank:]]+"\""	{
					gStr = zzReadLine('\"');
					gConfFile[gFileName].insert(gStr);
				}
^"#pragma"[[:blank:]]+"SET_HEADER"[[:blank:]]+	{
					gStr = zzReadLine();
					gHeader[gFileName].insert(gStr);
				}
^"#pragma"[[:blank:]]+"SET_HEAD"[[:blank:]]+	{
					gStr = zzReadLine();
					gHead[gFileName].insert(gStr);
				}
^"#pragma"[[:blank:]]+"COUT_HEADER"[[:blank:]]+ {
					gStr = zzReadLine();
					gPragma[gFileName].insert("COUT_HEADER");
				}
^"#pragma"[[:blank:]]+"COUT_HEAD"[[:blank:]]+ {
					gStr = zzReadLine();
					gPragma[gFileName].insert("COUT_HEAD");
				}
^"#pragma"[[:blank:]]+"BEGIN_HTML"[[:blank:]]+ {
					gStr = zzReadLine();
					gPragma[gFileName].insert("COUT_HEAD");
				}
^"#pragma"[[:blank:]]+"END_HTML"[[:blank:]]+ {
					gStr = zzReadLine();
					gPragma[gFileName].insert("END_HTML");
				}
^string[[:blank:]]+	{
						gType = "string";
						gVectorFlag = false;
						yy_push_state(GIVEN);
					}
^int[[:blank:]]+	{
						gType = "int";
						gVectorFlag = false;
						yy_push_state(GIVEN);
					}
^float[[:blank:]]+	{
						gType = "float";
						gVectorFlag = false;
						yy_push_state(GIVEN);
					}
^double[[:blank:]]+	{
						gType = "double";
						gVectorFlag = false;
						yy_push_state(GIVEN);
					}
^long[[:blank:]]+	{
						gType = "long";
						gVectorFlag = false;
						yy_push_state(GIVEN);
					}
^short[[:blank:]]+	{
						gType = "short";
						gVectorFlag = false;
						yy_push_state(GIVEN);
					}
^bool[[:blank:]]+	{
						gType = "bool";
						gVectorFlag = false;
						yy_push_state(GIVEN);
					}
^"map <int,string>"[[:blank:]]+	{
						gType = "string";
						gVectorFlag = true;
						yy_push_state(GIVEN);
					}
^"map <int,int>"[[:blank:]]+	{
						gType = "int";
						gVectorFlag = true;
						yy_push_state(GIVEN);
					}
^"map <int,float>"[[:blank:]]+	{
						gType = "float";
						gVectorFlag = true;
						yy_push_state(GIVEN);
					}
^"map <int,double>"[[:blank:]]+	{
						gType = "double";
						gVectorFlag = true;
						yy_push_state(GIVEN);
					}
^"map <int,long>"[[:blank:]]+	{
						gType = "long";
						gVectorFlag = true;
						yy_push_state(GIVEN);
					}
^"map <int,short>"[[:blank:]]+	{
						gType = "short";
						gVectorFlag = true;
						yy_push_state(GIVEN);
					}
^"map <int,bool>"[[:blank:]]+	{
						gType = "bool";
						gVectorFlag = true;
						yy_push_state(GIVEN);
					}
^"</FILE>\n"		{
						yy_pop_state();
					}
.					{}
\n					{}
}
<GIVEN>{
[[:alnum:]_]+		{
						if(gVectorFlag) gGiven[gFileName][string(yytext) + "[]"] = gType;
						 else			gGiven[gFileName][yytext] = gType;
					}
;					{
						yy_pop_state();
					}
[[:blank:]]*,[[:blank:]]*	{}
.					{}
\n					{}
}
.					{}
\n					{}
%%
/*---------------------------------------------------------------------------*/
void	AnalizeProject()
//analize project file
//parameters none (global value)
//return none
{
	FILE	*fp;

	fp = fopen(gProject.c_str(),"r");
	if(fp == NULL) return;

	yyin = fp;
	yylex();
	fclose(fp);
}
/*---------------------------------------------------------------------------*/
string	zzReadLine(char pTerm)
//read line until terminater
//parameter		pTerm : terminate charactor
//return		line string
{
	string	str;
	int		c;

	str = "";
	c = yyinput();
	while(c != pTerm) {
		str += c;
		c = yyinput();
	}

	return(str);
}
/*---------------------------------------------------------------------------*/
