/*---------------------------------------------------------------------------*/
/* Lexical scanner for source file */
/*---------------------------------------------------------------------------*/
%option stack
%option yylineno
%option outfile="unit005.cpp"
%{
#include	"unit001.h"
/*---------------------------------------------------------------------------*/
#define	YY_SKIP_YYWRAP
int		yywrap() {return 1;}
/*---------------------------------------------------------------------------*/
/* global value */
string		gSrcFileName;			//source file name
ofstream	gOut;					//temp file stream
/*----------------------------------*/
/* local value only used in unit005.lex */
bool		gComma;					//commma flag : use in given processing
string		gLineStr;				//temp buffer : use in given processing
int			gCh;					//temp charactor
struct	_Token_ {					//token structure
		bool	mFlag;				//true : value or equation   false : strings
		string	mStr;				//token
};
typedef struct _Token_  Token;
vector <Token> gToken;				//token array
/*----------------------------------*/
/* local value only used in unit005.lex */
void	PushToken(bool);			//record token
void	ThrowError(char *);			//throw exception routine
string	ReadLine(char pTerm='\n');	//read line until terminater
/*---------------------------------------------------------------------------*/
%}
%x	COMMENT1 COMMENT2
%x	GIVEN
%x	HTML VALUE EQUATION BRACKET
%%
"/*"			{
					yy_push_state(COMMENT1);
					gOut << yytext;
				}
<COMMENT1>{
[^*\n]*			{	gOut << yytext;	}
[^*\n]*\n		{	gOut << yytext;	}
"*"+[^*/\n]*	{	gOut << yytext;	}
"*"+[^*/\n]*\n	{	gOut << yytext;	}
"*"+"/"			{
					gOut << yytext;
					yy_pop_state();
				}
<<EOF>>			{
					ThrowError("acpp error (LexicalAnalize): EOF in pure");
				}
}
"//"			{
					yy_push_state(COMMENT2);
					gOut << yytext;
				}
<COMMENT2>{
.				{	gOut << yytext;	}
\n				{
					gOut << endl;
					yy_pop_state();
				}
}
^"#include"[[:blank:]]+"\""			{
					gStr = "";
					gCh = yyinput();
					while(gCh != '\"') {
						if(gCh == '\n') {
							cout << gSrcFileName << ":" << yylineno << ": acpp warning: #include terminated." << endl;
							break;
						}
						gStr += gCh;
						gCh = yyinput();
					}
					gIncFile.insert(gStr);
					gOut << "#line " << yylineno << " \"" << gSrcFileName << "\"" << endl;
					gOut << yytext << gStr << kIncSfx << "\"";
				}
^"#configure"[[:blank:]]+"\""			{
					gStr = "";
					gCh = yyinput();
					while(gCh != '\"') {
						if(gCh == '\n') {
							cout << gSrcFileName << ":" << yylineno << ": acpp warning: #configure terminated." << endl;
							break;
						}
						gStr += gCh;
						gCh = yyinput();
					}
					if(gStr == "") {
							cout << gSrcFileName << ":" << yylineno <<": acpp error: #configure no parameters." << endl;
							gOut << "//" << yytext << endl;
					} else {
						gConfFile[gSrcFileName].insert(gStr);
						gOut << "//" << yytext << gStr << "\"";
					}
				}
^"#pragma"[[:blank:]]+"SET_HEADER"[[:blank:]]+	{
					gStr = ReadLine();
					if(gStr == "") {
						cout << gSrcFileName << ":" << yylineno <<": acpp warning: #pragma HEADER no parameters." << endl;
						gOut << "//" << yytext << endl;
					} else {
						gHeader[gSrcFileName].insert(gStr);
						gOut << "//" << yytext << gStr << endl;
					}
				}
^"#pragma"[[:blank:]]+"SET_HEADER"\n	{
					cout << gSrcFileName << ":" << yylineno <<": acpp warning: #pragma HEADER no parameters." << endl;
					gOut << "//" << yytext;
				}
^"#pragma"[[:blank:]]+"SET_HEAD"[[:blank:]]+	{
					gStr = ReadLine();
					if(gStr == "") {
						cout << gSrcFileName << ":" << yylineno << ": acpp warning: #pragma HEAD no parameters." << endl;
						gOut << "//" << yytext << endl;
					} else {
						gHead[gSrcFileName].insert(gStr);
						gOut << "//" << yytext << gStr << endl;
					}
				}
^"#pragma"[[:blank:]]+"SET_HEAD"\n		{
					cout << gSrcFileName << ":" << yylineno << ": acpp warning: #pragma HEAD no parameters." << endl;
					gOut << "//" << yytext;
				}
^"#pragma"[[:blank:]]+"COUT_HEADER"	{
					gStr = ReadLine();
					gPragma[gSrcFileName].insert("COUT_HEADER");
					gOut << "//" << yytext << gStr << endl;
				}
^"#pragma"[[:blank:]]+"COUT_HEAD"	{
					gStr = ReadLine();
					gPragma[gSrcFileName].insert("COUT_HEAD");
					gOut << "//" << yytext << gStr << endl;
				}
^"#pragma"[[:blank:]]+"BEGIN_HTML"	{
					gStr = ReadLine();
					gPragma[gSrcFileName].insert("COUT_HEAD");
					gOut << "//" << yytext << gStr << endl;
				}
^"#pragma"[[:blank:]]+"END_HTML"	{
					gStr = ReadLine();
					gPragma[gSrcFileName].insert("END_HTML");
					gOut << "//" << yytext << gStr << endl;
				}
given[[:blank:]]+string[[:blank:]]+	{
							gType    = "string";
							gLineStr = "extern\tstring\t";
							gComma   = true;
							yy_push_state(GIVEN);
						}
given[[:blank:]]+int[[:blank:]]+	{
							gType    = "int";
							gLineStr = "extern\tint\t";
							gComma = true;
							yy_push_state(GIVEN);
						}
given[[:blank:]]+float[[:blank:]]+	{
							gType    = "float";
							gLineStr = "extern\tfloat\t";
							gComma   = true;
							yy_push_state(GIVEN);
						}
given[[:blank:]]+double[[:blank:]]+	{
							gType    = "double";
							gLineStr = "extern\tdouble\t";
							gComma   = true;
							yy_push_state(GIVEN);
						}
given[[:blank:]]+long[[:blank:]]+	{
							gType    = "long";
							gLineStr = "extern\tlong\t";
							gComma   = true;
							yy_push_state(GIVEN);
						}
given[[:blank:]]+short[[:blank:]]+	{
							gType    = "short";
							gLineStr = "extern\tshort\t";
							gComma   = true;
							yy_push_state(GIVEN);
						}
given[[:blank:]]+bool[[:blank:]]+	{
							gType    = "bool";
							gLineStr = "extern\tbool\t";
							gComma   = true;
							yy_push_state(GIVEN);
						}
<GIVEN>{
[[:alnum:]_]+"[]"	{
						if(! gComma) {
							ThrowError("acpp error (LexicalAnalize): syntax error ");
						} else {
							gGiven[gSrcFileName][yytext] = gType;
							yytext[strlen(yytext)-2] = '\0';
							gLineStr       = string("extern map <int,") + gType + "> " + yytext;
							gComma         = false;
						}
					}
[[:alnum:]_]+		{
						if(! gComma) {
							ThrowError("acpp error (LexicalAnalize): syntax error ");
						} else {
							gGiven[gSrcFileName][yytext] = gType;
							gLineStr      += yytext;
							gComma         = false;
						}
					}
;					{
						gOut << "#line " << yylineno << " \"" << gSrcFileName << "\"" << endl;
						gOut << gLineStr << ";" ;
						yy_pop_state();
					}
[[:blank:]]*,[[:blank:]]*	{
						gLineStr += yytext;
						gComma    = true;
					}
"//"				{
						gOut << gLineStr << yytext;
						gLineStr = "";
						yy_push_state(COMMENT2);
					}
"/*"				{
						gOut << gLineStr << yytext;
						gLineStr = "";
						yy_push_state(COMMENT1);
					}
[[:blank:]]+		{
						gLineStr += yytext;
					}
\n					{
						gOut << gLineStr << endl;
						gLineStr = "";
					}
.					{
						ThrowError("acpp error (LexicalAnalize): syntax error");
					}
}
^"<?HTML"			{
						gOut << "#line " << yylineno << " \"" << gSrcFileName << "\"" << endl;
						gOut << "//<?HTML";
						gToken.clear();
						gStr = "";
						yy_push_state(HTML);
						yy_push_state(COMMENT2);
					}
<HTML>{
^"?>"				{
						gOut << "//?>";
						yy_pop_state();
					}
"$$"				{
						gStr += "$";
					}
"${"				{
						PushToken(false);
						yy_push_state(EQUATION);
					}
"$"					{
						PushToken(false);
						yy_push_state(VALUE);
					}
\"					{
						gStr += "\\\"";
					}
\\					{
						gStr += "\\\\";
					}
\n					{
						int		i,n;
						PushToken(false);
						gOut << "cout << ";
						n = gToken.size();
						for(i=0;i<n;i++) {
							if(gToken[i].mFlag) {
								gOut << gToken[i].mStr << " << ";
							} else {
								gOut << "\"" << gToken[i].mStr << "\" << ";
							}
						}
						gOut << " endl;" << endl;
						gToken.clear();
					}
<<EOF>>				{
						ThrowError("acpp error (LexicalAnalize): EOF in pure text");
					}
.					{
						gStr += yytext;
					}
}
<EQUATION>{
"}"					{
						PushToken(true);
						yy_pop_state();
					}
<<EOF>>				{
						ThrowError("acpp error (LexicalAnalize): EOF in pure text");
					}
\n					{
						ThrowError("acpp error (LexicalAnalize): brancket \"}\" not complete in pure text");
					}
.					{
						gStr += yytext;
					}
}
<VALUE>{
"["					{
						gStr += yytext;
						yy_push_state(BRACKET);
					}
[[:alnum:]_\.]+		{
						gStr += yytext;
					}
"->"				{
						gStr += yytext;
					}
\"					{
						PushToken(true);
						gStr = "\\\"";
						yy_pop_state();
					}
<<EOF>>				{
						ThrowError("acpp error (LexicalAnalize): EOF in pure text");
					}
.					{
						PushToken(true);
						gStr = yytext;
						yy_pop_state();
					}
\n					{
						PushToken(true);
						yyless(0);
						yy_pop_state();
					}
}
<BRACKET>{
"]"					{
						gStr += yytext;
						yy_pop_state();
					}
<<EOF>>				{
						ThrowError("acpp error (LexicalAnalize): EOF in pure text");
					}
\n					{
						ThrowError("acpp error (LexicalAnalize): brancket \"]\" not complete in pure text");
					}
.					{
						gStr += yytext;
					}
}
.					{
						gOut << yytext;
					}
\n					{
						gOut << endl;
					}
%%
/*---------------------------------------------------------------------------*/
void	LexicalAnalize(FILE *pFp)
//analize source file
//parameters *pFp : source file pointer
//return none
{
	yyin = pFp;
	yylex();
}
/*---------------------------------------------------------------------------*/
void	PushToken(bool pFlag)
//record token
//parameter		pFlag :  true : value or equation   false : strings
//return		none
{
	Token	aToken;

	if(! gStr.empty()) {
		aToken.mFlag = pFlag;
		aToken.mStr  = gStr;
		gToken.push_back(aToken);
		gStr = "";
	}
}
/*---------------------------------------------------------------------------*/
void	ThrowError(char *pMsg)
//throw exception routine
//parameters	*pMsg : error message
//return		none
{
		char	str[1000];
		string	error;

		sprintf(str,"%s:%d: %s",gSrcFileName.c_str(),yylineno,pMsg);
		error = str;
		throw(error);
}
/*---------------------------------------------------------------------------*/
string	ReadLine(char pTerm)
//read line until terminater
//parameter		pTerm : terminate charactor
//return		line string
{
	string	str;
	int		c;

	str = "";
	c = yyinput();
	while(c != pTerm) {
		str += c;
		c = yyinput();
	}

	return(str);
}
/*---------------------------------------------------------------------------*/
