/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsselector;

import com.sun.messaging.jmq.jmsselector.InvalidJMSSelectorException;
import com.sun.messaging.jmq.jmsselector.NullMessageHeaderException;
import com.sun.messaging.jmq.jmsselector.SQLParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class JMSSelector
implements Serializable {
    transient SQLParser parser;
    String selectorPattern;
    transient Hashtable msgHeader;
    transient int jmsDeliveryMode;
    transient int jmsPriority;
    transient String jmsMessageID;
    transient long jmsTimestamp;
    transient String jmsCorrelationID;
    transient String jmsType;

    public JMSSelector() {
        this(null, null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.msgHeader = new Hashtable();
        this.jmsDeliveryMode = 2;
        this.jmsPriority = 4;
        this.jmsMessageID = "";
        this.jmsTimestamp = 0L;
        this.jmsCorrelationID = "";
        this.jmsType = "";
    }

    public JMSSelector(String string, Hashtable hashtable) {
        if (string == null) {
            string = "";
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        this.msgHeader = hashtable;
        this.selectorPattern = string;
        this.jmsDeliveryMode = 2;
        this.jmsPriority = 4;
        this.jmsMessageID = "";
        this.jmsTimestamp = 0L;
        this.jmsCorrelationID = "";
        this.jmsType = "";
        StringReader stringReader = new StringReader(this.selectorPattern);
        this.parser = new SQLParser(this, stringReader);
    }

    public int getJMSDeliveryMode() {
        return this.jmsDeliveryMode;
    }

    public void setJMSDeliveryMode(int n) {
        this.jmsDeliveryMode = n;
    }

    public int getJMSPriority() {
        return this.jmsPriority;
    }

    public void setJMSPriority(int n) {
        this.jmsPriority = n;
    }

    public String getJMSMessageID() {
        return this.jmsMessageID;
    }

    public void setJMSMessageID(String string) {
        this.jmsMessageID = string;
    }

    public long getJMSTimestamp() {
        return this.jmsTimestamp;
    }

    public void setJMSTimestamp(long l) {
        this.jmsTimestamp = l;
    }

    public String getJMSCorrelationID() {
        return this.jmsCorrelationID;
    }

    public void setJMSCorrelationID(String string) {
        this.jmsCorrelationID = string;
    }

    public String getJMSType() {
        return this.jmsType;
    }

    public void setJMSType(String string) {
        this.jmsType = string;
    }

    public void setJMSHeaderFields(int n, int n2, String string, long l, String string2, String string3) {
        this.jmsDeliveryMode = n;
        this.jmsPriority = n2;
        this.jmsMessageID = string;
        this.jmsTimestamp = l;
        this.jmsCorrelationID = string2;
        this.jmsType = string3;
    }

    public String getSelectorPattern() {
        return this.selectorPattern;
    }

    public void setSelectorPattern(String string) {
        this.selectorPattern = string == null ? "" : string;
    }

    public void validateSelectorPattern(String string) throws InvalidJMSSelectorException, NullMessageHeaderException {
        if (string == null) {
            string = "";
        }
        this.selectorPattern = string;
        if ("".equals(this.selectorPattern)) {
            return;
        }
        try {
            this.match(this.msgHeader);
        }
        catch (NullMessageHeaderException nullMessageHeaderException) {
            throw nullMessageHeaderException;
        }
        catch (Throwable throwable) {
            throw new InvalidJMSSelectorException(this.selectorPattern);
        }
    }

    public boolean match(Hashtable hashtable) throws InvalidJMSSelectorException, NullMessageHeaderException {
        boolean bl = false;
        if (this.selectorPattern.equals("")) {
            bl = true;
        } else {
            try {
                StringReader stringReader = new StringReader(this.selectorPattern);
                this.parser.ReInit(stringReader);
                bl = this.parser.match(hashtable == null ? this.msgHeader : hashtable);
            }
            catch (NullMessageHeaderException nullMessageHeaderException) {
                throw nullMessageHeaderException;
            }
            catch (Throwable throwable) {
                throw new InvalidJMSSelectorException(this.selectorPattern);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matchPattern(String string, String string2, char c) {
        boolean bl = false;
        String string3 = String.valueOf(c);
        String string4 = "_%";
        String string5 = string4 + string3;
        boolean bl2 = false;
        int n = 0;
        String string6 = null;
        try {
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, string5, true);
                Vector<String> vector = new Vector<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken();
                    vector.addElement(string6);
                }
                bl = true;
                int n2 = vector.size();
                block8: for (int i = 0; i < n2; ++i) {
                    int n3;
                    string6 = (String)vector.elementAt(i);
                    if (string6.equals(string3) && !bl2) {
                        bl2 = true;
                        continue;
                    }
                    if (string6.equals("%") && !bl2) {
                        if (i == n2 - 1) {
                            n = string2.length();
                            continue;
                        }
                        if (i == n2 - 1) continue;
                        n3 = 0;
                        ++i;
                        while (i < n2) {
                            string6 = (String)vector.elementAt(i);
                            if (string6.equals(string3) && !bl2) {
                                bl2 = true;
                            } else if (!string6.equals("%") || bl2) {
                                if (string6.equals("_") && !bl2) {
                                    ++n3;
                                } else {
                                    int n4 = n;
                                    if (i == n2 - 1) {
                                        if (string2.endsWith(string6)) {
                                            n = string2.length() - string6.length();
                                        } else {
                                            bl = false;
                                        }
                                    } else {
                                        n = string2.indexOf(string6, n);
                                    }
                                    if (n < 0) {
                                        bl = false;
                                    } else if (n - n4 >= n3) {
                                        n += string6.length();
                                    } else {
                                        bl = false;
                                    }
                                    bl2 = false;
                                    continue block8;
                                }
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (string6.equals("_") && !bl2) {
                        ++n;
                        continue;
                    }
                    n3 = string6.length();
                    if (n + n3 <= string2.length()) {
                        String string7 = null;
                        try {
                            string7 = string2.substring(n, n + n3);
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            bl = false;
                            break;
                        }
                        if (!string7.equalsIgnoreCase(string6)) {
                            bl = false;
                            break;
                        }
                        n += string6.length();
                    } else {
                        bl = false;
                        break;
                    }
                    bl2 = false;
                }
            }
            if (bl) {
                if (n != string2.length()) {
                    bl = false;
                    return bl;
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            bl = false;
            return bl;
        }
        finally {
            return bl;
        }
    }

    String processStringLiteral(String string) {
        int n = (string = string.substring(1, string.length() - 1)).indexOf("''");
        if (n > -1) {
            while (n != -1) {
                string = string.substring(0, n).concat(string.substring(n + 1));
                n = string.indexOf("''");
            }
        }
        return string;
    }

    public String toString() {
        return "JMSSelector:\tPattern=\t`" + this.selectorPattern + "'" + "\n    Headers:\tDeliveryMode\t" + this.jmsDeliveryMode + "\n\t\tPriority\t" + this.jmsPriority + "\n\t\tMessageID\t`" + this.jmsMessageID + "'" + "\n\t\tTimestamp\t" + this.jmsTimestamp + "\n\t\tCorrelationID\t`" + this.jmsCorrelationID + "'" + "\n\t\tType\t\t`" + this.jmsType + "'" + "\n";
    }
}

