#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT GMAP v3.0.5
## (c)2008-2010 NorenzPRO Ltd. TakafumiArai 2010/8/10
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##==============基本設定==============

##★ライブラリファイルのパス。
use Encode;
require '../admin/emoji.pl';
require '../admin/aelib.cgi';

##★このスクリプトの名前
$cginame = 'index.cgi';

##★データファイルのパス
$datafile = './data.dat';

##★アップロード画像格納ディレクトリ（相対・絶対パス）
$img_dir = './file/';

##★アップロード画像公開ディレクトリ（相対・絶対パス）
$img_path = './file/';

##★初期画面の選択
## 地図:G_MAP_TYPE / 衛星写真:G_SATELLITE_TYPE / 地図+衛星:G_HYBRID_TYPE
$MapType = 'G_MAP_TYPE';

##★コントロールボタン[左上]
## 大:L  / 小:S / なし:N
$Control = 'L';

##★地図/衛星切替ボタの表示(する:1/しない:0)
$Switch = 1;

##★縮尺スケールの表示(する:1/しない:0)
$Scale = 1;

##★広域サブマップの表示(する:1/しない:0)
$SubMap = 1;

##★広域サブマップのサイズ
$SubWidth = 120;
$SubHeight = 100;

##=====================================================================================##
##メインルーチン
##=====================================================================================##

##キャリア転送
$ua = $ENV{"HTTP_USER_AGENT"};
if ($ua =~ /DoCoMo\/1\.0/i) { $xCR='mobi'; }
elsif ($ua =~ /Mozilla/i) { $xCR='pc'; }
elsif ($ua =~ /(DoCoMo\/2\.0|FOMA)/i) { $xCR='mobi'; }
elsif ($ua =~ /^(SoftBank|Vodafone|J\-PHONE|MOT\-[CV])/i) { $xCR='mobi'; }
elsif ($ua =~ /^UP\.Browser/i) { $xCR='mobi'; }
elsif ($ua =~ /^(KDDI\-|OPWV|MMP)/i) { $xCR='mobi'; }
else { $xCR='pc'; }

##システム設定ファイル読込
$servconf = '../admin/conf.dat';
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
	$Domain =$SVCONF[3];
	$Domain =~ s/\r//g; $Domain =~ s/\n//g;
	$GmapAPIkey =$SVCONF[8];
	$GmapAPIkey =~ s/\r//g; $GmapAPIkey =~ s/\n//g;
	$RootPath =$SVCONF[10];
	$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
	$pcoutCode =$SVCONF[22];
	$pcoutCode =~ s/\r//g; $pcoutCode =~ s/\n//g;
}
if ($pcoutCode eq '') { $pcoutCode='sjis'; }

##設定ファイル読込
$conffile='./conf.dat';
open(CONFRD,"$conffile");
@CONF = <CONFRD>;
close(CONFRD);
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($conffile);
if ($contCC eq 'shiftjis') {
	foreach (@CONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}
$DefIdo =$CONF[2];
$DefIdo =~ s/\r//g;$DefIdo =~ s/\n//g;
$DefKeido =$CONF[3];
$DefKeido =~ s/\r//g;$DefKeido =~ s/\n//g;
$FileTypeLine =$CONF[4];
$FileTypeLine =~ s/\r//g;$FileTypeLine =~ s/\n//g;
@FileType=split(/:/,$FileTypeLine);
$PageTitle =$CONF[7];
$PageTitle =~ s/\r//g;$PageTitle =~ s/\n//g;
$SkinFile =$CONF[8];
$SkinFile =~ s/\r//g;$SkinFile =~ s/\n//g;
$SkinFile ='..'.$SkinFile;
$ListView =$CONF[9];
$ListView =~ s/\r//g;$ListView =~ s/\n//g;
$PageView =$CONF[10];
$PageView =~ s/\r//g;$PageView =~ s/\n//g;
$MapWidth =$CONF[14];
$MapWidth =~ s/\r//g;$MapWidth =~ s/\n//g;
$MapHeight =$CONF[15];
$MapHeight =~ s/\r//g;$MapHeight =~ s/\n//g;
$MapZoom =$CONF[16];
$MapZoom =~ s/\r//g;$MapZoom =~ s/\n//g;
$PageHeadMsg =$CONF[19];
$PageHeadMsg = &inline_link($PageHeadMsg);
$PageHeadMsg = &tag_change($PageHeadMsg);
$PageHeadMsg =~ s/\r//g;$PageHeadMsg =~ s/\n//g;
$PageHeadMsg =~ s/<br>/<br \/>\&\#32\;/g;
$PageHeadMsg = &cgi_include($PageHeadMsg);
$PageHeadMsg = &url_import($PageHeadMsg);
$NaviBack =$CONF[21];
$NaviBack =~ s/\r//g;$NaviBack =~ s/\n//g;
$NaviNext =$CONF[22];
$NaviNext =~ s/\r//g;$NaviNext =~ s/\n//g;
$BackToList =$CONF[28];
$BackToList =~ s/\r//g;$BackToList =~ s/\n//g;
$ShowDetail =$CONF[29];
$ShowDetail =~ s/\r//g;$ShowDetail =~ s/\n//g;
$HtmlHeader =$CONF[30];
$HtmlHeader =~ s/\r//g;$HtmlHeader =~ s/\n//g;
$HtmlHeader =~ s/<br>/\n/g;
$DirName =$CONF[31];
$DirName =~ s/\r//g;$DirName =~ s/\n//g;
$PgTitleClass =$CONF[32];
$PgTitleClass =~ s/\r//g;$PgTitleClass =~ s/\n//g;

$GmapKey=$GmapAPIkey;
if ($NaviBack eq '') { $NaviBack='[＜＜ＢＡＣＫ]'; }
if ($NaviNext eq '') { $NaviNext='[ＮＥＸＴ＞＞]'; }
if ($ShowDetail eq '') { $ShowDetail='[地図表示]'; }
if ($BackToList eq '') { $BackToList='[先ほどのページへ戻る]'; }

##フォームの取得
$buffer = $ENV{'QUERY_STRING'};
@pairs = split(/&/,$buffer);
for $pair (@pairs) {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	if ($pcoutCode eq 'sjis') { Encode::from_to($value, 'shiftjis', 'utf8'); }
	$in{$name} = $value;
}
if ($in{'pline'} eq '') { $pline = 0; } else { $pline = $in{'pline'}; }
if ($in{'pg'} ne '') { $in{'mode'}='detail'; $in{'code'}=$in{'pg'}; }
if ($in{'mode'} eq 'detail') { $pback=$pline; $pline='0'; }

##携帯アクセス転送
if ($xCR eq 'mobi') {
	if ($in{'pg'} ne '') {
		print 'Location:mbmap.cgi?pg='.$in{'pg'}."\n\n";
		exit;
	} else {
		print 'Location:mobi.cgi'."\n\n";
		exit;
	}
}

##DATA取得
&data_read;
if ($in{'mode'} eq 'preview') {
	@NEW = grep(/code=$in{'code'}\t/,@DATA);
} elsif ($in{'mode'} eq 'detail') {
	@TRUE = grep(/code=$in{'code'}\t/,@DATA);
	@NEW = grep(/\tshow=on\t/,@TRUE);
} elsif ($in{'mode'} eq 'result') {
	@TRUE = grep(/code=$in{'code'}\t/,@DATA);
	@NEW = grep(/\tshow=on\t/,@TRUE);
} else {
	@TRUE = grep(/code=/,@DATA);
	@NEW = grep(/\tshow=on\t/,@TRUE);
}
$DataLot=@NEW;

##==============メインアクション==============

if ($RootPath ne '') {
	$RssURL='http://'.$Domain.'/'.$RootPath.'/'.$DirName.'/rdfout.cgi';
} else {
	$RssURL='http://'.$Domain.'/'.$DirName.'/rdfout.cgi';
}
$RdfTag='<link rel="alternate" type="application/rss+xml" title="'.$PageTitle.'" href="'.$RssURL.'" />';

&JsGmap;
&html_head;
&html_list;
&html_foot;


exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

#スキンページ読込
&page_read;

print "Content-type: text/html\n\n";
$phi=0;
foreach (@PHEAD) {
	if ($pcoutCode eq 'sjis') { Encode::from_to($PHEAD[$phi], 'utf8', 'shiftjis'); }
	print $PHEAD[$phi];
	$phi++;
}

}
##=======================================================================================
sub html_foot {

#スキンページ読込
&page_read;

$pfi=0;
foreach (@PFOOT) {
	if ($pcoutCode eq 'sjis') { Encode::from_to($PFOOT[$pfi], 'utf8', 'shiftjis'); }
	print $PFOOT[$pfi];
	$pfi++;
}

}
##=======================================================================================
sub JsGmap {

##GmapJs設定定義
if ($Control eq 'L') { $gControlBar='map.addControl(new GLargeMapControl());'; }
elsif ($Control eq 'S') { $gControlBar='map.addControl(new GSmallMapControl());'; }
else { $gControlBar=''; }
if ($Switch == 1) { $gSwitchButton='map.addControl(new GMapTypeControl());'; }
else { $gSwitchButton=''; }
if ($Scale == 1) { $gScaleBar='map.addControl(new GScaleControl());'; }
else { $gScaleBar=''; }
if ($SubMap == 1) { $gSubMap='map.addControl(new GOverviewMapControl(new GSize('.$SubWidth.', '.$SubHeight.')));'; }
else { $gSubMap=''; }

$LSJS1 = <<"LSJS1";
<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=$GmapKey" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript">
//<![CDATA[
function load() {
  if (GBrowserIsCompatible()) {
    var map = new GMap2(document.getElementById("map"));
    var IdoKeido = new GLatLng($DefIdo, $DefKeido);
    map.setCenter(IdoKeido, $MapZoom);
    $gControlBar
    $gSwitchButton
    $gScaleBar
    $gSubMap
    map.enableContinuousZoom();
    map.enableDoubleClickZoom();
LSJS1
$JsGmap=$LSJS1;

##GmapJsマーカー定義
$datalot=@NEW-1;
$mi=0; $OpenFlag=0;
for (0..$datalot) {
	@LINE = split(/\t/,$NEW[$mi]);
	foreach (@LINE) {
		($key, $value) = split(/=/,$_);
		$value =~ s/\|eq\|/=/g;
		$value =~ s/\|quot\|/”/g;
		$value =~ s/\|apos\|/’/g;
		$FILE{$key} = $value;
	}
	$vCode = $FILE{'code'};
	$vShow = $FILE{'show'};
	$vTitle = $FILE{'title'};
		$vTitle =~ s/\//\\\//g;
		$vTitle =~ s/\(/\\\(/g;
		$vTitle =~ s/\)/\\\)/g;
		$vTitle =~ s/\&/\\\&/g;
		$vTitle =~ s/\./\\\./g;
	$vSummary = $FILE{'summary'};
		$vSummary =~ s/\//\\\//g;
		$vSummary =~ s/\(/\\\(/g;
		$vSummary =~ s/\)/\\\)/g;
		$vSummary =~ s/\&/\\\&/g;
		$vSummary =~ s/\./\\\./g;
		if ($vSummary ne '') { $mSummary='<br \/>'.$vSummary; } else { $mSummary=''; }
	$vPhone = $FILE{'phone'};
		$vPhone =~ s/\//\\\//g;
		$vPhone =~ s/\(/\\\(/g;
		$vPhone =~ s/\)/\\\)/g;
		$vPhone =~ s/\./\\\./g;
		if ($vPhone ne '') { $mPhone='<br \/>TEL:'.$vPhone; } else { $mPhone=''; }
	$vFax = $FILE{'fax'};
		$vFax =~ s/\//\\\//g;
		$vFax =~ s/\(/\\\(/g;
		$vFax =~ s/\)/\\\)/g;
		$vFax =~ s/\./\\\./g;
		if ($vFax ne '') { $mFax='<br \/>FAX:'.$vFax; } else { $mFax=''; }
	$vAlign = $FILE{'align'};
	$vIdo = $FILE{'ido'};
	$vKeido = $FILE{'keido'};
	
	#プロットデータ
	$MarkerCode='Marker'.$vCode;
	$LabelCode='Label'.$vCode;
	if (($vIdo ne 'NoneSet')||($vKeido ne 'NoneSet')) {
		if (($OpenFlag==0)&&($mi==$pline)) {
			$OpenJsTag=$MarkerCode.'.openInfoWindowHtml('.$LabelCode.');'."\n"; $OpenFlag=1;
		} else { $OpenJsTag=''; }
		$LSJS2 = <<"LSJS2";
    var $MarkerCode = new GMarker(new GLatLng($vIdo, $vKeido));
    map.addOverlay($MarkerCode);
    var $LabelCode ="<b>$vTitle<\/b>$mSummary$mPhone$mFax";
    $OpenJsTag
    GEvent.addListener($MarkerCode, 'click', function() { $MarkerCode.openInfoWindowHtml($LabelCode); });
LSJS2
	} else {
		$LSJS2='';
	}
	$JsGmap=$JsGmap.$LSJS2;
	$mi++;
}

$LSJS3 = <<"LSJS3";
  }
}
//]]>
</script>
$HtmlHeader
$RdfTag
</head>
<body onload="load();" onunload="GUnload();" 
LSJS3
$JsGmap=$JsGmap.$LSJS3;

}
##=======================================================================================
sub html_list {

$end_data = @NEW - 1;
$page_top = $pline;
$page_end = $pline + ($PageView - 1);
if ($page_end >= $end_data) { $page_end = $end_data; }

if ($pcoutCode eq 'sjis') { Encode::from_to($PageTitle, 'utf8', 'shiftjis'); }
if ($pcoutCode eq 'sjis') { Encode::from_to($PageHeadMsg, 'utf8', 'shiftjis'); }

##MAP出力
if ($PgTitleClass ne '') { $addTitleClass=' class="'.$PgTitleClass.'"'; }
if ($PageTitle ne '') { print '<h2'.$addTitleClass.'>'.$PageTitle.'</h2>'."\n"; }
if ($PageHeadMsg ne '') {
	print '<div class="KijiArea"><p>'.$PageHeadMsg.'</p></div>';
}
print '<div id="map" style="width:'.$MapWidth.'px;height:'.$MapHeight.'px;font-size:small;margin:0px auto 5px auto;">GoogleMap</div>'."\n";

##LIST出力
foreach ($pline..$page_end) {
	@LINE = split(/\t/,$NEW[$_]);
	foreach (@LINE) {
		($key, $value) = split(/=/,$_);
		$value =~ s/\|eq\|/=/g;
		$value =~ s/\|quot\|/\"/g;
		$value =~ s/\|apos\|/\'/g;
		$FILE{$key} = $value;
	}
	$vCode = $FILE{'code'};
	$vShow = $FILE{'show'};
	$vTshow = $FILE{'tshow'};
	$vTitle = $FILE{'title'};
		$vTitle = &tag_change($vTitle);
		$vTitle = &EmojiTagToGif($vTitle);
	$vSummary = $FILE{'summary'};
		$vSummary = &inline_link($vMessage);
		$vSummary = &tag_change($vMessage);
		$vSummary = &EmojiTagToGif($vMessage);
		$vSummary =~ s/<br>/<br \/>/g;
		$vSummary =~ s/<BR>/<br \/>/g;
		$vSummary =~ s/<br \/><br \/>/<br \/> \n<br \/> \n/g;
	$vMessage = $FILE{'message'};
		$vMessage = &inline_link($vMessage);
		$vMessage = &tag_change($vMessage);
		$vMessage = &EmojiTagToGif($vMessage);
		$vMessage =~ s/\|br\|//g;
		$vMessage =~ s/<br>/<br \/>/g;
		$vMessage =~ s/<BR>/<br \/>/g;
		$vMessage =~ s/<br \/><br \/>/<br \/> \n<br \/> \n/g;
		$vMessage = &cgi_include($vMessage);
		$vMessage = &url_import($vMessage);
		if ($vMessage ne "") { $vMessage=$vMessage.'<br />'; } else { $vMessage=''; }
	$vPhone = $FILE{'phone'};
		if ($vPhone ne "") { $vPhone='TEL: '.$vPhone; } else { $vPhone=''; }
	$vFax = $FILE{'fax'};
		if ($vFax ne "") { $vFax=' / FAX: '.$vFax; } else { $vFax=''; }
	$vAlign = $FILE{'align'};
	$vIdo = $FILE{'ido'};
	$vKeido = $FILE{'keido'};
	##★添付ファイル1があれば表示
	$FtLot=@FileType-1;$i=0;
	for (0..$FtLot) {
		$f0_filepath = $img_dir.$vCode.'0.'.$FileType[$i];
		$h0_filepath = $img_path.$vCode.'0.'.$FileType[$i];
		if ($FileType[$i] eq 'jpg') { $FtypeName='[JPG画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'gif') { $FtypeName='[GIF画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mmf') { $FtypeName='[MMF音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mld') { $FtypeName='[MLD音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp4') { $FtypeName='[MPEG4動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3gp') { $FtypeName='[QuickTime動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3g2') { $FtypeName='[QuickTime動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; $FtypeImg=0; }
		if ((-e $f0_filepath)&&($FtypeImg==1)) {
			if ($vAlign eq "none") {
				$f0_imgtag = "<img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f0_filetag='';
				$f1_clear='';
			} elsif ($vAlign eq "bottom") {
				$f0_imgtag = '';
				$f0_filetag="<br /><img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" />";
				$f1_clear='';
			} elsif ($vAlign eq "pane") {
				$f0_imgtag = "<img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" />";
				$f0_filetag='';
				$f1_clear='';
			} elsif ($vAlign eq "left") {
				$f0_imgtag = "<img src=\"$h0_filepath\" align=\"left\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f0_filetag='';
				$f1_clear='<br clear="all" />';
			} elsif ($vAlign eq "right") {
				$f0_imgtag = "<img src=\"$h0_filepath\" align=\"right\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f0_filetag='';
				$f1_clear='<br clear="all" />';
			}
			last;
		}	elsif ((-e $f0_filepath)&&($FtypeImg==0)) {
			$f0_imgtag='';
			$f0_filetag = '<a href="'.$h0_filepath.'" target="top"><img src="../icon/'.$FileType[$i]
				.'.gif" align="middle" border="0" alt="*" />'.$FtypeName.'</a>';
			last;
		} else { $f0_imgtag=''; $f0_filetag='' }
		$i++;
	}
	##★添付ファイル2があれば表示
	$FtLot=@FileType-1;$i=0;
	for (0..$FtLot) {
		$f0_filepath = $img_dir.$vCode.'1.'.$FileType[$i];
		$h0_filepath = $img_path.$vCode.'1.'.$FileType[$i];
		if ($FileType[$i] eq 'jpg') { $FtypeName='[JPG画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'gif') { $FtypeName='[GIF画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mmf') { $FtypeName='[MMF音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mld') { $FtypeName='[MLD音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp4') { $FtypeName='[MPEG4動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3gp') { $FtypeName='[QuickTime動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3g2') { $FtypeName='[QuickTime動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; $FtypeImg=0; }
		if ((-e $f0_filepath)&&($FtypeImg==1)) {
			if ($vAlign eq "none") {
				$f1_imgtag = "<img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" /><br>";
				$f1_filetag='';
				$f1_clear='';
			} elsif ($vAlign eq "bottom") {
				$f1_imgtag = '';
				$f1_filetag= "<br /><img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" />";
				$f1_clear='';
			} elsif ($vAlign eq "pane") {
				$f1_imgtag = "<img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f1_filetag='';
				$f1_clear='';
			} elsif ($vAlign eq "left") {
				$f1_imgtag = "<img src=\"$h0_filepath\" align=\"left\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f1_filetag='';
				$f1_clear='<br clear=all>';
			} elsif ($vAlign eq "right") {
				$f1_imgtag = "<img src=\"$h0_filepath\" align=\"right\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f1_filetag='';
				$f1_clear='<br clear="all" />';
			}
			last;
		}	elsif ((-e $f0_filepath)&&($FtypeImg==0)) {
			$f1_imgtag='';
			$f1_filetag = '<a href="'.$h0_filepath.'" target="top"><img src="../icon/'.$FileType[$i]
				.'.gif" align="middle" border="0" style="margin:5px" alt="*" />'.$FtypeName.'</a>';
			last;
		} else { $f1_imgtag =''; $f1_filetag='' }
		$i++;
	}
	##★管理画面リストの変更はここを訂正
	if (($in{'mode'} eq 'list')||($in{'mode'} eq '')) {
		$TagToDetail='<small style="font-weight:normal;"><a href="'.$cginame.'?pg='
		.$vCode.'&amp;pline='.$pline.'">'.$ShowDetail.'</a></small>';
	}
	if ($vTshow eq '') { $vTshow='strong'; }
	if ($vTitle ne "") {
		$htmlc_list = <<"LISTC";
		<a name="kiji$vCode" id="kiji$vCode">&#32;</a>
		<$vTshow> $vTitle $TagToDetail</$vTshow>
		<div class="KijiArea">
		$f0_imgtag $f1_imgtag $vMessage $vPhone $vFax $f0_filetag $f1_filetag $f1_clear &#32;
		</div>
LISTC
	} else {
		$htmlc_list = <<"LISTC";
		<div class="KijiArea"><a name="kiji$vCode" id="kiji$vCode"></a>
		$f0_imgtag $f1_imgtag $vMessage $vPhone $vFax $f0_filetag $f1_filetag $f1_clear &#32;
		</div>
LISTC
	}
	if ($ListView eq 'ListView') {
		if ($pcoutCode eq 'sjis') { Encode::from_to($htmlc_list, 'utf8', 'shiftjis'); }
		print $htmlc_list;
	}
}


##NAVI出力
$next_line = $page_end + 1;
$back_line = $page_top - $PageView;

print "<p class=\"PageNavi\">\n";

if (($page_top != 0)&&($DataLot > 1)) {
	$BackURL=$cginame.'?mode=list&amp;pline='.$back_line;
	$tagNavigator= "<a href=\"$BackURL\" class=\"NaviBack\">$NaviBack</a>\n";
	if ($pcoutCode eq 'sjis') { Encode::from_to($tagNavigator, 'utf8', 'shiftjis'); }
	print $tagNavigator;
}

if (($page_end != $end_data)&&($DataLot > 1)) {
	$BackURL=$cginame.'?mode=list&amp;pline='.$next_line;
	$tagNavigator= "<a href=\"$BackURL\" class=\"NaviNext\">$NaviNext</a>\n";
	if ($pcoutCode eq 'sjis') { Encode::from_to($tagNavigator, 'utf8', 'shiftjis'); }
	print $tagNavigator;
}

if ($in{'mode'} eq 'detail') {
	$BackURL=$cginame.'?mode=list&amp;pline='.$pline;
	$tagNavigator= "<a href=\"$BackURL\" class=\"NaviNext\">$BackToList</a>\n";
	if ($pcoutCode eq 'sjis') { Encode::from_to($tagNavigator, 'utf8', 'shiftjis'); }
	print $tagNavigator;
}

print '&#32;</p>'."\n";

}
##=======================================================================================
sub data_read {
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($datafile);
		if ($contCC eq 'shiftjis') {
			foreach (@DATA) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('DBファイルの読込に失敗しました。'); }
}
##=======================================================================================
sub page_read {

	if ($RootPath ne '') { $BaseRoot='/'.$RootPath; } else { $BaseRoot=''; }
	$QRCodeS='<img src="http://adedit.norenz.net/qrcode/qr_img.cgi?d=http://'.$Domain.$BaseRoot.'/mobi/&amp;s=2" alt="QRコード" />';
	$QRCodeM='<img src="http://adedit.norenz.net/qrcode/qr_img.cgi?d=http://'.$Domain.$BaseRoot.'/mobi/&amp;s=3" alt="QRコード" />';
	$QRCodeL='<img src="http://adedit.norenz.net/qrcode/qr_img.cgi?d=http://'.$Domain.$BaseRoot.'/mobi/&amp;s=4" alt="QRコード" />';
	if (open(PAGEREAD,"$SkinFile")) {
		@PAGE = <PAGEREAD>;
		close(PAGEREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($SkinFile);
		if ($contCC eq 'shiftjis') {
			foreach (@PAGE) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else {
		$alSkinFile=$SkinFile; $alSkinFile=~ s/\.\.//i;
		$PAGE[0] ='<html>'."\n";
		$PAGE[1] ='<head><meta http-equiv="Content-Type" content="text/html;charset='.$pcoutCode.'"></head>'."\n";
		$PAGE[2] ='<body><h2 style="color:red">[設定]にて指定したスキンファイル ['.$alSkinFile.'] が存在しません</h2>'."\n";
		$PAGE[3] ='<span style="color:red">[設定]にて正しいスキンファイルを指定するか、[スキン編集]にて作成する必要があります</span>'."\n";
		$PAGE[4] ='<!-- MainZone -->'."\n";
		$PAGE[5] ='<body></html>'."\n";
	}
	#AD-EDITでメニューデータがあれば表示
	$MenuFile=''; $mzi=1;
	for (0..20) {
		@MenuZone=();
		$MenuHTML[$mzi]='';
		$MenuFile='../admin/menu'.$mzi.'.inc';
		if (-e $MenuFile) {
			open(MENURD,"$MenuFile");
			@MenuZone = <MENURD>;
			close(MENURD);
			##文字コード判定→UTF8変換
			my $contCC=&checkCharCode($MenuFile);
			if ($contCC eq 'shiftjis') {
				foreach (@MenuZone) { Encode::from_to($_, 'shiftjis', 'utf8'); }
			}
			$LotMenuLine=@MenuZone;
			$mzline=0;
			for (0..$LotMenuLine) { $MenuHTML[$mzi]=$MenuHTML[$mzi].$MenuZone[$mzline].''; $mzline++; }
		} else { last; }
		$mzi++;
	}
	$mzi=$mzi-1;
	$pageflag = 0;
	@PHEAD = (); @PFOOT = (); $pi = 0;
	foreach (@PAGE) {
		if ($PAGE[$pi] =~ /MainZone/i) {
			$PAGE[$pi]=~ s/<\!-- MainZone -->/<\!--MainZone-->/g;
			($SkinBefore,$SkinAfter)=split(/<\!--MainZone-->/,$PAGE[$pi]);
			$PAGE[$pi]=$SkinBefore;
			push(@PFOOT,$SkinAfter);
			$pageflag = 1;
		}
		$PAGE[$pi]=~ s/<\/head>//g;
		$PAGE[$pi]=~ s/<body/$JsGmap/i;
		$mzj=1;
		for (0..$mzi) {
			$PAGE[$pi]=~ s/<MenuZone$mzj>/$MenuHTML[$mzj]/g;
			$mzj++;
		}
		$PAGE[$pi]=~ s/<QRCodeS>/$QRCodeS/g;
		$PAGE[$pi]=~ s/<QRCodeM>/$QRCodeM/g;
		$PAGE[$pi]=~ s/<QRCodeL>/$QRCodeL/g;
		$PAGE[$pi]=~ s/<\/title>/ - $PageTitle<\/title>/i;
		$PAGE[$pi]=~ s/<\/h1>/ - $PageTitle<\/h1>/i;
		$PAGE[$pi] = &cgi_include($PAGE[$pi]);
		$PAGE[$pi] = &url_import($PAGE[$pi]);
		if ($pageflag==0) { push(@PHEAD,$PAGE[$pi]); }
		if ($pageflag==1) { push(@PFOOT,$PAGE[$pi]); }
		$pi++;
	}
}
##=======================================================================================
sub tag_change {
	##	$var = &tag_change($var); で変換する
	if ($RootPath ne '') { $TcRootPath='/'.$RootPath; } else { $TcRootPath=''; }
	local($_) = $_[0];
	1 while s/\[new\]/<img src=\"$TcRootPath\/icon\/new\.gif\" align=\"middle\" alt=\"new\" border=\"0\" \/>/g;
	1 while s/\[red\]/<span style=\"color\:\#FF0000\">/g;
	1 while s/\[\/red\]/<\/span>/g;
	1 while s/\[blue\]/<span style=\"color\:\#0000FF\">/g;
	1 while s/\[\/blue\]/<\/span>/g;
	1 while s/\[green\]/<span style=\"color\:\#009900\">/g;
	1 while s/\[\/green\]/<\/span>/g;
	1 while s/\/TD>/\/td>/g;
	1 while s/<TD/<td/g;
	1 while s/\/TR>/\/tr>/g;
	1 while s/<TR/<tr/g;
	1 while s/\/TABLE>/\/table>/g;
	1 while s/<TABLE/<table/g;
	1 while s/\/TBODY>/\/tbody>/g;
	1 while s/<TBODY/<tbody/g;
	1 while s/AeDirTop/index.cgi/g;
	$_;
}
##=======================================================================================
sub errorout {

$error = $_[0];

$ReturnLink='<a href="javascript:history.go(-1)">[先程のページへ戻る]</a>';

##★エラーメッセージの変更はここを訂正
$errHTML = <<"ERRORMESS";
<h4 align="center"><span style="color:#ff0000">ERROR</span></h4>
<div align="center">&nbsp;<br>$error<br>&nbsp;<br>$ReturnLink</div>
ERRORMESS

if ($pcoutCode eq 'sjis') { Encode::from_to($errHTML, 'utf8', 'shiftjis'); }
print $errHTML;
&html_foot;
exit;

}
##=======================================================================================
