#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT CORE v3.2.0
## (c)2008-2011 NorenzPRO Ltd. TakafumiArai 2011/4/4
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリファイルのパス。
use strict;
use Encode;
require '../admin/aelib.cgi';

##★データファイルのパス
our $datafile = '../admin/dir.dat';


##=====================================================================================##
##メインルーチン
##=====================================================================================##

##システム設定ファイル読込
our $servconf = '../admin/conf.dat';
our $pcoutCode;
our @SVCONF;
our $PrivateContents;
our @Privates;
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
	$pcoutCode =$SVCONF[22];
	$pcoutCode =~ s/\r//g; $pcoutCode =~ s/\n//g;
	$PrivateContents =$SVCONF[24];
	$PrivateContents =~ s/\r//g; $PrivateContents =~ s/\n//g;
	@Privates = split(/\,/,$PrivateContents);
}
if ($pcoutCode eq '') { $pcoutCode='sjis'; }

&data_read;
&NewsList;
exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub NewsList {

##イニシャライズ
our @DATA;
our $DataLot=@DATA-1;
my $i=0;
our @year;
our @mon;
our @day;
our @hour;
our @min;
our @sec;
our @lastmodified;
our @modline;
our @Title;

##最終更新日調査
for (0..$DataLot) {
	our $DirList =$DATA[$i];
		$DirList =~ s/\r//g;
		$DirList =~ s/\n//g;
	our @DirName=split(/\,/,$DirList);
	our $LogFile='../'.$DirName[0].'/data.dat';
	##プライベートコンテンツ判定
	my $PrivateFlag=0;
	my $pi=0;
	foreach (@Privates) {
		if ($Privates[$pi] eq $DirName[0]) { $PrivateFlag=1; }
	}
	##更新日調査
	my ($devNo,$inoNo,$ChMod,$linkLot,$uID,$gID,$rDev,$fSize,$aTime,$mTime,$cTime,$BlkSize,$Blocks) = stat($LogFile);
	($sec[$i],$min[$i],$hour[$i],$day[$i],$mon[$i],$year[$i]) = localtime($mTime);
		$year[$i] = sprintf("%04d",$year[$i]-100);
		$mon[$i] = sprintf("%02d",$mon[$i]+1);
		$day[$i] = sprintf("%02d",$day[$i]);
		$hour[$i] = sprintf("%02d",$hour[$i]);
		$min[$i] = sprintf("%02d",$min[$i]);
		$sec[$i] = sprintf("%02d",$sec[$i]);
		$lastmodified[$i]=$year[$i].$mon[$i].$day[$i].$hour[$i].$min[$i].$sec[$i];
	our $LogSize = -s $LogFile;
	if (($LogSize > 0)&&($PrivateFlag==0)) {
		$modline[$i]=$lastmodified[$i]."\t".$DirName[0]."\t";
	}
	$i++;
}

##最終更新日のソート
our @newmodified = sort { $b <=> $a } @modline;

##新着タグ出力
$i=0;
our @name;
our @dir;
our @time;
our $ConfFile;
our $ViewLot = @newmodified-1;
my $tagList;
print "Content-type: text/html\n\n";
$tagList="<ul>\n";
if (@newmodified > 4) { $ViewLot=4; }
for (0..$ViewLot) {
	($time[$i],$dir[$i])=split(/\t/,$newmodified[$i]);
	my $yy=substr($time[$i],2,2);
	my $mm=substr($time[$i],4,2);
	my $dd=substr($time[$i],6,2);
	##コンテンツ名取得
	$ConfFile='../'.$dir[$i].'/conf.dat';
	if (open(CONFRD,"$ConfFile")) {
		our @CONF = <CONFRD>;
		$name[$i]=$CONF[0];
		close(CONFRD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($ConfFile);
		if ($contCC eq 'shiftjis') {
			Encode::from_to($name[$i], 'shiftjis', 'utf8');
		}
	} else { $name[$i]='未設定ページ'; }
	$tagList=$tagList.'<li><a href="./'.$dir[$i].'/index.cgi">'.$name[$i].'['.$mm.'/'.$dd.']</a></li>'."\n";
	$i++;
}
$tagList=$tagList."</ul>\n";
if ($pcoutCode eq 'sjis') { Encode::from_to($tagList, 'utf8', 'shiftjis'); }
print $tagList;

}
##=======================================================================================
sub data_read {
	our @DATA=();
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
	} else { &errorout('ファイル読込失敗'); }
}
##=======================================================================================
sub errorout {

my $error = $_[0];

##★エラーメッセージの変更はここを訂正
my $errHTML = <<"ERRORMESS";
<span style="color:#ff0000">ERROR</span>
<div align="center">&nbsp;<br>$error</div>
ERRORMESS

print "Content-type: text/html\n\n";
if ($pcoutCode eq 'sjis') { Encode::from_to($errHTML, 'utf8', 'shiftjis'); }
print $errHTML;
exit;

}
##=======================================================================================
