#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT GMAP v4.0.1
## (c)2008-2011 NorenzPRO Ltd. TakafumiArai 2011/11/21
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##==============基本設定==============

##★ライブラリファイルのパス。
use Encode;
require '../admin/emoji.pl';
require '../admin/aelib.cgi';

##★このスクリプトの名前
$cginame = 'smobi.cgi';

##★データファイルのパス
$datafile = './data.dat';

##★アップロード画像格納ディレクトリ（相対・絶対パス）
$img_dir = './file/';

##★アップロード画像公開ディレクトリ（相対・絶対パス）
$img_path = './file/';

##★初期画面の選択
## 地図:DEFAULT / 衛星写真:SATELLITE / 地図+衛星:HYBRID
$MapType = 'ROADMAP';

##★コントロールボタン[左上]
## 大:DEFAULT  / 小:SMALL
$ControlStyle = 'DEFAULT';

##★地図/衛星切替ボタの表示(する:1/しない:0)
$Switch = 1;

##★縮尺スケールの表示(する:1/しない:0)
$Scale = 1;

##=====================================================================================##
##メインルーチン
##=====================================================================================##

##キャリア転送
$ua = $ENV{"HTTP_USER_AGENT"};
if ($ua =~ /DoCoMo\/1\.0/i) { $xCR='mobi'; }
elsif ($ua =~ /Mozilla/i) { $xCR='pc'; }
elsif ($ua =~ /(DoCoMo\/2\.0|FOMA)/i) { $xCR='mobi'; }
elsif ($ua =~ /^(SoftBank|Vodafone|J\-PHONE|MOT\-[CV])/i) { $xCR='mobi'; }
elsif ($ua =~ /^UP\.Browser/i) { $xCR='mobi'; }
elsif ($ua =~ /^(KDDI\-|OPWV|MMP)/i) { $xCR='mobi'; }
else { $xCR='pc'; }
if ($xCR eq 'mobi') {
	print "Location:mobi.cgi?".$ENV{'QUERY_STRING'}."\n\n";
	exit;
}

##システム設定ファイル読込
$servconf = '../admin/conf.dat';
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
	$Domain =$SVCONF[3];
	$Domain =~ s/\r//g; $Domain =~ s/\n//g;
	$GmapAPIkey =$SVCONF[8];
	$GmapAPIkey =~ s/\r//g; $GmapAPIkey =~ s/\n//g;
	$RootPath =$SVCONF[10];
	$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
}

##設定ファイル読込
$conffile='./conf.dat';
open(CONFRD,"$conffile");
@CONF = <CONFRD>;
close(CONFRD);
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($conffile);
if ($contCC eq 'shiftjis') {
	foreach (@CONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}
$DefIdo =$CONF[2];
$DefIdo =~ s/\r//g;$DefIdo =~ s/\n//g;
$DefKeido =$CONF[3];
$DefKeido =~ s/\r//g;$DefKeido =~ s/\n//g;
$FileTypeLine =$CONF[4];
$FileTypeLine =~ s/\r//g;$FileTypeLine =~ s/\n//g;
@FileType=split(/:/,$FileTypeLine);
$ListView =$CONF[9];
$ListView =~ s/\r//g;$ListView =~ s/\n//g;
$MapZoom =$CONF[16];
$MapZoom =~ s/\r//g;$MapZoom =~ s/\n//g;
$NaviBack =$CONF[21];
$NaviBack =~ s/\r//g;$NaviBack =~ s/\n//g;
$NaviNext =$CONF[22];
$NaviNext =~ s/\r//g;$NaviNext =~ s/\n//g;
$BackToList =$CONF[28];
$BackToList =~ s/\r//g;$BackToList =~ s/\n//g;
$ShowDetail =$CONF[29];
$ShowDetail =~ s/\r//g;$ShowDetail =~ s/\n//g;
$DirName =$CONF[31];
$DirName =~ s/\r//g;$DirName =~ s/\n//g;
$smrtSkinFile =$CONF[42];
$smrtSkinFile =~ s/\r//g;$smrtSkinFile =~ s/\n//g;
if ($smrtSkinFile eq '') { $smrtSkinFile='/skin/smobi.html'; }
$smrtSkinFile ='..'.$smrtSkinFile;
$SmartTitle =$CONF[43];
$SmartTitle =~ s/\r//g;$SmartTitle =~ s/\n//g;
$smrtTitleClass =$CONF[44];
$smrtTitleClass =~ s/\r//g;$smrtTitleClass =~ s/\n//g;
$hdSmartTitle =$CONF[45];
$hdSmartTitle =~ s/\r//g;$hdSmartTitle =~ s/\n//g;
$SmartHeadMsg =$CONF[46];
$SmartHeadMsg = &inline_link($SmartHeadMsg);
$SmartHeadMsg = &tag_change($SmartHeadMsg);
$SmartHeadMsg =~ s/\r//g;$SmartHeadMsg =~ s/\n//g;
$SmartHeadMsg =~ s/<br>/<br \/>\&\#32\;/g;
$SmartHeadMsg = &cgi_include($SmartHeadMsg);
$SmartHeadMsg = &url_import($SmartHeadMsg);
$SmartHtmlHeader =$CONF[47];
$SmartHtmlHeader =~ s/\r//g;$SmartHtmlHeader =~ s/\n//g;
$SmartHtmlHeader =~ s/<br>/\n/g;
$smartview =$CONF[48];
$smartview =~ s/\r//g;$smartview =~ s/\n//g;
$smMapWidth =$CONF[49];
$smMapWidth =~ s/\r//g;$smMapWidth =~ s/\n//g;
$smMapHeight =$CONF[50];
$smMapHeight =~ s/\r//g;$smMapHeight =~ s/\n//g;

$GmapKey=$GmapAPIkey;
if ($NaviBack eq '') { $NaviBack='[＜＜ＢＡＣＫ]'; }
if ($NaviNext eq '') { $NaviNext='[ＮＥＸＴ＞＞]'; }
if ($ShowDetail eq '') { $ShowDetail='[地図表示]'; }
if ($BackToList eq '') { $BackToList='[先ほどのページへ戻る]'; }
if ($smMapWidth eq '') { $smMapWidth='95%'; }
if ($smMapHeight eq '') { $smMapHeight='280px'; }
if ($hdSmartTitle eq '') { $hdSmartTitle=$SmartTitle; }
if ($smartview eq '') { $smartview='5'; }

##フォームの取得
$buffer = $ENV{'QUERY_STRING'};
@pairs = split(/&/,$buffer);
for $pair (@pairs) {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$in{$name} = $value;
}
if ($in{'pline'} eq '') { $pline = 0; } else { $pline = $in{'pline'}; }
if ($in{'pg'} ne '') { $in{'mode'}='detail'; $in{'code'}=$in{'pg'}; }
if ($in{'mode'} eq 'detail') { $pback=$pline; $pline='0'; }

##携帯アクセス転送
if ($xCR eq 'mobi') {
	if ($in{'pg'} ne '') {
		print 'Location:mbmap.cgi?pg='.$in{'pg'}."\n\n";
		exit;
	} else {
		print 'Location:mobi.cgi'."\n\n";
		exit;
	}
}

##DATA取得
&data_read;
if ($in{'mode'} eq 'preview') {
	@NEW = grep(/code=$in{'code'}\t/,@DATA);
} elsif ($in{'mode'} eq 'detail') {
	@TRUE = grep(/code=$in{'code'}\t/,@DATA);
	@NEW = grep(/\tshow=on\t/,@TRUE);
} elsif ($in{'mode'} eq 'result') {
	@TRUE = grep(/code=$in{'code'}\t/,@DATA);
	@NEW = grep(/\tshow=on\t/,@TRUE);
} else {
	@TRUE = grep(/code=/,@DATA);
	@NEW = grep(/\tshow=on\t/,@TRUE);
}
$DataLot=@NEW;

##==============メインアクション==============

if ($RootPath ne '') {
	$RssURL='http://'.$Domain.'/'.$RootPath.'/'.$DirName.'/rdfout.cgi';
} else {
	$RssURL='http://'.$Domain.'/'.$DirName.'/rdfout.cgi';
}
$RdfTag='<link rel="alternate" type="application/rss+xml" title="'.$hdSmartTitle.'" href="'.$RssURL.'" />';

&JsGmap;
&html_head;
&html_list;
&html_foot;


exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

#スキンページ読込
&page_read;

print "Content-type: text/html\n\n";
$phi=0;
foreach (@PHEAD) {
	print $PHEAD[$phi];
	$phi++;
}

}
##=======================================================================================
sub html_foot {

#スキンページ読込
&page_read;

$pfi=0;
foreach (@PFOOT) {
	print $PFOOT[$pfi];
	$pfi++;
}

}
##=======================================================================================
sub JsGmap {

##GmapJs設定定義
if ($Switch == 1) { $gSwitchButton='true'; } else { $gSwitchButton='false'; }
if ($Scale == 1) { $gScaleBar='true'; } else { $gScaleBar='false'; }

$LSJS1 = <<"LSJS1";
<meta name="viewport" content="initial-scale=1.0, user-scalable=no" />
<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=true" charset="utf-8"></script>
<script type="text/javascript">
var GoogleMapBox = {
	map: null,
	infoWindow: null
};
GoogleMapBox.closeInfoWindow = function() {
	GoogleMapBox.infoWindow.close();
};
GoogleMapBox.openInfoWindow = function(marker,info) {
	GoogleMapBox.infoWindow.setContent(info);
	GoogleMapBox.infoWindow.open(GoogleMapBox.map, marker);
}
GoogleMapBox.init = function() {
	GoogleMapBox.map = new google.maps.Map(document.getElementById('map-canvas'), {
		mapTypeId: google.maps.MapTypeId.$MapType,
		mapTypeControl: true,
		zoom: $MapZoom,
		center: new google.maps.LatLng($DefIdo, $DefKeido),
		scaleControl: $gScaleBar,
		navigationControl: true,
		navigationControlOptions: {
			style: google.maps.NavigationControlStyle.$ControlStyle,
			position: google.maps.ControlPosition.TOP_LEFT
		}
	});
	GoogleMapBox.infoWindow = new google.maps.InfoWindow();
	google.maps.event.addListener(GoogleMapBox.map, 'click', GoogleMapBox.closeInfoWindow);
LSJS1
$JsGmap=$LSJS1;

##GmapJsマーカー定義
$datalot=@NEW-1;
$mi=0; $OpenFlag=0;
for (0..$datalot) {
	@LINE = split(/\t/,$NEW[$mi]);
	foreach (@LINE) {
		($key, $value) = split(/=/,$_);
		$value =~ s/\|eq\|/=/g;
		$value =~ s/\|quot\|/”/g;
		$value =~ s/\|apos\|/’/g;
		$FILE{$key} = $value;
	}
	$vCode = $FILE{'code'};
	$vShow = $FILE{'show'};
	$vTitle = $FILE{'title'};
		$vTitle =~ s/\//\\\//g;
		$vTitle =~ s/\(/\\\(/g;
		$vTitle =~ s/\)/\\\)/g;
		$vTitle =~ s/\&/\\\&/g;
		$vTitle =~ s/\./\\\./g;
	$vSummary = $FILE{'summary'};
		$vSummary =~ s/\//\\\//g;
		$vSummary =~ s/\(/\\\(/g;
		$vSummary =~ s/\)/\\\)/g;
		$vSummary =~ s/\&/\\\&/g;
		$vSummary =~ s/\./\\\./g;
		if ($vSummary ne '') { $mSummary='<br \/>'.$vSummary; } else { $mSummary=''; }
	$vPhone = $FILE{'phone'};
		$vPhone =~ s/\//\\\//g;
		$vPhone =~ s/\(/\\\(/g;
		$vPhone =~ s/\)/\\\)/g;
		$vPhone =~ s/\./\\\./g;
		if ($vPhone ne '') { $mPhone='<br \/>TEL:'.$vPhone; } else { $mPhone=''; }
	$vFax = $FILE{'fax'};
		$vFax =~ s/\//\\\//g;
		$vFax =~ s/\(/\\\(/g;
		$vFax =~ s/\)/\\\)/g;
		$vFax =~ s/\./\\\./g;
		if ($vFax ne '') { $mFax='<br \/>FAX:'.$vFax; } else { $mFax=''; }
	$vAlign = $FILE{'align'};
	$vIdo = $FILE{'ido'};
	$vKeido = $FILE{'keido'};
	
	#プロットデータ
	$MarkerCode='Marker'.$vCode;
	$PositionCode='Pos'.$vCode;
	$LabelCode='Label'.$vCode;
	if (($vIdo ne 'NoneSet')||($vKeido ne 'NoneSet')) {
		if (($OpenFlag==0)&&($mi==$pline)) {
			$OpenJsTag='GoogleMapBox.openInfoWindow('.$MarkerCode.','.$LabelCode.');'; $OpenFlag=1;
		} else { $OpenJsTag=''; }
		
		$LSJS2 = <<"LSJS2";
    //$MarkerCode
    var $PositionCode= new google.maps.LatLng($vIdo, $vKeido);
    var $LabelCode= "<b>$vTitle<\\/b>$mSummary$mPhone$mFax";
    var $MarkerCode = new google.maps.Marker({
    map: GoogleMapBox.map,
    position: $PositionCode,
    draggable: false
    });
    google.maps.event.addListener($MarkerCode, 'click', function() {
    GoogleMapBox.openInfoWindow($MarkerCode,$LabelCode);
    });
    $OpenJsTag
LSJS2
	} else {
		$LSJS2='';
	}
	$JsGmap=$JsGmap.$LSJS2;
	$mi++;
}

$LSJS3 = <<"LSJS3";
}
</script>
$SmartHtmlHeader
$RdfTag
</head>
<body onload="GoogleMapBox.init();" 
LSJS3
$JsGmap=$JsGmap.$LSJS3;

}
##=======================================================================================
sub html_list {

$end_data = @NEW - 1;
$page_top = $pline;
$page_end = $pline + ($smartview - 1);
if ($page_end >= $end_data) { $page_end = $end_data; }

##MAP出力
if ($smrtTitleClass ne '') { $addTitleClass=' class="'.$smrtTitleClass.'"'; }
if ($SmartTitle ne '') { print '<h2'.$addTitleClass.'>'.$SmartTitle.'</h2>'."\n"; }
if ($SmartHeadMsg ne '') {
	print '<div class="KijiArea">'.$SmartHeadMsg.'</div>';
}
print '<div id="map-canvas" style="width:'.$smMapWidth.';height:'.$smMapHeight.';font-size:small;margin:0px auto 5px auto;">GoogleMap</div>'."\n";

##LIST出力
foreach ($pline..$page_end) {
	@LINE = split(/\t/,$NEW[$_]);
	foreach (@LINE) {
		($key, $value) = split(/=/,$_);
		$value =~ s/\|eq\|/=/g;
		$value =~ s/\|quot\|/\"/g;
		$value =~ s/\|apos\|/\'/g;
		$FILE{$key} = $value;
	}
	$vCode = $FILE{'code'};
	$vShow = $FILE{'show'};
	$vTshow = $FILE{'tshow'};
	$vTitle = $FILE{'title'};
		$vTitle = &tag_change($vTitle);
		$vTitle = &EmojiTagToGif($vTitle);
	$vSummary = $FILE{'summary'};
		$vSummary = &inline_link($vMessage);
		$vSummary = &tag_change($vMessage);
		$vSummary = &EmojiTagToGif($vMessage);
		$vSummary =~ s/<br>/<br \/>/g;
		$vSummary =~ s/<BR>/<br \/>/g;
		$vSummary =~ s/<br \/><br \/>/<br \/> \n<br \/> \n/g;
	$vMessage = $FILE{'message'};
		$vMessage = &inline_link($vMessage);
		$vMessage = &tag_change($vMessage);
		$vMessage = &EmojiTagToGif($vMessage);
		$vMessage =~ s/\|br\|//g;
		$vMessage =~ s/<br>/<br \/>/g;
		$vMessage =~ s/<BR>/<br \/>/g;
		$vMessage =~ s/<br \/><br \/>/<br \/> \n<br \/> \n/g;
		$vMessage = &cgi_include($vMessage);
		$vMessage = &url_import($vMessage);
		if ($vMessage ne "") { $vMessage=$vMessage.'<br />'; } else { $vMessage=''; }
	$vPhone = $FILE{'phone'};
		if ($vPhone ne "") { $vPhone='TEL: <a href="tel:'.$vPhone.'">'.$vPhone.'</a>'; } else { $vPhone=''; }
	$vFax = $FILE{'fax'};
		if ($vFax ne "") { $vFax=' / FAX: '.$vFax; } else { $vFax=''; }
	$vAlign = $FILE{'align'};
	$vIdo = $FILE{'ido'};
	$vKeido = $FILE{'keido'};
	##★添付ファイル1があれば表示
	$FtLot=@FileType-1;$i=0;
	for (0..$FtLot) {
		$f0_filepath = $img_dir.$vCode.'0.'.$FileType[$i];
		$h0_filepath = $img_path.$vCode.'0.'.$FileType[$i];
		if ($FileType[$i] eq 'jpg') { $FtypeName='[JPG画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'gif') { $FtypeName='[GIF画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'png') { $FtypeName='[PNG画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mmf') { $FtypeName='[MMF音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mld') { $FtypeName='[MLD音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp4') { $FtypeName='[MPEG4動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3gp') { $FtypeName='[QuickTime動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3g2') { $FtypeName='[QuickTime動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; $FtypeImg=0; }
		if ((-e $f0_filepath)&&($FtypeImg==1)) {
			if ($vAlign eq "none") {
				$f0_imgtag = "<img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f0_filetag='';
				$f1_clear='';
			} elsif ($vAlign eq "bottom") {
				$f0_imgtag = '';
				$f0_filetag="<br /><img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" />";
				$f1_clear='';
			} elsif ($vAlign eq "pane") {
				$f0_imgtag = "<img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" />";
				$f0_filetag='';
				$f1_clear='';
			} elsif ($vAlign eq "left") {
				$f0_imgtag = "<img src=\"$h0_filepath\" align=\"left\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f0_filetag='';
				$f1_clear='<br clear="all" />';
			} elsif ($vAlign eq "right") {
				$f0_imgtag = "<img src=\"$h0_filepath\" align=\"right\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f0_filetag='';
				$f1_clear='<br clear="all" />';
			}
			last;
		}	elsif ((-e $f0_filepath)&&($FtypeImg==0)) {
			$f0_imgtag='';
			$f0_filetag = '<a href="'.$h0_filepath.'" target="top"><img src="../icon/'.$FileType[$i]
				.'.gif" align="middle" border="0" alt="*" />'.$FtypeName.'</a>';
			last;
		} else { $f0_imgtag=''; $f0_filetag='' }
		$i++;
	}
	##★添付ファイル2があれば表示
	$FtLot=@FileType-1;$i=0;
	for (0..$FtLot) {
		$f0_filepath = $img_dir.$vCode.'1.'.$FileType[$i];
		$h0_filepath = $img_path.$vCode.'1.'.$FileType[$i];
		if ($FileType[$i] eq 'jpg') { $FtypeName='[JPG画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'gif') { $FtypeName='[GIF画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'png') { $FtypeName='[PNG画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mmf') { $FtypeName='[MMF音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mld') { $FtypeName='[MLD音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp4') { $FtypeName='[MPEG4動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3gp') { $FtypeName='[QuickTime動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3g2') { $FtypeName='[QuickTime動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; $FtypeImg=0; }
		if ((-e $f0_filepath)&&($FtypeImg==1)) {
			if ($vAlign eq "none") {
				$f1_imgtag = "<img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" /><br>";
				$f1_filetag='';
				$f1_clear='';
			} elsif ($vAlign eq "bottom") {
				$f1_imgtag = '';
				$f1_filetag= "<br /><img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" />";
				$f1_clear='';
			} elsif ($vAlign eq "pane") {
				$f1_imgtag = "<img src=\"$h0_filepath\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f1_filetag='';
				$f1_clear='';
			} elsif ($vAlign eq "left") {
				$f1_imgtag = "<img src=\"$h0_filepath\" align=\"left\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f1_filetag='';
				$f1_clear='<br clear=all>';
			} elsif ($vAlign eq "right") {
				$f1_imgtag = "<img src=\"$h0_filepath\" align=\"right\" style=\"padding:5px\" alt=\"添付画像\" /><br />";
				$f1_filetag='';
				$f1_clear='<br clear="all" />';
			}
			last;
		}	elsif ((-e $f0_filepath)&&($FtypeImg==0)) {
			$f1_imgtag='';
			$f1_filetag = '<a href="'.$h0_filepath.'" target="top"><img src="../icon/'.$FileType[$i]
				.'.gif" align="middle" border="0" style="margin:5px" alt="*" />'.$FtypeName.'</a>';
			last;
		} else { $f1_imgtag =''; $f1_filetag='' }
		$i++;
	}
	##★管理画面リストの変更はここを訂正
	if (($in{'mode'} eq 'list')||($in{'mode'} eq '')) {
		$TagToDetail='<small style="font-weight:normal;"><a href="'.$cginame.'?pg='
		.$vCode.'&amp;pline='.$pline.'">'.$ShowDetail.'</a></small>';
	}
	if ($vTshow eq '') { $vTshow='strong'; }
	if ($vTitle ne "") {
		$htmlc_list = <<"LISTC";
		<a name="kiji$vCode" id="kiji$vCode">&#32;</a>
		<$vTshow> $vTitle $TagToDetail</$vTshow>
		<div class="KijiArea">
		$f0_imgtag $f1_imgtag $vMessage $vPhone $vFax $f0_filetag $f1_filetag $f1_clear &#32;
		</div>
LISTC
	} else {
		$htmlc_list = <<"LISTC";
		<div class="KijiArea"><a name="kiji$vCode" id="kiji$vCode"></a>
		$f0_imgtag $f1_imgtag $vMessage $vPhone $vFax $f0_filetag $f1_filetag $f1_clear &#32;
		</div>
LISTC
	}
	if ($ListView eq 'ListView') {
		print $htmlc_list;
	}
}


##NAVI出力
$next_line = $page_end + 1;
$back_line = $page_top - $smartview;

print "<p class=\"PageNavi\">\n";

if (($page_top != 0)&&($DataLot > 1)) {
	$BackURL=$cginame.'?mode=list&amp;pline='.$back_line;
	$tagNavigator= "<a href=\"$BackURL\" class=\"NaviBack\">$NaviBack</a>\n";
	print $tagNavigator;
}

if (($page_end != $end_data)&&($DataLot > 1)) {
	$BackURL=$cginame.'?mode=list&amp;pline='.$next_line;
	$tagNavigator= "<a href=\"$BackURL\" class=\"NaviNext\">$NaviNext</a>\n";
	print $tagNavigator;
}

if ($in{'mode'} eq 'detail') {
	$BackURL=$cginame.'?mode=list&amp;pline='.$pline;
	$tagNavigator= "<a href=\"$BackURL\" class=\"NaviNext\">$BackToList</a>\n";
	print $tagNavigator;
}

print '&#32;</p>'."\n";

}
##=======================================================================================
sub data_read {
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($datafile);
		if ($contCC eq 'shiftjis') {
			foreach (@DATA) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('DBファイルの読込に失敗しました。'); }
}
##=======================================================================================
sub page_read {

	if ($RootPath ne '') { $BaseRoot='/'.$RootPath; } else { $BaseRoot=''; }
	$QRCodeS='<img src="http://adedit.norenz.net/qrcode/qr_img.cgi?d=http://'.$Domain.$BaseRoot.'/mobi/&amp;s=2" alt="QRコード" />';
	$QRCodeM='<img src="http://adedit.norenz.net/qrcode/qr_img.cgi?d=http://'.$Domain.$BaseRoot.'/mobi/&amp;s=3" alt="QRコード" />';
	$QRCodeL='<img src="http://adedit.norenz.net/qrcode/qr_img.cgi?d=http://'.$Domain.$BaseRoot.'/mobi/&amp;s=4" alt="QRコード" />';
	if (open(PAGEREAD,"$smrtSkinFile")) {
		@PAGE = <PAGEREAD>;
		close(PAGEREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($smrtSkinFile);
		if ($contCC eq 'shiftjis') {
			foreach (@PAGE) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else {
		$alSkinFile=$smrtSkinFile; $alSkinFile=~ s/\.\.//i;
		$PAGE[0] ='<html>'."\n";
		$PAGE[1] ='<head><meta http-equiv="Content-Type" content="text/html;charset=UTF-8"></head>'."\n";
		$PAGE[2] ='<body><h2 style="color:red">[設定]にて指定したスキンファイル ['.$alSkinFile.'] が存在しません</h2>'."\n";
		$PAGE[3] ='<span style="color:red">[設定]にて正しいスキンファイルを指定するか、[スキン編集]にて作成する必要があります</span>'."\n";
		$PAGE[4] ='<!-- MainZone -->'."\n";
		$PAGE[5] ='</body></html>'."\n";
	}
	#AD-EDITでメニューデータがあれば表示
	$MenuFile=''; $mzi=1;
	for (0..20) {
		@MenuZone=();
		$MenuHTML[$mzi]='';
		$MenuFile='../admin/menu'.$mzi.'.inc';
		if (-e $MenuFile) {
			open(MENURD,"$MenuFile");
			@MenuZone = <MENURD>;
			close(MENURD);
			##文字コード判定→UTF8変換
			my $contCC=&checkCharCode($MenuFile);
			if ($contCC eq 'shiftjis') {
				foreach (@MenuZone) { Encode::from_to($_, 'shiftjis', 'utf8'); }
			}
			$LotMenuLine=@MenuZone;
			$mzline=0;
			for (0..$LotMenuLine) { $MenuHTML[$mzi]=$MenuHTML[$mzi].$MenuZone[$mzline].''; $mzline++; }
		} else { last; }
		$mzi++;
	}
	$mzi=$mzi-1;
	$pageflag = 0;
	@PHEAD = (); @PFOOT = (); $pi = 0;
	foreach (@PAGE) {
		if ($PAGE[$pi] =~ /MainZone/i) {
			$PAGE[$pi]=~ s/<\!-- MainZone -->/<\!--MainZone-->/g;
			($SkinBefore,$SkinAfter)=split(/<\!--MainZone-->/,$PAGE[$pi]);
			$PAGE[$pi]=$SkinBefore;
			push(@PFOOT,$SkinAfter);
			$pageflag = 1;
		}
		$PAGE[$pi]=~ s/<\/head>//g;
		$PAGE[$pi]=~ s/<body/$JsGmap/i;
		$mzj=1;
		for (0..$mzi) {
			$PAGE[$pi]=~ s/<MenuZone$mzj>/$MenuHTML[$mzj]/g;
			$mzj++;
		}
		$PAGE[$pi]=~ s/<QRCodeS>/$QRCodeS/g;
		$PAGE[$pi]=~ s/<QRCodeM>/$QRCodeM/g;
		$PAGE[$pi]=~ s/<QRCodeL>/$QRCodeL/g;
		$PAGE[$pi]=~ s/<\/title>/ - $hdSmartTitle<\/title>/i;
		$PAGE[$pi]=~ s/<\/h1>/ - $hdSmartTitle<\/h1>/i;
		$PAGE[$pi] = &cgi_include($PAGE[$pi]);
		$PAGE[$pi] = &url_import($PAGE[$pi]);
		if ($pageflag==0) { push(@PHEAD,$PAGE[$pi]); }
		if ($pageflag==1) { push(@PFOOT,$PAGE[$pi]); }
		$pi++;
	}
}
##=======================================================================================
sub tag_change {
	##	$var = &tag_change($var); で変換する
	if ($RootPath ne '') { $TcRootPath='/'.$RootPath; } else { $TcRootPath=''; }
	local($_) = $_[0];
	1 while s/\[new\]/<img src=\"$TcRootPath\/icon\/new\.gif\" align=\"middle\" alt=\"new\" border=\"0\" \/>/g;
	1 while s/\[red\]/<span style=\"color\:\#FF0000\">/g;
	1 while s/\[\/red\]/<\/span>/g;
	1 while s/\[blue\]/<span style=\"color\:\#0000FF\">/g;
	1 while s/\[\/blue\]/<\/span>/g;
	1 while s/\[green\]/<span style=\"color\:\#009900\">/g;
	1 while s/\[\/green\]/<\/span>/g;
	1 while s/\/TD>/\/td>/g;
	1 while s/<TD/<td/g;
	1 while s/\/TR>/\/tr>/g;
	1 while s/<TR/<tr/g;
	1 while s/\/TABLE>/\/table>/g;
	1 while s/<TABLE/<table/g;
	1 while s/\/TBODY>/\/tbody>/g;
	1 while s/<TBODY/<tbody/g;
	1 while s/AeDirTop/smobi.cgi/g;
	$_;
}
##=======================================================================================
sub errorout {

$error = $_[0];

$ReturnLink='<a href="javascript:history.go(-1)">[先程のページへ戻る]</a>';

##★エラーメッセージの変更はここを訂正
$errHTML = <<"ERRORMESS";
<h4 align="center"><span style="color:#ff0000">ERROR</span></h4>
<div align="center">&nbsp;<br>$error<br>&nbsp;<br>$ReturnLink</div>
ERRORMESS

print $errHTML;
&html_foot;
exit;

}
##=======================================================================================
