#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT HTML-EDIT v4.0.0
## (c)2008-2011 NorenzPRO Ltd. TakafumiArai 2011/11/14
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリ
use Encode;
require '../admin/aelib.cgi';

##★このスクリプトの名前
$cginame = 'mobi.cgi';

##★データファイルのパス
$datafile = './mobi.dat';

##=====================================================================================##
##メインルーチン
##=====================================================================================##

##キャリア識別
$ua = $ENV{"HTTP_USER_AGENT"};
if ($ua =~ /Android/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /iPhone/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /iPod/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /iPad/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /DoCoMo\/1\.0/i) { $xCR='dc'; }
elsif ($ua =~ /Mozilla/i) { $xCR='pc'; }
elsif ($ua =~ /(DoCoMo\/2\.0|FOMA)/i) { $xCR='dc'; }
elsif ($ua =~ /^(SoftBank|Vodafone|J\-PHONE|MOT\-[CV])/i) { $xCR='sb'; }
elsif ($ua =~ /^UP\.Browser/i) { $xCR='ez'; }
elsif ($ua =~ /^(KDDI\-|OPWV|MMP)/i) { $xCR='ez'; }
else { $xCR='pc'; }

##システム設定ファイル読込
$servconf = '../admin/conf.dat';
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
	$mboutCode =$SVCONF[23];
	$mboutCode =~ s/\r//g; $mboutCode =~ s/\n//g;
}
if ($mboutCode eq '') { $mboutCode='sjis'; }


##設定ファイル読込
$conffile='./conf.dat';
open(CONFRD,"$conffile");
@CONF = <CONFRD>;
close(CONFRD);
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($conffile);
if ($contCC eq 'shiftjis') {
	foreach (@CONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}
$MobiTitle =$CONF[4];
$MobiTitle =~ s/\r//g;$MobiTitle =~ s/\n//g;
$MobiColor =$CONF[5];
$MobiColor =~ s/\r//g;$MobiColor =~ s/\n//g;
$MobiToHome =$CONF[8];
$MobiToHome =~ s/\r//g;$MobiToHome =~ s/\n//g;
$MobiSkin =$CONF[15];
$MobiSkin =~ s/\r//g;$MobiSkin =~ s/\n//g;
$MobiHRcolor =$CONF[19];
$MobiHRcolor =~ s/\r//g;$MobiHRcolor =~ s/\n//g;
$hdMobiTitle =$CONF[21];
$hdMobiTitle =~ s/\r//g;$hdMobiTitle =~ s/\n//g;

if ($MobiToHome eq '') { $MobiToHome='[HOME]'; }
if ($MobiSkin eq '') { $MobiSkin='/skin/mobi.html'; }
if ($MobiHRcolor eq '') { $MobiHRcolor=''; } else { $MobiHRcolor=' color="'.$MobiHRcolor.'"'; }
if ($hdMobiTitle eq '') { $hdMobiTitle=$MobiTitle; }

##==============メインアクション==============

&html_head;
&html_list;
&html_foot;
exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

#スキンページ読込
&page_read;

print "Content-type: text/html\n\n";
$phi=0;
foreach (@PHEAD) {
	$PHEAD[$phi]=~ s/<\/title>/ $hdMobiTitle<\/title>/g;
	if ($mboutCode eq 'sjis') { Encode::from_to($PHEAD[$phi], 'utf8', 'shiftjis'); }
	print $PHEAD[$phi];
	$phi++;
}
if ($MobiTitle ne '') {
	$htHead = <<"htHead";
<font color="$MobiColor">$MobiTitle</font>
<hr$MobiHRcolor>
htHead
	if ($mboutCode eq 'sjis') { Encode::from_to($htHead, 'utf8', 'shiftjis'); }
	print $htHead;
}

}
##=======================================================================================
sub html_foot {

if ($MobiToHome ne 'none') { $TagHome='<hr'.$MobiHRcolor.'><a href="../mobi/">'.$MobiToHome.'</a>'; }

$htFoot = <<"htFoot";
$TagHome
htFoot
if ($mboutCode eq 'sjis') { Encode::from_to($htFoot, 'utf8', 'shiftjis'); }
print $htFoot;

#スキンページ読込
&page_read;
$pfi=0;
foreach (@PFOOT) {
	if ($mboutCode eq 'sjis') { Encode::from_to($PFOOT[$pfi], 'utf8', 'shiftjis'); }
	print $PFOOT[$pfi];
	$pfi++;
}

}
##=======================================================================================
sub html_list {

&data_read;

$dataLot=@DATA;
$i=0;
for (1..$dataLot) {
	if ($mboutCode eq 'sjis') { Encode::from_to($DATA[$i], 'utf8', 'shiftjis'); }
	print $DATA[$i];
	$i++;
}

}
##=======================================================================================
sub data_read {
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($datafile);
		if ($contCC eq 'shiftjis') {
			foreach (@DATA) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('DBファイルの読込に失敗しました。'); }
}
##=======================================================================================
sub page_read {
	$rMobiSkin='..'.$MobiSkin;
	if (open(PAGEREAD,"$rMobiSkin")) {
		@PAGE = <PAGEREAD>;
		close(PAGEREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($rMobiSkin);
		if ($contCC eq 'shiftjis') {
			foreach (@PAGE) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else {
		$alMobiSkin=$rMobiSkin; $alMobiSkin=~ s/\.\.//i;
		$PAGE[0] ='<html>'."\n";
		$PAGE[1] ='<head><meta http-equiv="Content-Type" content="text/html;charset='.$mboutCode.'"></head>'."\n";
		$PAGE[2] ='<body><font color="red">[設定]にて指定したスキンファイル ['.$alMobiSkin.'] が存在しません</font><br>'."\n";
		$PAGE[3] ='<font color="red">[設定]にて正しいスキンファイルを指定するか、[スキン編集]にて作成する必要があります</font>'."\n";
		$PAGE[4] ='<!-- MainZone -->'."\n";
		$PAGE[5] ='</body></html>'."\n";
	}
	$pageflag = 0;
	@PHEAD = (); @PFOOT = (); $pi = 0;
	foreach (@PAGE) {
		if ($PAGE[$pi] =~ /MainZone/i) { $pageflag = 1; }
		if ($pageflag==0) { push(@PHEAD,$PAGE[$pi]); }
		if ($pageflag==1) { push(@PFOOT,$PAGE[$pi]); }
		$pi++;
	}
}
##=======================================================================================
sub errorout {

$error = $_[0];

##★エラーメッセージの変更はここを訂正
$errHTML = <<"ERRORMESS";
<font color="#ff0000">ERROR</font><br>
$error
ERRORMESS

if ($mboutCode eq 'sjis') { Encode::from_to($errHTML, 'utf8', 'shiftjis'); }
print $errHTML;
&html_foot;
exit;

}
##=======================================================================================
