/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.rfc2898;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.y3n20u.rfc2898.PseudorandomFunction;

public class PrfHmacSha1
implements PseudorandomFunction {
    public static final int OUTPUT_LENGTH = 20;
    private static final String MAC_ALGORITHM = "HmacSHA1";
    private static final String MESSAGE_ALGORITHM_NOT_SUPPORTED = MessageFormat.format("Algorithm not supported in this environment: {0}", "HmacSHA1");

    @Override
    public int getLengthOfOutput() {
        return 20;
    }

    @Override
    public byte[] getPseudorandomBytes(byte[] byArray, byte[] byArray2) {
        Mac mac;
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, MAC_ALGORITHM);
        try {
            mac = Mac.getInstance(MAC_ALGORITHM);
            mac.init(secretKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(MESSAGE_ALGORITHM_NOT_SUPPORTED, noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        return mac.doFinal(byArray2);
    }
}

