#! /usr/local/bin/perl -w

require 5.005;
use strict;
use LWP::Simple;
use Getopt::Long;

my $SCRIPT	= 'search.pl';
my $VERSION	= '0.01.06';

MAIN:{
	# output autoflush
	$| = 1;

	# default settings
	my $once = 50;
	my $max  = 3;

	# command line options
	my ($version, $help, $debug, $quiet, $verbose, $target, $source);
	Getopt::Long::Configure ('bundling');
	GetOptions (
		'V|version'		=> \$version,
		'h|help'		=> \$help,

		'd|debug'		=> \$debug,
		'q|quiet'		=> \$quiet,
		'v|verbose'		=> \$verbose,

		'o|once=i'		=> \$once,
		'm|max=i'		=> \$max,
		's|source=s'	=> \$source,

		'<>'			=> \&parse_option);

	sub parse_option {
		$target = $_[0];
		$target =~ s/[^\/\\]+$//;
	}

	if ($version) { disp_version() }
	elsif ($help) { disp_help() }
	elsif (!$target) { disp_init_error('missing target URL') }

	# mode setting
	if ($quiet) { $debug = 0; $verbose = 0 }
	elsif ($debug) { $quiet = 0; $verbose = 0 }
	elsif ($verbose) { $debug = 0; $quiet = 0 }

	my $path = $0;
	$path =~ s/[^\/\\]+$//;

	print time_stamp()."Making directory";
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime;
	my $out = sprintf("search%02d%02d%02d%02d", $mon + 1, $mday, $hour, $min);
	print " $out...";
	mkdir $path.$out, 0777;
	print " done.\n";

	my @proxy;
	my $content;
	if ($source) {
		print time_stamp()."Extracting proxies from a local file...";
		open FH, "$source" or disp_error("Can't open: $source");
		while (my $line = <FH>) {
			if ($line =~ /([\w\.\-]+:[\d]+)/) {
				push @proxy, $1;
			}
		}
		close FH;
		print " done.\n";
	} else {
		my $url = 'http://www.cybersyndrome.net/';
		print time_stamp()."Getting $url...";
		$content = get($url);
		if (!$content) { print "\n"; disp_error("No content: $url") }
		my @urls;
		if ($content =~ m{<a href="([\w\.\-]+)">Anonymous \(A\)</a>}) { push @urls, $1 }
		if ($content =~ m{<a href="([\w\.\-]+)">Anonymous \(B\)</a>}) { push @urls, $1 }
		if ($content =~ m{<a href="([\w\.\-]+)">Anonymous \(C\)</a>}) { push @urls, $1 }
		print " done.\n";

		print time_stamp()."Extracting proxies from HTML files...";
		$content = '';
		foreach my $path (@urls) { $content .= get($url.$path) }
		if (!$content) { print "\n"; disp_error("No content: @urls") }
		@proxy = ($content =~ />([\w\.\-]+:[\d]+)</g);
		print " done.\n";
	}

	print time_stamp()."Crypted strings\n";
	print "                => $target\n";
	print "  Connection:   ./success(may be forged) x/fail */error ?/check miss\n";
	print "  BBS error:    2/twice l/long m/many lines w/unwritable t/time S/Samba\n";
	print "  Proxy error:  o/open b/blacklist s/strange r/referer c/cookie e/etc\n";

	my $last =  0;
	my $found = 0;
	for (my $j = 0; $last == 0; $j++) {
		my ($start, $end) = ($j*$once, ($j+1)*$once-1);
		if ($end > $#proxy) { $end = $#proxy; $last = 1 }
		print time_stamp()."Remaining ".($#proxy - $start + 1)." proxies.\n";
		print time_stamp()."Starting ".($end - $start + 1)." age2ch.pl processes...\n";
		my $proc = 0;
		for(my $i = $start; $i <= $end; $i++) {
			system 1, 'perl "'.$path.'age2ch.pl" -p'.$proxy[$i].' -n0 -msage -b'.
				substr(crypt($proxy[$i], ('aa'..'zz','aA'..'zZ','Aa'..'Zz','AA'..'ZZ')[$i]), 2).
				" -e0 -P -o$out $target";
			$proc++;
			if ($proc >= $max) { wait; $proc-- }
		}
		for(;;){
			if ($proc > 0) { wait; $proc-- }
			else { last }
		}
		print "\n";
		print time_stamp().($end - $start + 1)." messages sent.\n";

		print time_stamp()."Getting a target HTML file...";
		$content = '';
		$content = get($target.'l50');
		if (!$content) { print "\n"; disp_error("No content: $target") }
		print " done.\n";

		print time_stamp()."Extracting crypted strings from HTML files...";
		my @crypted = ($content =~ /<dd>([0-9a-zA-Z\/\.]{11})<br><br>/g);
		print " done.\n";

		print time_stamp()."Comparing crypted strings with proxy names...";
		for(my $i = $start; $i <= $end; $i++) {
			foreach my $crypted (@crypted) {
				if ($crypted eq substr(crypt($proxy[$i], ('aa'..'zz','aA'..'zZ','Aa'..'Zz','AA'..'ZZ')[$i]), 2)) {
					open PXY, ">>$path$out/okproxy.txt";
					print PXY "$proxy[$i]\n";
					close PXY;
					print "\n  $proxy[$i] is postable.";
					$found++;
				}
			}
		}
		print " done.\n";
	}

	print time_stamp().($#proxy + 1)." messages sent.\n";
	if ($found == 1) { print "  $found postable proxy was found.\n" }
	elsif ($found > 1) { print "  $found postable proxies were found.\n" }
	print time_stamp()."All done.\n";

	exit;
}

# display help
sub disp_help {
	print <<EOF;
$SCRIPT $VERSION, a non-interactive proxy checker for 2ch.
Usage: $SCRIPT [OPTION]... [URL]

Mandatory arguments to long options are mandatory for short options too.

Startup:
  -V,  --version   display the version of $SCRIPT and exit.
  -h,  --help      print this help.

Logging and input file:
  -d,  --debug         print debug output.
  -q,  --quiet         quiet (no output).
  -v,  --verbose       be verbose (this is the default).
  -s,  --source=FILE   extract a proxy list from FILE.

Post:
  -o,  --once=NUMBER   post NUMBER times at once.
  -m,  --max=NUMBER    make NUMBER processes.

Mail bug reports and suggestions to <age2ch\@users.sourceforge.jp>.
EOF

	exit;
}

# display version
sub disp_version {
	print <<EOF;
$SCRIPT $VERSION

Copyright (C) 2002-2003 age2ch
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

Originally written by age2ch <age2ch\@users.sourceforge.jp>.
EOF

	exit;
}

# display error
sub disp_error {
	my ($message) = @_;

	if ($message) {
		print time_stamp();
		print "$message\n";
	} else {
		print "\n";
	}

	exit;
}

# display initial error and exit
sub disp_init_error {
	my ($message) = @_;

	print <<EOF;
$SCRIPT: $message
Usage: $SCRIPT [OPTION]... [URL]

Try `$SCRIPT --help' for more options.
EOF

	exit;
}

# time stamp
sub time_stamp { sprintf("--%02d:%02d:%02d--	", reverse((localtime)[0..2])) }
