/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.om.registry;

import java.util.Iterator;

/**
    Represents a media-type registry.

    @author <a href="mailto:raphael@apache.org">Rapha謖 Luta</a>
    @version $Id: MediaTypeRegistry.java,v 1.7 2004/02/23 03:11:39 jford Exp $
*/

public interface MediaTypeRegistry extends Registry
{

    /*
     * Find media-types in this registry that match the CapabilityMap requirements
     *
     * @param category The category and optional subcategories.
     * @return Iterator The result as an iterator.
     */
    public Iterator findForCapability(org.apache.jetspeed.capability.CapabilityMap cm);

}


