#include "any_attributes.h"

using namespace aka2;

bool any_attributes_op::equals(const void *lhs, const void *rhs) const {
  const wc_attributes& lattrs = *static_cast<const wc_attributes*>(lhs);
  const wc_attributes& rattrs = *static_cast<const wc_attributes*>(rhs);

  if (lattrs.size() != rattrs.size())
    return false;
  
  wc_attributes::const_iterator lit = lattrs.begin();
  wc_attributes::const_iterator rit = rattrs.begin();

  while ((lattrs.end() != lit) && (rattrs.end() != rit)) {
    bool res = (lit->tagname_ == rit->tagname_) &&
      (lit->value_ == rit->value_);
    if (!res)
      return false;
    ++lit;
    ++rit;
  }
  assert((lattrs.end() == lit) && (rattrs.end() == rit));
  return true;
}

void any_attributes_op::copy(void *dest, const void *src) const {

  wc_attributes& destattrs = *static_cast<wc_attributes*>(dest);
  const wc_attributes& srcattrs = *static_cast<const wc_attributes*>(src);

  destattrs.clear(); // !!!!!!!!!!!

  for (wc_attributes::const_iterator it = srcattrs.begin();
       it != srcattrs.end(); ++it) {
    destattrs.push_back(*it);
  }
}

any_attributes_op any_attributes_op::dispatcher_;
qname any_attributes_op::typename_;

