/* -*- c++ -*- */
#ifndef AKAXISO_CHOICE_MOC_H__
#define AKAXISO_CHOICE_MOC_H__

namespace aka2 {

  template<class C, class L>
  struct sequential_choice_moc {
    typedef TYPENAME C::value_type value_type;
    sequential_choice_moc(C &container) : c_(container) {}
    TYPENAME C::iterator begin() { return c_.begin(); }
    TYPENAME C::iterator end() { return c_.end(); }
    TYPENAME C::const_iterator begin() const { return c_.begin(); }
    TYPENAME C::const_iterator end() const { return c_.end(); }
    C& c_;

    template<class I>
    void push_back(const std::string &tagname, const I &v) { 
      const itemtypes::value_type *vt = L::find_itemtype(tagname);
      if (vt == 0)
	throw internal_error();
      c_.push_back(item(vt->first, new I(v), 
			vt->second.get_op())); 
    }

    template<class R> 
    int find_elements(const std::string &tagname, R &r) const {
      int count = 0;
      
      const itemtypes::value_type *itype = L::find_itemtype(tagname);
      if (itype == 0)
        throw internal_error();
      
      for (TYPENAME C::const_iterator it = c_.begin(); it != c_.end(); ++it) {
	if (it->get_name() == qname(tagname)) {
          r.push_back(item_cast<TYPENAME R::value_type>(*it));
	  ++count;
	}
      }
      return count;
    }
  };
}

#endif
