#include "closure_handler.h"


using namespace aka2;


closure_handler::closure_handler(const qname &tagname, sequence_handler *seq, 
				 int depth)
  : handler(*seq, depth, tagname), seq_(seq), inner_(0), error_(false) {}


parse_result closure_handler::query_element(const qname &tagname, const attribute_values &attrs, 
					    const global_attributes &gattrs) {
  inner_ = new sequence_handler(tagname, seq_, depth_);
  context_.push(inner_);
  return inner_->query_element(tagname, attrs, gattrs);
}


parse_result closure_handler::find_particle(const qname &tagname, const attribute_values &attrs, 
					    const global_attributes &gattrs) {
  assert(!"Must not be called.");
  return error;
}


parse_result closure_handler::end_element(const qname &tagname){
  // Tag name is the same as one for enclose.
  // it_(point to member) should be disclose. 
  if ((tagname_ == tagname) && (seq_->it_->get_schematype() == disclose_id))
    return ok;
  return error;
}

bool closure_handler::parse_entity(const std::string &entity, const global_attributes &gattrs) {
  return true;
}


// Mainly used for choices.
memberpair closure_handler::get_element(){
  return seq_->it_->get_member(seq_->seq_);
}

void closure_handler::receive_child(const memberpair &mpair){
  seq_->it_ = inner_->it_;
}

bool closure_handler::can_skip() {
  // Closure always appears.  Never skip. 
  return false;
}

