#!/bin/bash

unset XERCESCROOT

dos2unix configure
dos2unix configure.in
dos2unix config/mkinstalldirs
dos2unix config/missing
dos2unix config/config.sub
dos2unix config/config.guess

chmod +x configure config/install-sh config/missing config/mkinstalldirs config/config.guess
chmod +x config/*

SCRIPTS=`find | egrep '\.sh$'`
for SCRIPT in $SCRIPTS
  do
  dos2unix $SCRIPT
  chmod +x $SCRIPT
done

MAKEFILES=`find | egrep 'Makefile[\.in|\.am]*$'`
for MAKEFILE in $MAKEFILES
  do
  dos2unix $MAKEFILE
  chmod a-x $MAKEFILE
done

find | egrep '\.cpp$|\.h$' | xargs chmod a-x

#Clean up VC6-creating dirs in Projects.
cd Projects/VC6
DIRS=`find`
for DIR in $DIRS;
do
  if [ -d $DIR ]
      then
      rm -rf $DIR
  fi
done
cd ../..

find | grep ~$ | xargs rm -f
find | egrep '/xiso\.h$|/xiso\.cpp$|/element\.h$' | xargs rm -f

./configure
cp akaxiso/config.h config.h_
make maintainer-clean
rm -f yggdrasil/*_
rm -rf autom4te.cache config.log
mv config.h_ akaxiso/config.h
cd yggdrasil; unzip -o ygg.zip; cd ..

