/* -*- c++ -*- */
#include "akaxiso.h"
#include "formatter.h"
#include "classes/namespaces.h"
#include "classes/type_registry.h"
#include "classes/closure.h"
#include "classes/any.h"

#ifdef USE_XERCESC
#include <xercesc/util/PlatformUtils.hpp> /* {Xerces-C++} */
#endif

namespace aka2 {

namespace {
  namespace_map     namespaces_;
  global_attributes gattrs_;
  document_factory  doc_factory_;
  type_registry     type_registry_;
  int init_count_ = 0;
}

void aka2::use_xerces_transcoder(bool use) {
  formatter::use_xerces_transcoder_ = use;
}

global_attributes &aka2::system_global_attributes() {
  return gattrs_;
}

namespace_map & aka2::namespaces() {
  return namespaces_;
}

document_factory& aka2::system_document_factory() {
  return doc_factory_;
} 

type_registry &aka2::system_type_registry() {
  return type_registry_;
}


void aka2::initialize() {
  if (++init_count_ != 1)
    return;

  babel::init_babel();

#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Initialize();
  use_xerces_transcoder(true);
#endif

  namespaces_   .initialize();
  gattrs_       .initialize();
  doc_factory_  .clear();
  type_registry_.initialize();
  enclose_op    ::initialize();
  disclose_op   ::initialize();
  any_op        ::initialize();
}

void aka2::uninitialize() {
  if (init_count_ == 0 || --init_count_ != 0)
    return;

  any_op       ::uninitialize();
  namespaces_   .uninitialize();
  gattrs_       .uninitialize();
  doc_factory_  .clear();
  type_registry_.uninitialize();
  
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Terminate();
#endif
}

} // namespace aka2
