#include "any.h"
#include "type_registry.h"

using namespace aka2;

any_op any_op::dispatcher_;
any_member any_op::attributes_;
any_array_op any_array_op::dispatcher_;

qname any_op::typename_; 
qname any_array_op::typename_; 

bool any_op::equals(const void *lhs, const void *rhs) const {
  const any &lany = *static_cast<const any*>(lhs);
  const any &rany = *static_cast<const any*>(rhs);
  bool res = (lany.name_ == rany.name_) && (lany.value_ == rany.value_);
  if (!res)
    return false;
  return any_array_op::dispatcher_.equals(&lany.children_, &rany.children_);
}

void any_op::initialize() {
  if (!system_type_registry().add(any_op()))
    return;
  //typename_ = qname("xs:any"); !!!!!!!!!!!

  member_getter *getter = create_ptr_getter(static_cast<const any*>(0), &any::attributes_);
  attributes_ = any_member(getter, any_attributes_op::dispatcher_);

}

void any_op::uninitialize() {
  attributes_ = any_member();
}



bool any_array_op::equals(const void *lhs, const void *rhs) const {
  const any_array& larray = *static_cast<const any_array*>(lhs);
  const any_array& rarray = *static_cast<const any_array*>(rhs);

  if (larray.size() != rarray.size())
    return false;
  
  any_array::const_iterator lit = larray.begin();
  any_array::const_iterator rit = rarray.begin();

  while ((larray.end() != lit) && (rarray.end() != rit)) {
    bool res = any_op::dispatcher_.equals(&*lit, &*rit);
    if (!res)
      return false;
  }
  assert((larray.end() == lit) && (rarray.end() == rit));
  return true;
}


void any_array_op::initialize() {
  if (!system_type_registry().add(any_array_op()))
    return;
  //typename_ = qname("xs:any"); !!!!!!!!!!!
}

void any_array_op::uninitialize() {
}
