/* -*- c++ -*- */
#ifndef AKAXISO_SEQUENCE_H__
#define AKAXISO_SEQUENCE_H__

/** @file akaxiso/classes/sequence.h */

#include <akaxiso/classes/simpletype.h>
#include <akaxiso/classes/attribute.h>
#include <akaxiso/classes/memberdef.h>
#include <akaxiso/classes/closure.h>

namespace aka2 {

  template<class L>
  class sequence_op_dispatcher : public sequence_op {
  public:
    virtual schematype_id get_schematype() const { return sequence_id; }
    virtual const qname& get_typename() const { return L::typename_; }
    /** creatable */
    virtual bool equals(const void *lhs, const void *rhs) const {
      return L::equals(lhs, rhs);
    }

    virtual void construct(void *e) const {  L::construct(e); }
    virtual void copy_construct(void *e, const void *src) const { L::copy_construct(e, src); }
    virtual void destruct(void *e) const { L::destruct(e); }
    virtual size_t class_size() const { return L::class_size(); }

    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const {
      return &L::attribute_types_;
    }
    /** sequence_info getter. */
    virtual const member_types &get_member_types() const {
      return L::member_types_;
    }
    virtual const any_member *get_anyattr_type() const { return L::get_anyattr_type(); }
  };


  template<class L, class T>
  struct sequence_statics {
    static member_types member_types_;
    static qname typename_;
    static sequence_op_dispatcher<L> dispatcher_;
  };

  template<class L, class T>
  member_types sequence_statics<L, T>::member_types_;

  template<class L, class T>
  qname sequence_statics<L, T>::typename_;

  template<class L, class T>
  sequence_op_dispatcher<L> sequence_statics<L, T>::dispatcher_;


  template<class T, class L=xiso::leaf<T> >
  class sequence : public attributes<L, T>,
		   public sequence_statics<L, T>,
		   public memberdef<L, T> {
  public:
    typedef T value_type;

    virtual ~sequence(){}

    static member_type* register_membertype(const member_type &mtype) {
      member_types_.push_back(mtype);
      return &member_types_.back();
    }

    static void initialize() {
      if (!system_type_registry().add(L()))
      	return;
      member_types_.clear();
      attribute_types_.clear();
      L l; l.model();
    }

    static void uninitialize() {
      member_types_.clear();
      attribute_types_.clear();
    }


    static void construct(void *e) {
      new (e) T();
      sequence_construct(e, dispatcher_);
    }
    static void copy_construct(void *e, const void *src) {
      new (e) T(*static_cast<const T*>(src));
    }
    static size_t class_size() { return sizeof(T); }
    static void destruct(void *elm) { static_cast<T*>(elm)->~T(); }


    static bool equals(const void *lhs, const void *rhs) {
      return sequence_equals(lhs, rhs, dispatcher_);
    }

    static element_op* get_attribute_dispatcher() { return &dispatcher_; }
    static default_op* create_default_op() { return 0; }

    static void xmltype(const std::string &name) {
      typeinfo_.set_name(qname(name));
    }

    static void enclose(const std::string &tagname) {
      member_type mtype =
      	member_type(new null_getter(), enclose_op::op_);
      mtype.set_name(tagname);
      L::register_membertype(mtype);
    }

    static void disclose(const std::string &tagname) {
      member_type mtype =
      	member_type(new null_getter(), disclose_op::op_);
      mtype.set_name(tagname);
      L::register_membertype(mtype);
    }
    static bool acceptable(schematype_id id) {
      return true;
    }

//     template<class P>
//     void any(aka2::any (P::* m)) {
//       member_getter *mgetter = 
// 	create_ptr_getter(reinterpret_cast<T*>(0), m);	  
//       aka2::member_type mtype(mgetter, aka2::any_op::dispatcher_);
//       mtype.set_name("&any");// Must not be named element.
//       L::register_membertype(mtype);
//     }

//     template<class P>
//     void any(aka2::any_array P::* m, int minOccurs, int maxOccurs) {
//       member_getter *mgetter = 
// 	create_ptr_getter(reinterpret_cast<T*>(0), m);	  
//       aka2::member_type mtype = aka2::member_type(mgetter, aka2::any_array_op::dispatcher_);
//       mtype.set_name("&any[]");
//       mtype.set_occurrence(occurrence(minOccurs, maxOccurs));
//       L::register_membertype(mtype);
//     }
  };

} // namespace aka2

#endif /* AKAXISO_SEQUENCE_H__ */
