//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
//CUPPA:namespace=-

#include <akaxiso/akaxiso.h>
#include <akaxiso/content_model.h>
#include <iostream>

namespace {

  struct chars {
    std::string encoding_;
    std::string text_;
  };

  struct chars_leaf : public aka2::sequence<chars, chars_leaf> {
    void model() {
      member("encoding", &chars::encoding_);
      member("text", &chars::text_);
    }
  };
}

class encodingTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(encodingTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_sjis);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...

public:

  virtual void setUp() { 
    aka2::initialize();
    aka2::doctype("encoding", chars_leaf());
  }
  virtual void tearDown() { 
    aka2::uninitialize();
  }

//CUPPA:decl=+
  void test_sjis() {
    aka2::use_xerces_transcoder(false);
    aka2::yggxml_parser parser;

    try {
      aka2::document doc = parser.parse_file("sjis_test.xml");
      

      aka2::xml_serializer ser("shift_jis");
      std::ostringstream ostm;
      ser.serialize(doc, ostm);
      // ser.serialize(doc, "encoding", ostm);  Must be error. !!!!!!!!
    }
    catch ( const std::exception &e ) {
      std::cerr << e.what() << std::endl;
      throw;
    }
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(encodingTest);
