#!/bin/bash
SJISSOURCES="apple.csv babel.cpp babel.h cp932.csv euc-uni.csv scoremap.csv sjis-euc.csv utc.csv ygg.cpp ygg.h ygg_test.cpp c932-uni.dat euc-scr.dat euc-sjis.dat euc2-uni.dat euc3-uni.dat sjis-euc.dat sjis-scr.dat uni-c932.dat uni-euc.dat uni-scr.dat uni-utc.dat utc-uni.dat"


SRCDIR=`dirname $0`
if [ -z $SRCDIR ];
then
    SRCDIR=`pwd`
fi

clean()
{
    rm -f $SRCDIR/*.dat
    for FILE in ${SJISSOURCES} test.sox test.xml csv.sox;
    do
      rm -f $SRCDIR/$FILE
    done
    rm -f $SRCDIR/*.sjis
}


extract()
{
    clean
    unzip -d$SRCDIR $SRCDIR/ygg.zip
    unzip -d$SRCDIR $SRCDIR/babel.zip
}

convert()
{
    for FILE in $SJISSOURCES
      do
      echo converting $SRCDIR/$FILE to euc-jp.
      SJISFILE=$SRCDIR/${FILE}.sjis
      if [ ! -f $SJISFILE ]
	  then
	  EUCFILE=$SRCDIR/${FILE}
	  mv $EUCFILE $SJISFILE
	  nkf --unix $SJISFILE > $EUCFILE
      fi
    done
}    


usage()
{
    echo sjisutil.sh
}

OPTION=$1
if [ -z $OPTION ]
then
    usage
    exit 1
fi

case $OPTION in
    "convert")
	convert
    ;;
    "clean")
	clean
    ;;
    "extract")
	extract
    ;;
    *)
	usage
    ;;
esac

exit 0
