/* -*- c++ -*- */
#ifndef AKAXISO_YGG_PARSER_H__
#define AKAXISO_YGG_PARSER_H__

#include <akaxiso/parser.h>

namespace aka2 {

  class ygg_parser : public parser {
  public:
    ~ygg_parser() {}

    virtual document parse(std::istream &istm);
    virtual document parse(const char *document);
    virtual document parse(const std::string &document);
    virtual document parse_stdin();
    virtual document parse_file(const std::string &filename);

  private:
    virtual document parse_internal(std::istream &stm, const std::string &source_name) = 0;
  };


  class yggsox_parser : public ygg_parser {
  public:
  protected:
    virtual document parse_internal(std::istream &stm, const std::string &source_name);
  };


  class yggxml_parser : public ygg_parser {
  public:
  protected:
    virtual document parse_internal(std::istream &stm, const std::string &source_name);
  };

} // namespace aka2

#endif /* AKAXISO_YGG_PARSER_H__ */
