/* -*- c++ -*- */
#ifndef EXCEPTION_H__
#define EXCEPTION_H__

#include <sstream>

class fatal_error : public std::exception {
public:
  fatal_error(){}
  fatal_error(const std::string &msg, const char *file, const unsigned long line) {
    set_message(msg, file, line);
  }
  virtual ~fatal_error() throw() {}
  virtual const char *what() const throw() { return msg_.c_str(); } 
protected:
  void set_message(const std::string &msg, const char *file, const unsigned long line) {
    std::ostringstream ostm;
    ostm << msg << '(' << file << ':' << line << ')';
    msg_ = ostm.rdbuf()->str();
  }
private:
  std::string msg_;
};

class not_supported : public fatal_error {
public:
  not_supported(const char *file, const unsigned long line) {
    set_message("Not supported.", __FILE__, __LINE__);
  }
};

class not_implemented : public fatal_error {
public:
  not_implemented(const char *file, const unsigned long line) {
    set_message("Not implemented.", __FILE__, __LINE__);
  }
};

class type_not_found : public fatal_error {
public:
  type_not_found(const aka::qname &type, const char *file, const unsigned long line) {
    std::string msg = std::string("type \"") + type.qualified()
      + "\" not found.";
    set_message(msg, file, line);
  }
};

#endif
