/* -*- c++ -*- */
#include <akaxiso/content_model.h>
#include <akaxiso/akaxiso.h>

namespace ltg {

  struct file {
    std::string tsDir_;
    std::string folder_;
    std::string fileName_;
    std::string role_;
    bool validity_;
    
    std::string get_filepath() const {
      return tsDir_ + "/" + folder_ + "/" + fileName_;
    }
    std::string get_dirpath() const {
      return tsDir_ + "/" + folder_ + "/";
    }
  };

  typedef std::vector<file> files;

  struct test {
    std::string id_;
    std::string origin_;
    std::string description_;
    files files_;
  };

  typedef std::list<test> tests;

  struct root {
    tests tests_;
  };

  void instantiate_xiso();
}

namespace xiso {
  
  template<>
  struct leaf<ltg::file> : aka::sequence<ltg::file> {
    void model() {
      attribute("tsDir", &ltg::file::tsDir_).required(true);
      attribute("folder", &ltg::file::folder_).required(true);
      attribute("fileName", &ltg::file::fileName_).required(true);
      attribute("role", &ltg::file::role_).required(true);
      attribute("validity", &ltg::file::validity_).required(true);
    }
  };

  template<>
  struct leaf<ltg::files> : aka::sequential_array<ltg::files> {
  };

  template<>
  struct leaf<ltg::test> : aka::sequence<ltg::test> {
    void model() {
      attribute("id", &ltg::test::id_);
      attribute("origin", &ltg::test::origin_);
      member("description", &ltg::test::description_);
      enclose("files");
      member("file", &ltg::test::files_, 0, aka::unbounded);
      disclose("files");
    }
  };

  template<>
  struct leaf<ltg::tests> : aka::sequential_array<ltg::tests> {
  };

  template<>
  struct leaf<ltg::root> : aka::sequence<ltg::root> {
    void model() {
      member("test", &ltg::root::tests_, 0, aka::unbounded);
    }
  };
}

inline void ltg::instantiate_xiso() {
  aka::doctype("tests", xiso::leaf<ltg::root>());
}
