#!/bin/bash

dos2unix configure
dos2unix configure.in
dos2unix config/mkinstalldirs
dos2unix config/missing
dos2unix config/config.sub
dos2unix config/config.guess
dos2unix ToDo

SCRIPTS=`find | egrep '\.sh$'`
for SCRIPT in $SCRIPTS
  do
  dos2unix $SCRIPT
  chmod +x $SCRIPT
done

MAKEFILES=`find | egrep 'Makefile[\.in|\.am]*$'`
for MAKEFILE in $MAKEFILES
  do
  dos2unix $MAKEFILE
  chmod a-x $MAKEFILE
done

SOURCES=`find | egrep '\.cpp$|\.h$'`
for SOURCE in $SOURCES
  do
  dos2unix $SOURCE
  chmod a-x $SOURCE
done

find | grep ~$ | xargs rm -f


