#include <iostream>
#include <string>
#include <cppunit/ui/text/TestRunner.h>
#include <cppunit/XmlOutputter.h>
#include <cppunit/TextOutputter.h>
#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>

int main(int argc, char* argv[]) {
  int format = 0;
  int target = 0;
  std::string xsl;
  std::string ns;
  for ( int i = 1; i < argc; ++i ) {
    std::string arg(argv[i]);
    if ( arg == "--text"      ) format = 0;
    if ( arg == "--xml"       ) format = 1;
    if ( arg == "--compiler"  ) format = 2;
    if ( arg == "--cerr"      ) target = 1;
    if ( arg == "--xsl"       ) xsl = argv[++i];
    if ( arg == "--namespace" ) ns  = argv[++i];
  }
  CppUnit::TextUi::TestRunner runner;
  if ( ns.empty() )
    runner.addTest(CppUnit::TestFactoryRegistry::getRegistry().makeTest());
  else
    runner.addTest(CppUnit::TestFactoryRegistry::getRegistry(ns).makeTest());
  CppUnit::Outputter* outputter = 0;
  std::ostream* stream = target ? &std::cerr : &std::cout;
  switch ( format ) {
  case 0 :
    outputter = new CppUnit::TextOutputter(&runner.result(),*stream);
    break;
  case 1 :
    outputter = new CppUnit::XmlOutputter(&runner.result(),*stream, "shift_jis");
    static_cast<CppUnit::XmlOutputter*>(outputter)->setStyleSheet(xsl);
    break;
  case 2 :
    outputter = new CppUnit::CompilerOutputter(&runner.result(),*stream);    break;
  }
  runner.setOutputter(outputter);

  int res = runner.run();

#ifdef _MSC_VER
  std::cout << "Press CR to quit.";
  char ch;
  std::cin.get(ch);
#endif

  
  return res ? 0 : 1;
}
