/* -*- c++ -*- */
#ifndef TUTORIAL7_H__
#define TUTORIAL7_H__

#include <akaxiso/content_model.h>

typedef std::list<aka::item> janken_choice;

struct janken_item {
  std::string explanation_;
};

struct goo : public janken_item { };

struct choki : public janken_item { };

struct pa : public janken_item { };

namespace xiso {

  template<>
  struct leaf<goo> : public aka::simplecontent<goo> {
    void model() {
      value(&goo::explanation_);
    }
  };

  template<>
  struct leaf<choki> : public aka::simplecontent<choki> {
    void model() {
      value(&choki::explanation_);
    }
  };

  template<>
  struct leaf<pa> : public aka::simplecontent<pa> {
    void model() {
      value(&pa::explanation_);
    }
  };

  template<>
  struct leaf<janken_choice> : public aka::sequential_choice<janken_choice> {
    void model() {
      occurrence(0, aka::unbounded);
      item("goo", leaf<goo>());
      item("choki", leaf<choki>());
      item("pa", leaf<pa>());
    }
  };
}

inline void instantiate_xiso() {
  aka::doctype("janken", xiso::leaf<janken_choice>());
}

#endif
