/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.makeblock;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class MeStepperMotor
extends TranslatorBlock {
    public MeStepperMotor(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        this.translator.addHeaderFile("Makeblock.h");
        this.translator.addHeaderFile("SoftwareSerial.h");
        this.translator.addHeaderFile("Servo.h");
        this.translator.addHeaderFile("Wire.h");
        TranslatorBlock portBlock = this.getRequiredTranslatorBlockAtSocket(0);
        String ret = "MeStepperMotor stepper" + portBlock.toCode() + "(PORT" + portBlock.toCode() + ");";
        this.translator.addDefinitionCommand(ret);
        TranslatorBlock speedBlock = this.getRequiredTranslatorBlockAtSocket(1);
        TranslatorBlock accelerationBlock = this.getRequiredTranslatorBlockAtSocket(2);
        this.translator.addSetupCommand("stepper" + portBlock.toCode() + ".begin(STP_SIXTEENTH," + speedBlock.toCode() + "," + accelerationBlock.toCode() + ");");
        TranslatorBlock moveToBlock = this.getRequiredTranslatorBlockAtSocket(3);
        ret = "stepper" + portBlock.toCode() + ".moveTo(" + moveToBlock.toCode() + ");\n";
        ret = ret + "int distance = stepper" + portBlock.toCode() + ".distanceToGo();\n";
        ret = ret + "if(distance==0){\n";
        String exec = "";
        for (TranslatorBlock execBlock = this.getTranslatorBlockAtSocket(4); execBlock != null; execBlock = execBlock.nextTranslatorBlock()) {
            exec = exec + "\t" + execBlock.toCode() + "\n";
        }
        ret = ret + exec + "\n}";
        return ret;
    }
}

