/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.panda;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;

public class PandaOutputPortBlock
extends TranslatorBlock {
    public int[][] pinTable = new int[][]{{0, 0}, {0, 1}, {3, 2}, {4, 10}, {5, 11}, {6, 12}, {7, 13}};

    public PandaOutputPortBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException {
        String g_name = this.getTranslator().getBlock(this.blockId).getGenusName();
        String port_str = g_name.substring(7);
        int port = Integer.parseInt(port_str);
        int pin = this.pinTable[port][1];
        int led_pin = this.pinTable[port][0];
        this.translator.addSetupCommand("pinMode(" + pin + ", OUTPUT);");
        this.translator.addSetupCommand("pinMode(" + led_pin + ", OUTPUT);");
        this.translator.addSetupCommand("digitalWrite(" + led_pin + ", HIGH);");
        return pin + "";
    }
}

