/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Page;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.SwingUtilities;

class BlockStackSorterUtil {
    private static final int BUFFER_BETWEEN_BLOCKS = 20;
    private static final Rectangle positioningBounds = new Rectangle(20, 20, 0, 0);
    private static final TreeSet<RenderableBlock> blocksToArrange = new TreeSet<RenderableBlock>(new Comparator<RenderableBlock>(){

        @Override
        public int compare(RenderableBlock rb1, RenderableBlock rb2) {
            if (rb1 == rb2) {
                return 0;
            }
            Point pt1 = rb1.getLocation();
            Point pt2 = SwingUtilities.convertPoint(rb2.getParentWidget().getJComponent(), rb2.getLocation(), rb1.getParentWidget().getJComponent());
            if (pt1.getY() < pt2.getY()) {
                return -1;
            }
            return 1;
        }
    });

    BlockStackSorterUtil() {
    }

    protected static void sortBlockStacks(Page page, Collection<RenderableBlock> topLevelBlocks) {
        blocksToArrange.clear();
        positioningBounds.setBounds(20, 20, 0, 20);
        blocksToArrange.addAll(topLevelBlocks);
        for (RenderableBlock block : blocksToArrange) {
            Rectangle bounds = block.getStackBounds();
            if (BlockStackSorterUtil.positioningBounds.height + bounds.height > page.getJComponent().getHeight()) {
                BlockStackSorterUtil.positioningBounds.x = BlockStackSorterUtil.positioningBounds.x + BlockStackSorterUtil.positioningBounds.width + 20;
                BlockStackSorterUtil.positioningBounds.width = 0;
                BlockStackSorterUtil.positioningBounds.height = 20;
            }
            block.setLocation(BlockStackSorterUtil.positioningBounds.x, BlockStackSorterUtil.positioningBounds.height);
            block.setUnzoomedX(block.calculateUnzoomedX(BlockStackSorterUtil.positioningBounds.x));
            block.setUnzoomedY(block.calculateUnzoomedY(BlockStackSorterUtil.positioningBounds.height));
            block.moveConnectedBlocks();
            BlockStackSorterUtil.positioningBounds.width = Math.max(BlockStackSorterUtil.positioningBounds.width, bounds.width);
            BlockStackSorterUtil.positioningBounds.height = BlockStackSorterUtil.positioningBounds.height + bounds.height + 20;
            if (BlockStackSorterUtil.positioningBounds.x + BlockStackSorterUtil.positioningBounds.width <= page.getJComponent().getWidth()) continue;
            page.addPixelWidth(BlockStackSorterUtil.positioningBounds.x + BlockStackSorterUtil.positioningBounds.width - page.getJComponent().getWidth());
        }
    }
}

