/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace.typeblocking;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.BlockCanvas;
import edu.mit.blocks.workspace.Page;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceListener;
import edu.mit.blocks.workspace.typeblocking.KeyInputMap;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

public class FocusTraversalManager
implements MouseListener,
KeyListener,
WorkspaceListener {
    private Point blockFocusPoint = null;
    private Point canvasFocusPoint = new Point(0, 0);
    private Long focusBlock = Block.NULL;
    private final Workspace workspace;

    public FocusTraversalManager(Workspace workspace) {
        this.workspace = workspace;
    }

    public Long getFocusBlockID() {
        if (this.invalidBlock(this.focusBlock)) {
            if (this.canvasFocusPoint == null) {
                throw new RuntimeException("Focus has not yet been set to block");
            }
            if (this.blockFocusPoint != null) {
                throw new RuntimeException("Focus should be set to block");
            }
        } else {
            if (this.canvasFocusPoint != null) {
                throw new RuntimeException("Focus has not yet been set to canvas");
            }
            if (this.blockFocusPoint == null) {
                throw new RuntimeException("Focus has not been removed from block");
            }
        }
        return this.focusBlock;
    }

    public Point getCanvasPoint() {
        if (!this.invalidBlock(this.focusBlock)) {
            throw new RuntimeException("May not request canvas's focus point if canvas does not have focus. Focus at: " + this.focusBlock);
        }
        if (this.blockFocusPoint != null) {
            throw new RuntimeException("May not request canvas's focus point if canvas does not have focus. Focus at: " + this.blockFocusPoint);
        }
        if (this.canvasFocusPoint == null) {
            throw new RuntimeException("May not request canvas's focus point if canvas does not have focus. Canvas focus is null.");
        }
        return this.canvasFocusPoint;
    }

    public Point getBlockPoint() {
        if (this.invalidBlock(this.focusBlock)) {
            throw new RuntimeException("May not request block's focus point if block does not have focus. Focus at: " + this.focusBlock);
        }
        if (this.blockFocusPoint == null) {
            throw new RuntimeException("May not request block's focus point if block does not have focus. Focus at: " + this.blockFocusPoint);
        }
        if (this.canvasFocusPoint != null) {
            throw new RuntimeException("Canvas focus is still valid. May not requestblock's focus point if block does not have focus.");
        }
        return this.blockFocusPoint;
    }

    public void setFocus(Block block) {
        if (block == null) {
            throw new RuntimeException("Invariant Violated:may not set focus to a null Block instance");
        }
        this.setFocus(block.getBlockID());
    }

    public void setFocus(Long blockID) {
        if (blockID == null || blockID == Block.NULL || blockID == -1L || this.workspace.getEnv().getBlock(blockID) == null) {
            throw new RuntimeException("Invariant Violated:may not set focus to a null Block instance");
        }
        if (!this.invalidBlock(this.focusBlock)) {
            this.getBlock(this.focusBlock).setFocus(false);
            this.workspace.getEnv().getRenderableBlock(this.focusBlock).repaintBlock();
        }
        this.getBlock(blockID).setFocus(true);
        this.workspace.getEnv().getRenderableBlock(blockID).requestFocus();
        this.workspace.getEnv().getRenderableBlock(blockID).repaintBlock();
        this.canvasFocusPoint = null;
        this.blockFocusPoint = new Point(0, 0);
        this.focusBlock = blockID;
    }

    public void setFocus(Point canvasPoint, Long blockID) {
        if (blockID == null || blockID == Block.NULL || blockID == -1L || this.workspace.getEnv().getBlock(blockID) == null) {
            if (!this.invalidBlock(this.focusBlock)) {
                this.getBlock(this.focusBlock).setFocus(false);
                this.workspace.getEnv().getRenderableBlock(this.focusBlock).repaintBlock();
            }
        } else {
            throw new RuntimeException("Invariant Violated:may not set new focus point if focus is on a block");
        }
        this.focusBlock = Block.NULL;
        this.canvasFocusPoint = canvasPoint;
        this.blockFocusPoint = null;
    }

    void setFocus(Point location) {
        throw new RuntimeException("The use of this method is FORBIDDEN");
    }

    public boolean focusNextBlock() {
        if (this.invalidBlock(this.focusBlock) || !this.workspace.getEnv().getRenderableBlock(this.focusBlock).isVisible()) {
            this.setFocus(this.canvasFocusPoint, Block.NULL);
            return false;
        }
        Block currentBlock = this.getBlock(this.focusBlock);
        for (BlockConnector socket : currentBlock.getSockets()) {
            if (socket == null || this.invalidBlock(socket.getBlockID())) continue;
            this.setFocus(socket.getBlockID());
            return true;
        }
        Long afterBlock = currentBlock.getAfterBlockID();
        if (!this.invalidBlock(afterBlock)) {
            this.setFocus(afterBlock);
            return true;
        }
        Block nextBlock = this.getNextNode(currentBlock);
        if (nextBlock == null) {
            throw new RuntimeException("Invariant Violated: return value of getNextNode() may not be null");
        }
        this.setFocus(nextBlock.getBlockID());
        return true;
    }

    public boolean focusPrevBlock() {
        if (this.invalidBlock(this.focusBlock) || !this.workspace.getEnv().getRenderableBlock(this.focusBlock).isVisible()) {
            this.setFocus(this.canvasFocusPoint, Block.NULL);
            return false;
        }
        Block currentBlock = this.getBlock(this.focusBlock);
        Block previousBlock = this.getPlugBlock(currentBlock);
        if (previousBlock == null) {
            previousBlock = this.getBeforeBlock(currentBlock);
        }
        if (previousBlock == null) {
            previousBlock = this.getBottomRightBlock(currentBlock);
        } else {
            Block beforeBlock = previousBlock;
            ArrayList<BlockConnector> connections = new ArrayList<BlockConnector>();
            for (BlockConnector socket : previousBlock.getSockets()) {
                connections.add(socket);
            }
            connections.add(previousBlock.getAfterConnector());
            for (BlockConnector connector : connections) {
                if (connector == null || connector.getBlockID() == Block.NULL || this.getBlock(connector.getBlockID()) == null) continue;
                if (connector.getBlockID().equals(currentBlock.getBlockID())) {
                    if (!beforeBlock.getBlockID().equals(previousBlock.getBlockID())) {
                        previousBlock = this.getBottomRightBlock(previousBlock);
                    }
                    this.setFocus(previousBlock.getBlockID());
                    return true;
                }
                previousBlock = this.getBlock(connector.getBlockID());
            }
            previousBlock = this.getBottomRightBlock(previousBlock);
        }
        this.setFocus(previousBlock.getBlockID());
        return true;
    }

    public boolean focusAfterBlock() {
        if (this.invalidBlock(this.focusBlock) || !this.workspace.getEnv().getRenderableBlock(this.focusBlock).isVisible()) {
            this.setFocus(this.canvasFocusPoint, Block.NULL);
            return false;
        }
        Block currentBlock = this.getBlock(this.focusBlock);
        while (currentBlock != null) {
            if (this.getAfterBlock(currentBlock) != null) {
                this.setFocus(this.getAfterBlock(currentBlock));
                return true;
            }
            if ((currentBlock = this.getPlugBlock(currentBlock)) != null) continue;
            this.setFocus(this.focusBlock);
            return true;
        }
        return true;
    }

    public boolean focusBeforeBlock() {
        if (this.invalidBlock(this.focusBlock) || !this.workspace.getEnv().getRenderableBlock(this.focusBlock).isVisible()) {
            this.setFocus(this.canvasFocusPoint, Block.NULL);
            return false;
        }
        Block currentBlock = this.getBlock(this.focusBlock);
        while (currentBlock != null) {
            if (this.getBeforeBlock(currentBlock) != null) {
                this.setFocus(this.getBeforeBlock(currentBlock));
                return true;
            }
            if ((currentBlock = this.getPlugBlock(currentBlock)) != null) continue;
            this.setFocus(this.focusBlock);
            return false;
        }
        return false;
    }

    private Block getNextNode(Block currentBlock) {
        if (this.invalidBlock(currentBlock)) {
            throw new RuntimeException("Invariant Violated: may not resurve over a null instance of currentBlock");
        }
        Block parentBlock = this.getBlock(currentBlock.getPlugBlockID());
        if (this.invalidBlock(parentBlock)) {
            parentBlock = this.getBlock(currentBlock.getBeforeBlockID());
        }
        if (this.invalidBlock(parentBlock)) {
            return currentBlock;
        }
        int i = parentBlock.getSocketIndex(parentBlock.getConnectorTo(currentBlock.getBlockID()));
        if (i != -1 && i >= 0) {
            for (BlockConnector parentSocket : parentBlock.getSockets()) {
                if (parentSocket == null || this.invalidBlock(parentSocket.getBlockID()) || parentBlock.getSocketIndex(parentSocket) <= i) continue;
                return this.getBlock(parentSocket.getBlockID());
            }
        }
        if (this.invalidBlock(parentBlock.getAfterBlockID())) {
            return this.getNextNode(parentBlock);
        }
        if (parentBlock.getAfterBlockID().equals(currentBlock.getBlockID())) {
            return this.getNextNode(parentBlock);
        }
        return this.getBlock(parentBlock.getAfterBlockID());
    }

    Long getTopOfStack(Long blockID) {
        if (blockID == null || blockID == Block.NULL || this.workspace.getEnv().getBlock(blockID) == null) {
            throw new RuntimeException("Invariant Violated: may notiterate for outermost block over a null instance of Block");
        }
        Block parentBlock = null;
        parentBlock = this.getBeforeBlock(blockID);
        if (parentBlock != null) {
            return this.getTopOfStack(parentBlock.getBlockID());
        }
        parentBlock = this.getPlugBlock(blockID);
        if (parentBlock != null) {
            return this.getTopOfStack(parentBlock.getBlockID());
        }
        if (parentBlock != null) {
            throw new RuntimeException("Invariant Violated: may not return a null instance of block as the outermost block");
        }
        return blockID;
    }

    private Block getBottomRightBlock(Block block) {
        if (block == null || block.getBlockID() == Block.NULL) {
            throw new RuntimeException("Invariant Violated: may notiterate for innermost block over a null instance of Block");
        }
        Block returnBlock = null;
        returnBlock = this.getAfterBlock(block);
        if (returnBlock != null) {
            return this.getBottomRightBlock(returnBlock);
        }
        for (BlockConnector socket : block.getSockets()) {
            Block socketBlock = this.getBlock(socket.getBlockID());
            if (socketBlock == null) continue;
            returnBlock = socketBlock;
        }
        if (returnBlock != null) {
            return this.getBottomRightBlock(returnBlock);
        }
        if (returnBlock != null) {
            throw new RuntimeException("Invariant Violated: may not return a null instance of block as the innermost block");
        }
        return block;
    }

    private boolean invalidBlock(Block block) {
        if (block == null) {
            return true;
        }
        if (block.getBlockID() == null) {
            return true;
        }
        return block.getBlockID() == Block.NULL;
    }

    private boolean invalidBlock(Long blockID) {
        if (blockID == null) {
            return true;
        }
        if (blockID == Block.NULL) {
            return true;
        }
        return this.getBlock(blockID) == null;
    }

    private Block getBlock(Long blockID) {
        return this.workspace.getEnv().getBlock(blockID);
    }

    private Block getBeforeBlock(Long blockID) {
        return this.getBeforeBlock(this.getBlock(blockID));
    }

    private Block getBeforeBlock(Block block) {
        return this.getBlock(block.getBeforeBlockID());
    }

    private Block getAfterBlock(Block block) {
        return this.getBlock(block.getAfterBlockID());
    }

    private Block getPlugBlock(Long blockID) {
        return this.getPlugBlock(this.getBlock(blockID));
    }

    private Block getPlugBlock(Block block) {
        return this.getBlock(block.getPlugBlockID());
    }

    private void grabFocus(MouseEvent e) {
        if (e.getSource() instanceof BlockCanvas.Canvas) {
            Point canvasPoint = e.getPoint();
            this.setFocus(canvasPoint, Block.NULL);
            ((BlockCanvas.Canvas)e.getSource()).grabFocus();
        } else if (e.getSource() instanceof RenderableBlock) {
            this.setFocus(((RenderableBlock)e.getSource()).getBlockID());
            ((RenderableBlock)e.getSource()).grabFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.grabFocus(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.grabFocus(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        KeyInputMap.processKeyChar(this.workspace, e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void workspaceEventOccurred(WorkspaceEvent event) {
        switch (event.getEventType()) {
            case 3: {
                RenderableBlock rb;
                if (!(event.getSourceWidget() instanceof Page) || (rb = this.workspace.getEnv().getRenderableBlock(event.getSourceBlockID())) == null) break;
                for (MouseListener l : rb.getMouseListeners()) {
                    if (!l.equals(this)) continue;
                    return;
                }
                rb.addMouseListener(this);
                rb.addKeyListener(this);
                this.setFocus(event.getSourceBlockID());
                rb.grabFocus();
            }
        }
    }

    public String toString() {
        return "FocusManager: " + this.blockFocusPoint + " of " + this.workspace.getEnv().getBlock(this.focusBlock);
    }
}

