/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.clunits;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.FeatureSetImpl;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.PathExtractor;
import com.sun.speech.freetts.PathExtractorImpl;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.cart.CART;
import com.sun.speech.freetts.clunits.ClusterUnit;
import com.sun.speech.freetts.clunits.ClusterUnitDatabase;
import com.sun.speech.freetts.clunits.Cost;
import de.dfki.lt.freetts.ClusterUnitNamer;
import java.io.IOException;
import java.net.URL;

public class ClusterUnitSelector
implements UtteranceProcessor {
    static final boolean DEBUG = false;
    private static final PathExtractor DNAME = new PathExtractorImpl("R:SylStructure.parent.parent.name", true);
    private ClusterUnitDatabase clunitDB;
    private ClusterUnitNamer unitNamer;

    public ClusterUnitSelector(URL url) throws IOException {
        this(url, null);
    }

    public ClusterUnitSelector(URL url, ClusterUnitNamer unitNamer) throws IOException {
        if (url == null) {
            throw new IOException("Can't load cluster unit database");
        }
        boolean binary = url.getPath().endsWith(".bin");
        this.clunitDB = new ClusterUnitDatabase(url, binary);
        this.unitNamer = unitNamer;
    }

    public void processUtterance(Utterance utterance) throws ProcessException {
        Relation segs = utterance.getRelation("Segment");
        utterance.setObject("SampleInfo", this.clunitDB.getSampleInfo());
        utterance.setObject("sts_list", this.clunitDB.getSts());
        Viterbi vd = new Viterbi(segs, this.clunitDB);
        for (Item s = segs.getHead(); s != null; s = s.getNext()) {
            this.setUnitName(s);
        }
        vd.decode();
        if (!vd.result("selected_unit")) {
            utterance.getVoice().error("clunits: can't find path");
        }
        vd.copyFeature("unit_prev_move");
        vd.copyFeature("unit_this_move");
        Relation unitRelation = utterance.createRelation("Unit");
        for (Item s = segs.getHead(); s != null; s = s.getNext()) {
            Item unit = unitRelation.appendItem();
            FeatureSet unitFeatureSet = unit.getFeatures();
            int unitEntry = s.getFeatures().getInt("selected_unit");
            unitFeatureSet.setString("name", s.getFeatures().getString("name"));
            String clunitName = s.getFeatures().getString("clunit_name");
            int unitStart = s.getFeatures().isPresent("unit_this_move") ? s.getFeatures().getInt("unit_this_move") : this.clunitDB.getStart(unitEntry);
            int unitEnd = s.getNext() != null && s.getNext().getFeatures().isPresent("unit_prev_move") ? s.getNext().getFeatures().getInt("unit_prev_move") : this.clunitDB.getEnd(unitEntry);
            unitFeatureSet.setInt("unit_entry", unitEntry);
            ClusterUnit clunit = new ClusterUnit(this.clunitDB, clunitName, unitStart, unitEnd);
            unitFeatureSet.setObject("unit", clunit);
            unitFeatureSet.setInt("unit_start", clunit.getStart());
            unitFeatureSet.setInt("unit_end", clunit.getEnd());
            unitFeatureSet.setInt("instance", unitEntry - this.clunitDB.getUnitIndex(clunitName, 0));
            unitFeatureSet.setInt("target_end", (int)(s.getFeatures().getFloat("end") * (float)this.clunitDB.getSampleInfo().getSampleRate()));
        }
    }

    protected void setUnitName(Item seg) {
        if (this.unitNamer != null) {
            this.unitNamer.setUnitName(seg);
            return;
        }
        String cname = null;
        String segName = seg.getFeatures().getString("name");
        if (segName.equals("pau")) {
            cname = "pau_" + seg.findFeature("p.name");
        } else {
            String dname = ((String)DNAME.findFeature(seg)).toLowerCase();
            cname = segName + "_" + this.stripQuotes(dname);
        }
        seg.getFeatures().setString("clunit_name", cname);
    }

    private String stripQuotes(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public String toString() {
        return "ClusterUnitSelector";
    }

    static void debug(String s) {
    }

    static class ViterbiPath {
        int score = 0;
        int state = 0;
        ViterbiCandidate candidate = null;
        private FeatureSet f = null;
        ViterbiPath from = null;
        ViterbiPath next = null;

        ViterbiPath() {
        }

        void setFeature(String name, Object value) {
            if (this.f == null) {
                this.f = new FeatureSetImpl();
            }
            this.f.setObject(name, value);
        }

        Object getFeature(String name) {
            Object value = null;
            if (this.f != null) {
                value = this.f.getObject(name);
            }
            return value;
        }

        boolean isPresent(String name) {
            if (this.f == null) {
                return false;
            }
            return this.getFeature(name) != null;
        }

        public String toString() {
            return "ViterbiPath score " + this.score + " state " + this.state;
        }
    }

    static class ViterbiCandidate {
        int score = 0;
        Object value = null;
        int ival = 0;
        int pos = 0;
        Item item = null;
        ViterbiCandidate next = null;

        ViterbiCandidate() {
        }

        void set(Object obj) {
            this.value = obj;
        }

        void setInt(int ival) {
            this.ival = ival;
            this.set(new Integer(ival));
        }

        public String toString() {
            return "VC: Score " + this.score + " ival " + this.ival + " Pos " + this.pos;
        }
    }

    static class ViterbiPoint {
        Item item = null;
        int numStates = 0;
        int numPaths = 0;
        ViterbiCandidate cands = null;
        ViterbiPath paths = null;
        ViterbiPath[] statePaths = null;
        ViterbiPoint next = null;

        public ViterbiPoint(Item item) {
            this.item = item;
        }

        public void initPathArray(int size) {
            this.numStates = size;
            this.statePaths = new ViterbiPath[size];
        }

        public void initDynamicPathArray(ViterbiCandidate candidate) {
            int i = 0;
            ViterbiCandidate cc = candidate;
            while (cc != null) {
                cc.pos = i++;
                cc = cc.next;
            }
            this.initPathArray(i);
        }

        public String toString() {
            return " pnt: " + this.numStates + " paths " + this.numPaths;
        }
    }

    static class Viterbi {
        private int numStates = -1;
        private boolean bigIsGood = false;
        private ViterbiPoint timeline = null;
        private ViterbiPoint lastPoint = null;
        private FeatureSet f = null;
        private ClusterUnitDatabase clunitDB;

        public Viterbi(Relation segs, ClusterUnitDatabase db) {
            ViterbiPoint n;
            ViterbiPoint last = null;
            this.clunitDB = db;
            this.f = new FeatureSetImpl();
            Item s = segs.getHead();
            while (true) {
                n = new ViterbiPoint(s);
                if (this.numStates > 0) {
                    n.initPathArray(this.numStates);
                }
                if (last != null) {
                    last.next = n;
                } else {
                    this.timeline = n;
                }
                last = n;
                if (s == null) break;
                s = s.getNext();
            }
            this.lastPoint = n;
            if (this.numStates == 0) {
                this.timeline.paths = new ViterbiPath();
            }
            if (this.numStates == -1) {
                this.timeline.initPathArray(1);
            }
        }

        public void setFeature(String name, Object obj) {
            this.f.setObject(name, obj);
        }

        public Object getFeature(String name) {
            return this.f.getObject(name);
        }

        void decode() {
            ViterbiPoint p = this.timeline;
            while (p.next != null) {
                p.cands = this.getCandidate(p.item);
                if (this.numStates != 0) {
                    if (this.numStates == -1) {
                        p.next.initDynamicPathArray(p.cands);
                    }
                    for (int i = 0; i < p.numStates; ++i) {
                        if ((p != this.timeline || i != 0) && p.statePaths[i] == null) continue;
                        ViterbiCandidate c = p.cands;
                        while (c != null) {
                            ViterbiPath np = this.getPath(p.statePaths[i], c);
                            this.addPaths(p.next, np);
                            c = c.next;
                        }
                    }
                } else {
                    System.err.println("Viterbi.decode: general beam search not implemented");
                }
                p = p.next;
            }
        }

        void addPaths(ViterbiPoint point, ViterbiPath path) {
            ViterbiPath p = path;
            while (p != null) {
                ViterbiPath nextPath = p.next;
                this.addPath(point, p);
                p = nextPath;
            }
        }

        void addPath(ViterbiPoint point, ViterbiPath newPath) {
            if (point.statePaths[newPath.state] == null) {
                point.statePaths[newPath.state] = newPath;
            } else if (this.isBetterThan(newPath.score, point.statePaths[newPath.state].score)) {
                point.statePaths[newPath.state] = newPath;
            }
        }

        private boolean isBetterThan(int a, int b) {
            if (this.bigIsGood) {
                return a > b;
            }
            return a < b;
        }

        boolean result(String feature) {
            if (this.timeline == null || this.timeline.next == null) {
                return true;
            }
            ViterbiPath path = this.findBestPath();
            if (path == null) {
                return false;
            }
            while (path != null) {
                if (path.candidate != null) {
                    path.candidate.item.getFeatures().setObject(feature, path.candidate.value);
                }
                path = path.from;
            }
            return true;
        }

        void copyFeature(String feature) {
            ViterbiPath path = this.findBestPath();
            if (path == null) {
                return;
            }
            while (path != null) {
                if (path.candidate != null && path.isPresent(feature)) {
                    path.candidate.item.getFeatures().setObject(feature, path.getFeature(feature));
                }
                path = path.from;
            }
        }

        private ViterbiCandidate getCandidate(Item item) {
            ViterbiCandidate p;
            String unitType = item.getFeatures().getString("clunit_name");
            CART cart = this.clunitDB.getTree(unitType);
            int[] clist = (int[])cart.interpret(item);
            ViterbiCandidate all = null;
            for (int i = 0; i < clist.length; ++i) {
                p = new ViterbiCandidate();
                p.next = all;
                p.item = item;
                p.score = 0;
                p.setInt(this.clunitDB.getUnitIndex(unitType, clist[i]));
                all = p;
            }
            if (this.clunitDB.getExtendSelections() > 0 && item.getPrevious() != null) {
                ViterbiCandidate lc = (ViterbiCandidate)item.getPrevious().getFeatures().getObject("clunit_cands");
                int e = 0;
                while (lc != null && e < this.clunitDB.getExtendSelections()) {
                    int nu = this.clunitDB.getNextUnit(lc.ival);
                    if (nu != 65535) {
                        ViterbiCandidate gt = all;
                        while (gt != null && nu != gt.ival) {
                            gt = gt.next;
                        }
                        if (gt == null && this.clunitDB.isUnitTypeEqual(nu, all.ival)) {
                            p = new ViterbiCandidate();
                            p.next = all;
                            p.item = item;
                            p.score = 0;
                            p.setInt(nu);
                            all = p;
                            ++e;
                        }
                    }
                    lc = lc.next;
                }
            }
            item.getFeatures().setObject("clunit_cands", all);
            return all;
        }

        private ViterbiPath getPath(ViterbiPath path, ViterbiCandidate candidate) {
            int cost;
            ViterbiPath newPath = new ViterbiPath();
            newPath.candidate = candidate;
            newPath.from = path;
            if (path == null || path.candidate == null) {
                cost = 0;
            } else {
                int u0 = path.candidate.ival;
                int u1 = candidate.ival;
                if (this.clunitDB.getOptimalCoupling() == 1) {
                    Cost oCost = this.getOptimalCouple(u0, u1);
                    if (oCost.u0Move != -1) {
                        newPath.setFeature("unit_prev_move", new Integer(oCost.u0Move));
                    }
                    if (oCost.u1Move != -1) {
                        newPath.setFeature("unit_this_move", new Integer(oCost.u1Move));
                    }
                    cost = oCost.cost;
                } else {
                    cost = this.clunitDB.getOptimalCoupling() == 2 ? this.getOptimalCoupleFrame(u0, u1) : 0;
                }
            }
            newPath.state = candidate.pos;
            newPath.score = path == null ? cost + candidate.score : (cost *= 5) + candidate.score + path.score;
            return newPath;
        }

        private ViterbiPath findBestPath() {
            ViterbiPath bestPath = null;
            int worst = this.bigIsGood ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            int best = worst;
            ViterbiPoint t = this.lastPoint;
            if (this.numStates != 0) {
                for (int i = 0; i < t.numStates; ++i) {
                    if (t.statePaths[i] == null || !this.isBetterThan(t.statePaths[i].score, best)) continue;
                    best = t.statePaths[i].score;
                    bestPath = t.statePaths[i];
                }
            }
            return bestPath;
        }

        Cost getOptimalCouple(int u0, int u1) {
            int u1_p_st;
            int u1_p_end;
            int u0_st;
            Cost cost = new Cost();
            int u1_p = this.clunitDB.getPrevUnit(u1);
            if (u1_p == u0) {
                return cost;
            }
            if (u1_p == 65535 || this.clunitDB.getPhone(u0) != this.clunitDB.getPhone(u1_p)) {
                cost.cost = 10 * this.getOptimalCoupleFrame(u0, u1);
                return cost;
            }
            int u0_end = this.clunitDB.getEnd(u0) - this.clunitDB.getStart(u0);
            int fcount = u0_end - (u0_st = u0_end / 3) < (u1_p_end = this.clunitDB.getEnd(u1_p) - this.clunitDB.getStart(u1_p)) - (u1_p_st = u1_p_end / 3) ? u0_end - u0_st : u1_p_end - u1_p_st;
            int best_u0 = u0_end;
            int best_u1_p = u1_p_end;
            int best_val = Integer.MAX_VALUE;
            for (int i = 0; i < fcount; ++i) {
                int b;
                int a = this.clunitDB.getStart(u0) + u0_st + i;
                int dist = this.getFrameDistance(a, b = this.clunitDB.getStart(u1_p) + u1_p_st + i, this.clunitDB.getJoinWeights(), this.clunitDB.getMcep().getSampleInfo().getNumberOfChannels()) + Math.abs(this.clunitDB.getSts().getFrameSize(a) - this.clunitDB.getSts().getFrameSize(b)) * this.clunitDB.getContinuityWeight();
                if (dist >= best_val) continue;
                best_val = dist;
                best_u0 = u0_st + i;
                best_u1_p = u1_p_st + i;
            }
            cost.u0Move = this.clunitDB.getStart(u0) + best_u0;
            cost.u1Move = this.clunitDB.getStart(u1_p) + best_u1_p;
            cost.cost = 30000 + best_val;
            return cost;
        }

        int getOptimalCoupleFrame(int u0, int u1) {
            if (this.clunitDB.getPrevUnit(u1) == u0) {
                return 0;
            }
            int a = this.clunitDB.getNextUnit(u0) != 65535 ? this.clunitDB.getEnd(u0) : this.clunitDB.getEnd(u0) - 1;
            int b = this.clunitDB.getStart(u1);
            return this.getFrameDistance(a, b, this.clunitDB.getJoinWeights(), this.clunitDB.getMcep().getSampleInfo().getNumberOfChannels()) + Math.abs(this.clunitDB.getSts().getFrameSize(a) - this.clunitDB.getSts().getFrameSize(b)) * this.clunitDB.getContinuityWeight();
        }

        public int getFrameDistance(int a, int b, int[] joinWeights, int order) {
            short[] bv = this.clunitDB.getMcep().getSample(b).getFrameData();
            short[] av = this.clunitDB.getMcep().getSample(a).getFrameData();
            int r = 0;
            for (int i = 0; i < order; ++i) {
                int diff = av[i] - bv[i];
                r += Math.abs(diff) * joinWeights[i] / 65536;
            }
            return r;
        }
    }
}

