/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.util;

import com.sun.speech.freetts.util.Timer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class BulkTimer {
    public static final BulkTimer LOAD = new BulkTimer();
    private static final String SELF = "OverallTime";
    private boolean verbose = false;
    private Map timers = new LinkedHashMap();

    public void start(String name) {
        this.getTimer(name).start();
    }

    public void stop(String name) {
        this.getTimer(name).stop(this.verbose);
    }

    public void start() {
        this.getTimer(SELF).start();
    }

    public void stop() {
        this.getTimer(SELF).stop(this.verbose);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    private Timer getTimer(String name) {
        if (!this.timers.containsKey(name)) {
            this.timers.put(name, new Timer(name));
        }
        return (Timer)this.timers.get(name);
    }

    public void show(String title) {
        long overall = this.getTimer(SELF).getCurrentTime();
        Collection values = this.timers.values();
        Timer.showTimesShortTitle(title);
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Timer t = (Timer)i.next();
            t.showTimes(overall);
        }
    }
}

