/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import org.eclipse.core.internal.dtree.DataTreeNode;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.NodeComparison;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeDelta;
import org.eclipse.core.internal.watson.IDeltaVisitor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DeltaIterator {
    public static final int PRE_ORDER = 0;
    public static final int POST_ORDER = 1;
    private final int order;
    private ElementTreeDelta elementTreeDelta;
    private DeltaDataTree deltaTree;
    private ElementTree oldTree;
    private ElementTree newTree;

    public DeltaIterator() {
        this.order = 0;
    }

    public DeltaIterator(int order) {
        this.order = order;
    }

    private void initialize(ElementTreeDelta tree) {
        this.elementTreeDelta = tree;
        this.deltaTree = tree.getDeltaTree();
        this.oldTree = tree.getParent();
        this.newTree = tree.getElementTree();
    }

    public void iterate(ElementTreeDelta tree, IDeltaVisitor visitor) {
        this.iterate(tree, visitor, (IPath)Path.ROOT);
    }

    public void iterate(ElementTreeDelta tree, IDeltaVisitor visitor, IPath path) {
        this.initialize(tree);
        if (path.isRoot()) {
            IPath[] children = this.deltaTree.getChildren(path);
            int i = 0;
            while (i < children.length) {
                this.iterate(visitor, children[i], 4);
                ++i;
            }
        } else {
            this.iterate(visitor, path);
        }
    }

    private void iterate(IDeltaVisitor visitor, IPath path) {
        DataTreeNode node = (DataTreeNode)this.deltaTree.findNodeAt(path);
        if (node == null) {
            if (this.oldTree.includes(path)) {
                this.iterate(visitor, path, 1);
            } else if (this.newTree.includes(path)) {
                this.iterate(visitor, path, 2);
            }
        } else {
            this.iterate(visitor, path, 4);
        }
    }

    private void iterate(IDeltaVisitor visitor, IPath path, int parentChange) {
        int comparison = 0;
        int realChange = 0;
        Object oldData = null;
        Object newData = null;
        IPath[] children = null;
        switch (parentChange) {
            case 1: {
                comparison = realChange = parentChange;
                newData = this.newTree.getElementData(path);
                children = this.newTree.getChildren(path);
                break;
            }
            case 2: {
                comparison = realChange = parentChange;
                oldData = this.oldTree.getElementData(path);
                children = this.oldTree.getChildren(path);
                break;
            }
            case 4: {
                NodeComparison info = (NodeComparison)this.deltaTree.getData(path);
                comparison = info.getUserComparison();
                realChange = info.getComparison();
                children = this.deltaTree.getChildren(path);
                oldData = info.getOldData();
                newData = info.getNewData();
            }
        }
        Assert.isNotNull(children);
        boolean visitChildren = true;
        if (this.order == 0) {
            visitChildren = visitor.visitElement(this.elementTreeDelta, path, oldData, newData, comparison);
        }
        if (visitChildren) {
            int i = 0;
            while (i < children.length) {
                this.iterate(visitor, children[i], realChange);
                ++i;
            }
        }
        if (this.order == 1) {
            visitor.visitElement(this.elementTreeDelta, path, oldData, newData, comparison);
        }
    }
}

