/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartSashContainer;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.internal.presentations.PresentationFactoryUtil;
import org.eclipse.ui.internal.presentations.PresentationSerializer;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public abstract class PartStack
extends LayoutPart
implements ILayoutContainer {
    private List children = new ArrayList(3);
    protected int appearance = 2;
    private LayoutPart current;
    private boolean ignoreSelectionChanges = false;
    protected IMemento savedPresentationState = null;
    private DefaultStackPresentationSite presentationSite = new DefaultStackPresentationSite(){

        public void close(IPresentablePart part) {
            PartStack.this.close(part);
        }

        public void close(IPresentablePart[] parts) {
            PartStack.this.close(parts);
        }

        public void dragStart(IPresentablePart beingDragged, Point initialLocation, boolean keyboard) {
            PartStack.this.dragStart(beingDragged, initialLocation, keyboard);
        }

        public void dragStart(Point initialLocation, boolean keyboard) {
            PartStack.this.dragStart(null, initialLocation, keyboard);
        }

        public boolean isCloseable(IPresentablePart part) {
            return PartStack.this.isCloseable(part);
        }

        public boolean isPartMoveable(IPresentablePart part) {
            return PartStack.this.isMoveable(part);
        }

        public void selectPart(IPresentablePart toSelect) {
            PartStack.this.presentationSelectionChanged(toSelect);
        }

        public boolean supportsState(int state) {
            return PartStack.this.supportsState(state);
        }

        public void setState(int newState) {
            PartStack.this.setState(newState);
        }

        public IPresentablePart getSelectedPart() {
            return PartStack.this.getSelectedPart();
        }

        public void addSystemActions(IMenuManager menuManager) {
            PartStack.this.addSystemActions(menuManager);
        }

        public boolean isStackMoveable() {
            return PartStack.this.canMoveFolder();
        }
    };

    protected abstract boolean isMoveable(IPresentablePart var1);

    protected abstract boolean isCloseable(IPresentablePart var1);

    protected abstract void addSystemActions(IMenuManager var1);

    protected abstract boolean supportsState(int var1);

    protected abstract boolean canMoveFolder();

    protected abstract void derefPart(LayoutPart var1);

    protected abstract boolean allowsDrop(PartPane var1);

    protected static void appendToGroupIfPossible(IMenuManager m, String groupId, ContributionItem item) {
        try {
            m.appendToGroup(groupId, (IContributionItem)item);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            m.add((IContributionItem)item);
        }
    }

    public PartStack(int appearance) {
        super("PartStack");
        this.appearance = appearance;
    }

    protected IPresentablePart getSelectedPart() {
        if (this.current == null) {
            return null;
        }
        return this.current.getPresentablePart();
    }

    protected IStackPresentationSite getPresentationSite() {
        return this.presentationSite;
    }

    public void testInvariants() {
        Control focusControl = Display.getCurrent().getFocusControl();
        boolean currentFound = false;
        LayoutPart[] children = this.getChildren();
        int idx = 0;
        while (idx < children.length) {
            LayoutPart child = children[idx];
            Assert.isNotNull((Object)child, (String)"null children are not allowed in PartStack");
            Assert.isTrue((child instanceof PartPlaceholder || child instanceof PartPane ? 1 : 0) != 0, (String)"PartStack can only contain PartPlaceholders or PartPanes");
            IPresentablePart part = child.getPresentablePart();
            if (child instanceof PartPane) {
                Assert.isNotNull((Object)part, (String)"All PartPanes must have a non-null IPresentablePart");
            }
            ILayoutContainer childContainer = child.getContainer();
            if (!(child instanceof PartPlaceholder)) {
                if (this.isDisposed()) {
                    if (childContainer != null) {
                        Assert.isTrue((childContainer == this ? 1 : 0) != 0, (String)"PartStack has a child that thinks it has a different parent");
                    }
                } else {
                    Assert.isTrue((childContainer == this ? 1 : 0) != 0, (String)"PartStack has a child that thinks it has a different parent");
                    if (SwtUtil.isChild(child.getControl(), focusControl)) {
                        Assert.isTrue((child == this.current ? 1 : 0) != 0, (String)"The part with focus is not the selected part");
                    }
                }
            }
            if (child == this.current) {
                currentFound = true;
            }
            child.testInvariants();
            ++idx;
        }
        if (!this.isDisposed() && this.getPresentableParts().size() > 0) {
            StackPresentation presentation;
            Assert.isTrue((boolean)currentFound);
            if (!this.isDisposed() && SwtUtil.isChild((presentation = this.getPresentation()).getControl(), focusControl)) {
                Assert.isTrue((this.getActive() == 1 ? 1 : 0) != 0, (String)"The presentation has focus but does not have the active appearance");
            }
        }
    }

    public void describeLayout(StringBuffer buf) {
        int activeState = this.getActive();
        if (activeState == 1) {
            buf.append("active ");
        } else if (activeState == 2) {
            buf.append("active_nofocus ");
        }
        buf.append("(");
        LayoutPart[] children = this.getChildren();
        int visibleChildren = 0;
        int idx = 0;
        while (idx < children.length) {
            LayoutPart next = children[idx];
            if (!(next instanceof PartPlaceholder)) {
                if (idx > 0) {
                    buf.append(", ");
                }
                if (next == this.current) {
                    buf.append("*");
                }
                next.describeLayout(buf);
                ++visibleChildren;
            }
            ++idx;
        }
        buf.append(")");
    }

    public void add(LayoutPart child) {
        this.children.add(child);
        this.showPart(child, null);
    }

    protected void add(LayoutPart newChild, Object cookie) {
        this.children.add(newChild);
        this.showPart(newChild, cookie);
    }

    public boolean allowsAutoFocus() {
        if (this.presentationSite.getState() == 0) {
            return false;
        }
        ILayoutContainer parent = this.getContainer();
        return parent == null || parent.allowsAutoFocus();
    }

    protected void close(IPresentablePart[] parts) {
        int idx = 0;
        while (idx < parts.length) {
            IPresentablePart part = parts[idx];
            this.close(part);
            ++idx;
        }
    }

    protected void close(IPresentablePart part) {
        if (!this.presentationSite.isCloseable(part)) {
            return;
        }
        LayoutPart layoutPart = this.getPaneFor(part);
        if (layoutPart != null && layoutPart instanceof PartPane) {
            PartPane viewPane = (PartPane)layoutPart;
            viewPane.doHide();
        }
    }

    public boolean isDisposed() {
        return this.getPresentation() == null;
    }

    protected AbstractPresentationFactory getFactory() {
        AbstractPresentationFactory factory = ((WorkbenchWindow)this.getPage().getWorkbenchWindow()).getWindowConfigurer().getPresentationFactory();
        return factory;
    }

    public void createControl(Composite parent) {
        if (!this.isDisposed()) {
            return;
        }
        AbstractPresentationFactory factory = this.getFactory();
        PresentationSerializer serializer = new PresentationSerializer(this.getPresentableParts());
        StackPresentation presentation = PresentationFactoryUtil.createPresentation(factory, this.appearance, parent, this.presentationSite, serializer, this.savedPresentationState);
        this.createControl(parent, presentation);
    }

    public void createControl(Composite parent, StackPresentation presentation) {
        Assert.isTrue((boolean)this.isDisposed());
        if (this.presentationSite.getPresentation() != null) {
            return;
        }
        this.presentationSite.setPresentation(presentation);
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart part = (LayoutPart)iter.next();
            this.showPart(part, null);
        }
        Control ctrl = this.getPresentation().getControl();
        DragUtil.addDragTarget(ctrl, new IDragOverListener(){

            public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
                int closestSide;
                if (!(draggedObject instanceof PartPane)) {
                    return null;
                }
                PartPane pane = (PartPane)draggedObject;
                if (!PartStack.this.allowsDrop(pane)) {
                    return null;
                }
                if (pane.getWorkbenchWindow() != PartStack.this.getWorkbenchWindow()) {
                    return null;
                }
                Point controlCoordinates = currentControl.getParent().toControl(position);
                Rectangle bounds = currentControl.getBounds();
                if (Geometry.getDistanceFromEdge((Rectangle)bounds, (Point)controlCoordinates, (int)(closestSide = Geometry.getClosestSide((Rectangle)bounds, (Point)controlCoordinates))) < 5) {
                    return null;
                }
                StackDropResult dropResult = PartStack.this.getPresentation().dragOver(currentControl, position);
                if (dropResult == null) {
                    return null;
                }
                return new IDropTarget(this, pane, dropResult){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ PartPane val$pane;
                    private final /* synthetic */ StackDropResult val$dropResult;
                    {
                        this.this$1 = var1_1;
                        this.val$pane = partPane;
                        this.val$dropResult = stackDropResult;
                    }

                    public void drop() {
                        if (this.val$pane.getContainer() != 2.access$0(this.this$1)) {
                            2.access$0(this.this$1).derefPart(this.val$pane);
                            this.val$pane.reparent(2.access$0(this.this$1).getParent());
                        } else {
                            2.access$0(this.this$1).remove(this.val$pane);
                        }
                        2.access$0(this.this$1).add(this.val$pane, this.val$dropResult.getCookie());
                        2.access$0(this.this$1).setSelection(this.val$pane);
                        this.val$pane.setFocus();
                    }

                    public Cursor getCursor() {
                        return DragCursors.getCursor(5);
                    }

                    public Rectangle getSnapRectangle() {
                        return this.val$dropResult.getSnapRectangle();
                    }
                };
            }

            static /* synthetic */ PartStack access$0(2 var0) {
                return var0.PartStack.this;
            }
        });
        ctrl.setData((Object)this);
        this.updateActions();
        if (this.current instanceof PartPlaceholder) {
            this.current = null;
            this.updateContainerVisibleTab();
        }
        this.refreshPresentationSelection();
        Rectangle bounds = presentation.getControl().getBounds();
        int minimumHeight = this.getMinimumHeight();
        if (this.presentationSite.getState() == 0 && bounds.height != minimumHeight) {
            bounds.width = this.getMinimumWidth();
            bounds.height = minimumHeight;
            this.getPresentation().setBounds(bounds);
        }
    }

    protected void savePresentationState() {
        if (this.isDisposed()) {
            return;
        }
        XMLMemento memento = XMLMemento.createWriteRoot("presentation");
        memento.putString("id", this.getFactory().getId());
        PresentationSerializer serializer = new PresentationSerializer(this.getPresentableParts());
        this.getPresentation().saveState(serializer, memento);
        this.savedPresentationState = memento;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.savePresentationState();
        this.presentationSite.dispose();
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            next.setContainer(null);
        }
    }

    public void findSashes(LayoutPart part, PartPane.Sashes sashes) {
        ILayoutContainer container = this.getContainer();
        if (container != null) {
            container.findSashes(this, sashes);
        }
    }

    private void forceLayout() {
        PartSashContainer cont = (PartSashContainer)this.getContainer();
        if (cont != null) {
            LayoutTree tree = cont.getLayoutTree();
            tree.setBounds(this.getParent().getClientArea());
        }
    }

    public Rectangle getBounds() {
        if (this.getPresentation() == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.getPresentation().getControl().getBounds();
    }

    public LayoutPart[] getChildren() {
        return this.children.toArray(new LayoutPart[this.children.size()]);
    }

    public Control getControl() {
        StackPresentation presentation = this.getPresentation();
        if (presentation == null) {
            return null;
        }
        return presentation.getControl();
    }

    public int getItemCount() {
        if (this.isDisposed()) {
            return this.children.size();
        }
        return this.getPresentableParts().size();
    }

    public int getMinimumHeight() {
        if (this.getPresentation() == null) {
            return 0;
        }
        return this.getPresentation().computeMinimumSize().y;
    }

    protected LayoutPart getPaneFor(IPresentablePart part) {
        if (part == null) {
            return null;
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            if (next.getPresentablePart() != part) continue;
            return next;
        }
        return null;
    }

    public Composite getParent() {
        return this.getControl().getParent();
    }

    private IPresentablePart getPresentablePartAtIndex(int idx) {
        List presentableParts = this.getPresentableParts();
        if (idx >= 0 && idx < presentableParts.size()) {
            return (IPresentablePart)presentableParts.get(idx);
        }
        return null;
    }

    public List getPresentableParts() {
        ArrayList<IPresentablePart> result = new ArrayList<IPresentablePart>(this.children.size());
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart part = (LayoutPart)iter.next();
            IPresentablePart presentablePart = part.getPresentablePart();
            if (presentablePart == null) continue;
            result.add(presentablePart);
        }
        return result;
    }

    protected StackPresentation getPresentation() {
        return this.presentationSite.getPresentation();
    }

    public PartPane getVisiblePart() {
        if (this.current instanceof PartPane) {
            return (PartPane)this.current;
        }
        return null;
    }

    private void presentationSelectionChanged(IPresentablePart newSelection) {
        Window window;
        if (this.ignoreSelectionChanges) {
            return;
        }
        LayoutPart newPart = this.getPaneFor(newSelection);
        Assert.isNotNull((Object)newPart);
        if (newPart == this.current) {
            return;
        }
        this.setSelection(newPart);
        if (newPart != null) {
            newPart.setFocus();
        }
        if ((window = this.getWindow()) instanceof DetachedWindow) {
            window.getShell().setText(newSelection.getTitle());
        }
    }

    public void remove(LayoutPart child) {
        IPresentablePart presentablePart = child.getPresentablePart();
        this.children.remove(child);
        StackPresentation presentation = this.getPresentation();
        if (presentablePart != null && presentation != null) {
            this.ignoreSelectionChanges = true;
            presentation.removePart(presentablePart);
            this.ignoreSelectionChanges = false;
        }
        if (!this.isDisposed()) {
            child.setContainer(null);
        }
        if (child == this.current) {
            this.updateContainerVisibleTab();
        }
    }

    public void reparent(Composite newParent) {
        if (!newParent.isReparentable()) {
            return;
        }
        Control control = this.getControl();
        if (control == null || control.getParent() == newParent) {
            return;
        }
        super.reparent(newParent);
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            next.reparent(newParent);
        }
    }

    public void replace(LayoutPart oldChild, LayoutPart newChild) {
        newChild.getPresentablePart();
        int idx = this.children.indexOf(oldChild);
        int numPlaceholders = 0;
        int i = 0;
        while (i < idx) {
            if (this.children.get(i) instanceof PartPlaceholder) {
                ++numPlaceholders;
            }
            ++i;
        }
        Integer cookie = new Integer(idx - numPlaceholders);
        this.children.add(idx, newChild);
        this.showPart(newChild, cookie);
        if (oldChild == this.current && !(newChild instanceof PartPlaceholder)) {
            this.setSelection(newChild);
        }
        this.remove(oldChild);
    }

    public boolean resizesVertically() {
        return this.presentationSite.getState() != 0;
    }

    public IStatus restoreState(IMemento memento) {
        Integer expanded;
        String activeTabID = memento.getString("activePageID");
        IMemento[] children = memento.getChildren("page");
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IMemento childMem = children[i];
                String partID = childMem.getString("content");
                PartPlaceholder part = new PartPlaceholder(partID);
                part.setContainer(this);
                this.add(part);
                if (partID.equals(activeTabID)) {
                    this.current = part;
                }
                ++i;
            }
        }
        this.setState((expanded = memento.getInteger("expanded")) == null || expanded != 0 ? 2 : 0);
        Integer appearance = memento.getInteger("appearance");
        if (appearance != null) {
            this.appearance = appearance;
        }
        this.savedPresentationState = null;
        IMemento[] presentationMementos = memento.getChildren("presentation");
        int idx = 0;
        while (idx < presentationMementos.length) {
            IMemento child = presentationMementos[idx];
            String id = child.getString("id");
            if (Util.equals(id, this.getFactory().getId())) {
                this.savedPresentationState = child;
                break;
            }
            ++idx;
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus saveState(IMemento memento) {
        if (this.current != null) {
            memento.putString("activePageID", this.current.getCompoundId());
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            LayoutPart next = (LayoutPart)iter.next();
            IMemento childMem = memento.createChild("page");
            IPresentablePart part = next.getPresentablePart();
            String tabText = "LabelNotFound";
            if (part != null) {
                tabText = part.getName();
            }
            childMem.putString("label", tabText);
            childMem.putString("content", next.getCompoundId());
        }
        memento.putInteger("expanded", this.presentationSite.getState() == 0 ? 0 : 2);
        memento.putInteger("appearance", this.appearance);
        this.savePresentationState();
        if (this.savedPresentationState != null) {
            IMemento presentationState = memento.createChild("presentation");
            presentationState.putMemento(this.savedPresentationState);
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    protected WorkbenchPage getPage() {
        WorkbenchWindow window = (WorkbenchWindow)this.getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return (WorkbenchPage)window.getActivePage();
    }

    public void setActive(int activeState) {
        if (activeState != 0 && this.presentationSite.getState() == 0) {
            this.setState(2);
        }
        this.presentationSite.setActive(activeState);
    }

    public int getActive() {
        return this.presentationSite.getActive();
    }

    public void setBounds(Rectangle r) {
        if (this.getPresentation() != null) {
            this.getPresentation().setBounds(r);
        }
    }

    public void setSelection(LayoutPart part) {
        if (this.current == part) {
            return;
        }
        this.current = part;
        if (!this.isDisposed()) {
            this.updateActions();
        }
        this.refreshPresentationSelection();
    }

    protected void updateActions() {
    }

    private void refreshPresentationSelection() {
        if (this.current != null) {
            IPresentablePart presentablePart = this.current.getPresentablePart();
            StackPresentation presentation = this.getPresentation();
            if (presentablePart != null && presentation != null) {
                this.current.createControl(this.getParent());
                if (this.current.getControl().getParent() != this.getControl().getParent()) {
                    this.current.reparent(this.getControl().getParent());
                }
                this.current.moveAbove(this.getPresentation().getControl());
                presentation.selectPart(presentablePart);
            }
        }
    }

    protected void setState(int newState) {
        WorkbenchPage page;
        if (!this.supportsState(newState) || newState == this.presentationSite.getState()) {
            return;
        }
        int oldState = this.presentationSite.getState();
        if (this.current != null) {
            if (newState == 1) {
                PartPane pane = this.getVisiblePart();
                if (pane != null) {
                    pane.doZoom();
                }
            } else {
                this.presentationSite.setPresentationState(newState);
                page = this.getPage();
                if (page != null) {
                    if (page.isZoomed()) {
                        page.zoomOut();
                    }
                    this.updateControlBounds();
                    if (oldState == 0) {
                        this.forceLayout();
                    }
                }
            }
        }
        if (this.presentationSite.getState() == 0 && (page = this.getPage()) != null) {
            page.refreshActiveView();
        }
    }

    public void setZoomed(boolean isZoomed) {
        super.setZoomed(isZoomed);
        if (isZoomed) {
            this.presentationSite.setPresentationState(1);
        } else if (this.presentationSite.getState() == 1) {
            this.presentationSite.setPresentationState(2);
        }
    }

    private void showPart(LayoutPart part, Object cookie) {
        if (this.isDisposed()) {
            return;
        }
        part.setContainer(this);
        IPresentablePart presentablePart = part.getPresentablePart();
        if (presentablePart == null) {
            return;
        }
        this.presentationSite.getPresentation().addPart(presentablePart, cookie);
        if (this.current == null) {
            this.setSelection(part);
        }
    }

    private void updateContainerVisibleTab() {
        List presentableParts;
        LayoutPart[] parts = this.getChildren();
        if (parts.length < 1) {
            this.setSelection(null);
            return;
        }
        PartPane selPart = null;
        int topIndex = 0;
        WorkbenchPage page = this.getPage();
        if (page != null) {
            IWorkbenchPartReference[] sortedPartsArray = page.getSortedParts();
            List<IWorkbenchPartReference> sortedParts = Arrays.asList(sortedPartsArray);
            int i = 0;
            while (i < parts.length) {
                IWorkbenchPartReference part;
                int index;
                if (parts[i] instanceof PartPane && (index = sortedParts.indexOf(part = ((PartPane)parts[i]).getPartReference())) >= topIndex) {
                    topIndex = index;
                    selPart = (PartPane)parts[i];
                }
                ++i;
            }
        }
        if (selPart == null && (presentableParts = this.getPresentableParts()).size() != 0) {
            IPresentablePart part = (IPresentablePart)this.getPresentableParts().get(0);
            selPart = (PartPane)this.getPaneFor(part);
        }
        this.setSelection(selPart);
    }

    private void updateControlBounds() {
        StackPresentation presentation = this.getPresentation();
        if (presentation != null) {
            Rectangle bounds = presentation.getControl().getBounds();
            int minimumHeight = this.getMinimumHeight();
            if (this.presentationSite.getState() == 0 && bounds.height != minimumHeight) {
                bounds.width = this.getMinimumWidth();
                bounds.height = minimumHeight;
                this.getPresentation().setBounds(bounds);
                this.forceLayout();
            }
        }
    }

    public void showSystemMenu() {
        this.getPresentation().showSystemMenu();
    }

    public void showPaneMenu() {
        this.getPresentation().showPaneMenu();
    }

    public void showPartList() {
        this.getPresentation().showPartList();
    }

    public Control[] getTabList(LayoutPart part) {
        if (part != null) {
            IPresentablePart presentablePart = part.getPresentablePart();
            StackPresentation presentation = this.getPresentation();
            if (presentablePart != null && presentation != null) {
                return presentation.getTabList(presentablePart);
            }
        }
        return new Control[0];
    }

    public void dragStart(IPresentablePart beingDragged, Point initialLocation, boolean keyboard) {
        LayoutPart pane;
        if (beingDragged == null) {
            if (this.canMoveFolder()) {
                if (this.presentationSite.getState() == 1) {
                    this.setState(2);
                }
                DragUtil.performDrag(this, Geometry.toDisplay((Control)this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds()), initialLocation, !keyboard);
            }
        } else if (this.presentationSite.isPartMoveable(beingDragged) && (pane = this.getPaneFor(beingDragged)) != null) {
            if (this.presentationSite.getState() == 1) {
                this.presentationSite.setState(2);
            }
            DragUtil.performDrag(pane, Geometry.toDisplay((Control)this.getParent(), (Rectangle)this.getPresentation().getControl().getBounds()), initialLocation, !keyboard);
        }
    }

    public IMemento getSavedPresentationState() {
        return this.savedPresentationState;
    }
}

