/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.registry.IViewDescriptor;

public class ShowViewAction
extends Action
implements IPluginContribution {
    private IWorkbenchWindow window;
    private IViewDescriptor desc;

    protected ShowViewAction(IWorkbenchWindow window, IViewDescriptor desc) {
        super("");
        String accel = desc.getAccelerator();
        String label = desc.getLabel();
        this.setText(accel == null ? label : String.valueOf(label) + "@" + accel);
        this.setImageDescriptor(desc.getImageDescriptor());
        this.setToolTipText(label);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.show_view_action_context");
        this.window = window;
        this.desc = desc;
    }

    public void run() {
        IWorkbenchPage page = this.window.getActivePage();
        if (page != null) {
            try {
                page.showView(this.desc.getID());
            }
            catch (PartInitException e) {
                ErrorDialog.openError((Shell)this.window.getShell(), (String)WorkbenchMessages.getString("ShowView.errorTitle"), (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    public boolean fromPlugin() {
        return this.desc instanceof IPluginContribution && ((IPluginContribution)((Object)this.desc)).getPluginId() != null;
    }

    public String getLocalId() {
        return this.desc.getId();
    }

    public String getPluginId() {
        return this.desc instanceof IPluginContribution ? ((IPluginContribution)((Object)this.desc)).getPluginId() : null;
    }
}

