/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ConfigurationPreferences
extends EclipsePreferences {
    private int segmentCount;
    private String qualifier;
    private IPath location;
    private IEclipsePreferences loadLevel;
    private static Set loadedNodes = new HashSet();
    private static boolean initialized = false;
    private static IPath baseLocation;

    static {
        URL url = InternalPlatform.getDefault().getConfigurationLocation().getURL();
        if (url != null) {
            baseLocation = new Path(url.getFile());
        }
    }

    public ConfigurationPreferences() {
        this(null, null);
    }

    private ConfigurationPreferences(IEclipsePreferences parent, String name) {
        super(parent, name);
        this.initializeChildren();
        String path = this.absolutePath();
        this.segmentCount = EclipsePreferences.getSegmentCount(path);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = EclipsePreferences.getSegment(path, 1);
        if (this.qualifier == null) {
            return;
        }
        if (baseLocation != null) {
            this.location = this.computeLocation(baseLocation, this.qualifier);
        }
    }

    protected IPath getLocation() {
        return this.location;
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            EclipsePreferences node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void initializeChildren() {
        if (initialized) return;
        if (this.parent == null) {
            return;
        }
        try {
            block10: {
                ConfigurationPreferences configurationPreferences = this;
                // MONITORENTER : configurationPreferences
                if (baseLocation != null) break block10;
                // MONITOREXIT : configurationPreferences
                Object var4_2 = null;
                initialized = true;
                return;
            }
            String[] names = this.computeChildren(baseLocation);
            int i = 0;
            while (true) {
                if (i >= names.length) {
                    // MONITOREXIT : configurationPreferences
                    break;
                }
                this.addChild(names[i], null);
                ++i;
            }
            Object var4_4 = null;
            initialized = true;
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            initialized = true;
            throw throwable;
        }
    }

    protected EclipsePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new ConfigurationPreferences(nodeParent, nodeName);
    }
}

