/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.speech;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.jpn.xucker.speech.WavGenerator;

public class linetext2wav {
    public linetext2wav(String input, String output) {
        try {
            WavGenerator generator = new WavGenerator();
            String textline = IOUtils.toString((Reader)new FileReader(new File(input)));
            String[] lines = textline.split(System.getProperty("line.separator"));
            int i = 0;
            while (i < lines.length) {
                if (this.isValidLine(lines[i])) {
                    generator.generatteWav(lines[i].toLowerCase(), new File(output, String.valueOf(lines[i].toLowerCase()) + ".wav"));
                } else {
                    System.out.println("invalid " + lines[i]);
                }
                ++i;
            }
            generator.dispose();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isValidLine(String line) {
        String nonfileString = "\\/:*?\"<>|";
        if (line.length() <= 0) {
            return false;
        }
        int i = 0;
        while (i < nonfileString.length()) {
            if (line.indexOf(nonfileString.charAt(i)) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("textline2wav inputtext outputdir");
        } else {
            new linetext2wav(args[0], args[1]);
        }
    }
}

