/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.ITocsChangedListener;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.IndexingOperation;
import org.eclipse.help.internal.search.PluginVersionInfo;
import org.eclipse.help.internal.search.ProgressDistributor;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.search.SearchIndexWithIndexingProgress;
import org.eclipse.help.internal.search.SearchProgressMonitor;

public class SearchManager
implements ITocsChangedListener {
    private Map indexes = new HashMap();
    private Map analyzerDescriptors = new HashMap();

    public SearchManager() {
        HelpPlugin.getDefault().addTocsChangedListener((ITocsChangedListener)this);
    }

    public SearchIndexWithIndexingProgress getIndex(String locale) {
        Map map = this.indexes;
        synchronized (map) {
            Object index = this.indexes.get(locale);
            if (index == null) {
                index = new SearchIndexWithIndexingProgress(locale, this.getAnalyzer(locale), HelpPlugin.getTocManager());
                this.indexes.put(locale, index);
            }
            return (SearchIndexWithIndexingProgress)index;
        }
    }

    private AnalyzerDescriptor getAnalyzer(String locale) {
        AnalyzerDescriptor analyzerDesc = (AnalyzerDescriptor)this.analyzerDescriptors.get(locale);
        if (analyzerDesc != null) {
            return analyzerDesc;
        }
        analyzerDesc = new AnalyzerDescriptor(locale);
        this.analyzerDescriptors.put(locale, analyzerDesc);
        String lang = analyzerDesc.getLang();
        if (locale != null && !locale.equals(lang)) {
            this.analyzerDescriptors.put(lang, analyzerDesc);
        }
        return analyzerDesc;
    }

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        SearchIndexWithIndexingProgress index;
        block3: {
            index = this.getIndex(searchQuery.getLocale());
            try {
                this.ensureIndexUpdated(pm, index);
                if (!index.exists()) {
                    return;
                }
            }
            catch (IndexingOperation.IndexingException indexingException) {
                if (!HelpBasePlugin.DEBUG_SEARCH) break block3;
                System.out.println(String.valueOf(this.getClass().getName()) + " IndexUpdateException occurred.");
            }
        }
        index.search(searchQuery, collector);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ensureIndexUpdated(IProgressMonitor pm, SearchIndexWithIndexingProgress index) throws OperationCanceledException, IndexingOperation.IndexingException {
        boolean configurationLocked;
        ProgressDistributor progressDistrib;
        block11: {
            block10: {
                block9: {
                    progressDistrib = index.getProgressDistributor();
                    progressDistrib.addMonitor(pm);
                    configurationLocked = false;
                    try {
                        block8: {
                            if (1 != BaseHelpSystem.getMode()) {
                                try {
                                    configurationLocked = index.tryLock();
                                    if (configurationLocked) break block8;
                                    pm.beginTask("", 1);
                                    pm.worked(1);
                                    pm.done();
                                    Object var5_5 = null;
                                }
                                catch (OverlappingFileLockException overlappingFileLockException) {}
                                progressDistrib.removeMonitor(pm);
                                if (!configurationLocked) return;
                                break block9;
                            }
                        }
                        if (index.isClosed() || !index.needsUpdating()) {
                            pm.beginTask("", 1);
                            pm.worked(1);
                            pm.done();
                            break block10;
                        }
                        if (pm instanceof SearchProgressMonitor) {
                            ((SearchProgressMonitor)pm).started();
                        }
                        this.updateIndex(pm, index, progressDistrib);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        progressDistrib.removeMonitor(pm);
                        if (!configurationLocked) throw throwable;
                        index.releaseLock();
                        throw throwable;
                    }
                }
                index.releaseLock();
                return;
            }
            Object var5_6 = null;
            progressDistrib.removeMonitor(pm);
            if (!configurationLocked) return;
            index.releaseLock();
            return;
        }
        Object var5_8 = null;
        progressDistrib.removeMonitor(pm);
        if (!configurationLocked) return;
        index.releaseLock();
    }

    private synchronized void updateIndex(IProgressMonitor pm, SearchIndex index, ProgressDistributor progressDistrib) throws IndexingOperation.IndexingException {
        if (index.isClosed() || !index.needsUpdating()) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
            return;
        }
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("SearchManager indexing " + index.getLocale());
        }
        try {
            PluginVersionInfo versions = index.getDocPlugins();
            if (versions == null) {
                pm.beginTask("", 1);
                pm.worked(1);
                pm.done();
                return;
            }
            IndexingOperation indexer = new IndexingOperation(index);
            indexer.execute(progressDistrib);
            return;
        }
        catch (OperationCanceledException oce) {
            progressDistrib.operationCanceled();
            HelpBasePlugin.logWarning(HelpBaseResources.getString("Search_cancelled"));
            throw oce;
        }
    }

    public void close() {
        Map map = this.indexes;
        synchronized (map) {
            Iterator it = this.indexes.values().iterator();
            while (it.hasNext()) {
                ((SearchIndex)it.next()).close();
            }
        }
    }

    public synchronized void tocsChanged() {
        ArrayList activeIndexes = new ArrayList();
        Map map = this.indexes;
        synchronized (map) {
            activeIndexes.addAll(this.indexes.values());
        }
        Iterator it = activeIndexes.iterator();
        while (it.hasNext()) {
            SearchIndexWithIndexingProgress ix = (SearchIndexWithIndexingProgress)it.next();
            ix.close();
            Map map2 = this.indexes;
            synchronized (map2) {
                this.indexes.remove(ix.getLocale());
                ProgressDistributor pm = ix.getProgressDistributor();
                pm.beginTask("", 1);
                pm.worked(1);
                pm.done();
                SearchProgressMonitor.reinit(ix.getLocale());
            }
        }
    }
}

