/*
 * Decompiled with CFR 0.152.
 */
package mbrola;

import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MbrolaPlugin
extends AbstractUIPlugin {
    private static MbrolaPlugin plugin;
    private ResourceBundle resourceBundle;
    private String mboraDirectoryName = "mbrola";

    public MbrolaPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("mbrola.MbrolaPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static MbrolaPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MbrolaPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public File getMboraDirectory() {
        File file;
        if (System.getProperty("mbrola.home") != null) {
            return new File(System.getProperty("mbrola.home"));
        }
        if (Platform.getOS().equals("win32") ? (file = new File("C:\\Program Files\\" + this.mboraDirectoryName)).exists() && file.isDirectory() : (file = new File("/usr/local/bin/" + this.mboraDirectoryName)).exists() && file.isDirectory()) {
            return file;
        }
        File underPluginMbrola = new File(this.toPluginDir(this), this.mboraDirectoryName);
        if (underPluginMbrola.exists() && underPluginMbrola.isDirectory()) {
            return underPluginMbrola;
        }
        return null;
    }

    private File toPluginDir(AbstractUIPlugin plugin) {
        return new File(Platform.getInstallLocation().getURL().getPath(), "plugins/" + plugin.getBundle().getSymbolicName() + "_" + plugin.getBundle().getHeaders().get("Bundle-Version"));
    }

    public File getMboraExecuteFile() {
        File mboraDir = this.getMboraDirectory();
        if (mboraDir != null) {
            if (Platform.getOS().equals("win32")) {
                File file = new File(mboraDir, "mbrola.exe");
                if (file.exists()) {
                    return file;
                }
                file = new File(mboraDir, "mbrola");
                if (file.exists()) {
                    return file;
                }
            }
        } else {
            File file = new File(mboraDir, "mbrola");
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    public String[] getMboraDataNames() {
        File dir = this.getMboraDirectory();
        Vector<String> dirNameList = new Vector<String>();
        if (dir.exists()) {
            int i = 1;
            while (i <= 3) {
                File tmp = new File(dir, "us" + i);
                if (tmp.isDirectory()) {
                    dirNameList.add("us" + i);
                }
                ++i;
            }
            return dirNameList.toArray(new String[dirNameList.size()]);
        }
        return new String[0];
    }
}

