/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.msg;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageFormat {
    protected ResourceBundle bundle;
    protected Locale locale;

    public MessageFormat(String bundleName) {
        this.init(bundleName, Locale.getDefault(), this.getClass());
    }

    public MessageFormat(String bundleName, Locale locale) {
        this.init(bundleName, locale, this.getClass());
    }

    public MessageFormat(String bundleName, Locale locale, Class clazz) {
        this.init(bundleName, locale, clazz);
    }

    protected void init(final String bundleName, final Locale locale, final Class clazz) {
        this.bundle = (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader loader = clazz.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                try {
                    return ResourceBundle.getBundle(bundleName, locale, loader);
                }
                catch (MissingResourceException missingResourceException) {
                    return null;
                }
            }
        });
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getString(String msg) {
        if (this.bundle == null) {
            return msg;
        }
        try {
            return this.bundle.getString(msg);
        }
        catch (MissingResourceException missingResourceException) {
            return msg;
        }
    }

    public String getString(String msg, Object arg) {
        return this.getString(msg, new Object[]{arg});
    }

    public String getString(String msg, int arg) {
        return this.getString(msg, new Object[]{Integer.toString(arg)});
    }

    public String getString(String msg, char arg) {
        return this.getString(msg, new Object[]{String.valueOf(arg)});
    }

    public String getString(String msg, Object arg1, Object arg2) {
        return this.getString(msg, new Object[]{arg1, arg2});
    }

    public String getString(String msg, Object[] args) {
        String format = msg;
        if (this.bundle != null) {
            try {
                format = this.bundle.getString(msg);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return MessageFormat.format(format, args);
    }

    public static String format(String format, Object[] args) {
        StringBuffer answer = new StringBuffer();
        String[] argStrings = new String[args.length];
        int i = 0;
        while (i < args.length) {
            argStrings[i] = args[i] == null ? "<null>" : args[i].toString();
            ++i;
        }
        int lastI = 0;
        int i2 = format.indexOf(123, 0);
        while (i2 >= 0) {
            if (i2 != 0 && format.charAt(i2 - 1) == '\\') {
                if (i2 != 1) {
                    answer.append(format.substring(lastI, i2 - 1));
                }
                answer.append('{');
                lastI = i2 + 1;
            } else if (i2 > format.length() - 3) {
                answer.append(format.substring(lastI, format.length()));
                lastI = format.length();
            } else {
                byte argnum = (byte)Character.digit(format.charAt(i2 + 1), 10);
                if (argnum < 0 || format.charAt(i2 + 2) != '}') {
                    answer.append(format.substring(lastI, i2 + 1));
                    lastI = i2 + 1;
                } else {
                    answer.append(format.substring(lastI, i2));
                    if (argnum >= argStrings.length) {
                        answer.append("<missing argument>");
                    } else {
                        answer.append(argStrings[argnum]);
                    }
                    lastI = i2 + 3;
                }
            }
            i2 = format.indexOf(123, lastI);
        }
        if (lastI < format.length()) {
            answer.append(format.substring(lastI, format.length()));
        }
        return answer.toString();
    }
}

